'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    CELL_WIDTH: function() {
        return CELL_WIDTH;
    },
    tableSelectionCellClassNames: function() {
        return tableSelectionCellClassNames;
    },
    useTableSelectionCellStyles_unstable: function() {
        return useTableSelectionCellStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttabster = require("@fluentui/react-tabster");
const _reacttheme = require("@fluentui/react-theme");
const CELL_WIDTH = 44;
const tableSelectionCellClassNames = {
    root: 'fui-TableSelectionCell',
    checkboxIndicator: 'fui-TableSelectionCell__checkboxIndicator',
    radioIndicator: 'fui-TableSelectionCell__radioIndicator'
};
const useTableLayoutStyles = (0, _react.makeStyles)({
    root: {
        display: 'table-cell',
        width: `${CELL_WIDTH}px`
    }
});
const useFlexLayoutStyles = (0, _react.makeStyles)({
    root: {
        display: 'flex',
        flex: '1 1 0px',
        minWidth: `${CELL_WIDTH}px`,
        maxWidth: `${CELL_WIDTH}px`,
        justifyContent: 'center'
    }
});
/**
 * Styles for the root slot
 */ const useStyles = (0, _react.makeStyles)({
    root: {
        textAlign: 'center',
        whiteSpace: 'nowrap',
        padding: '0',
        ...(0, _reacttabster.createCustomFocusIndicatorStyle)({
            outline: `2px solid ${_reacttheme.tokens.colorStrokeFocus2}`,
            borderRadius: _reacttheme.tokens.borderRadiusMedium
        }, {
            selector: 'focus'
        })
    },
    radioIndicator: {
        display: 'flex',
        flexGrow: 1,
        alignItems: 'center',
        justifyContent: 'center'
    },
    subtle: {
        opacity: 0,
        ...(0, _reacttabster.createCustomFocusIndicatorStyle)({
            opacity: 1
        }, {
            selector: 'focus-within'
        })
    },
    hidden: {
        opacity: 0
    }
});
const useTableSelectionCellStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    const layoutStyles = {
        table: useTableLayoutStyles(),
        flex: useFlexLayoutStyles()
    };
    state.root.className = (0, _react.mergeClasses)(tableSelectionCellClassNames.root, styles.root, state.noNativeElements ? layoutStyles.flex.root : layoutStyles.table.root, state.subtle && state.checked === false && styles.subtle, state.hidden && styles.hidden, state.root.className);
    if (state.checkboxIndicator) {
        state.checkboxIndicator.className = (0, _react.mergeClasses)(tableSelectionCellClassNames.checkboxIndicator, state.checkboxIndicator.className);
    }
    if (state.radioIndicator) {
        state.radioIndicator.className = (0, _react.mergeClasses)(tableSelectionCellClassNames.radioIndicator, styles.radioIndicator, state.radioIndicator.className);
    }
    return state;
};
