'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useTableSelectionCell_unstable", {
    enumerable: true,
    get: function() {
        return useTableSelectionCell_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _reactcheckbox = require("@fluentui/react-checkbox");
const _reactradio = require("@fluentui/react-radio");
const _useTableCell = require("../TableCell/useTableCell");
const _tableContext = require("../../contexts/tableContext");
const _reacttabster = require("@fluentui/react-tabster");
const useTableSelectionCell_unstable = (props, ref)=>{
    const tableCellState = (0, _useTableCell.useTableCell_unstable)(props, (0, _reactutilities.useMergedRefs)(ref, (0, _reacttabster.useFocusWithin)()));
    const { noNativeElements } = (0, _tableContext.useTableContext)();
    const { type = 'checkbox', checked = false, subtle = false, hidden = false, invisible = false } = props;
    return {
        ...tableCellState,
        components: {
            // eslint-disable-next-line @typescript-eslint/no-deprecated
            ...tableCellState.components,
            checkboxIndicator: _reactcheckbox.Checkbox,
            radioIndicator: _reactradio.Radio
        },
        checkboxIndicator: _reactutilities.slot.optional(props.checkboxIndicator, {
            renderByDefault: type === 'checkbox',
            defaultProps: {
                checked: props.checked
            },
            elementType: _reactcheckbox.Checkbox
        }),
        radioIndicator: _reactutilities.slot.optional(props.radioIndicator, {
            renderByDefault: type === 'radio',
            defaultProps: {
                checked: !!checked,
                input: {
                    name: (0, _reactutilities.useId)('table-selection-radio')
                }
            },
            elementType: _reactradio.Radio
        }),
        type,
        checked,
        noNativeElements,
        subtle,
        hidden: invisible || hidden
    };
};
