'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    tableRowClassName: function() {
        return tableRowClassName;
    },
    tableRowClassNames: function() {
        return tableRowClassNames;
    },
    useTableRowStyles_unstable: function() {
        return useTableRowStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const _useTableCellActionsStylesstyles = require("../TableCellActions/useTableCellActionsStyles.styles");
const _useTableSelectionCellStylesstyles = require("../TableSelectionCell/useTableSelectionCellStyles.styles");
const _reacttabster = require("@fluentui/react-tabster");
const tableRowClassName = 'fui-TableRow';
const tableRowClassNames = {
    root: tableRowClassName
};
const useTableLayoutStyles = (0, _react.makeStyles)({
    root: {
        display: 'table-row'
    }
});
const useFlexLayoutStyles = (0, _react.makeStyles)({
    root: {
        display: 'flex',
        alignItems: 'center'
    }
});
/**
 * Styles for the root slot
 */ const useStyles = (0, _react.makeStyles)({
    root: {
        color: _reacttheme.tokens.colorNeutralForeground1,
        boxSizing: 'border-box',
        ...(0, _reacttabster.createCustomFocusIndicatorStyle)({
            [`& .${_useTableSelectionCellStylesstyles.tableSelectionCellClassNames.root}`]: {
                opacity: 1
            },
            [`& .${_useTableCellActionsStylesstyles.tableCellActionsClassNames.root}`]: {
                opacity: 1
            }
        }, {
            selector: 'focus-within'
        }),
        ...(0, _reacttabster.createCustomFocusIndicatorStyle)({
            outline: `2px solid ${_reacttheme.tokens.colorStrokeFocus2}`,
            borderRadius: _reacttheme.tokens.borderRadiusMedium
        }, {
            selector: 'focus'
        })
    },
    rootInteractive: {
        ...(0, _reacttabster.createCustomFocusIndicatorStyle)({
            [`& .${_useTableCellActionsStylesstyles.tableCellActionsClassNames.root}`]: {
                opacity: 1
            }
        }, {
            selector: 'focus-within'
        }),
        ':active': {
            backgroundColor: _reacttheme.tokens.colorSubtleBackgroundPressed,
            color: _reacttheme.tokens.colorNeutralForeground1Pressed,
            [`& .${_useTableCellActionsStylesstyles.tableCellActionsClassNames.root}`]: {
                opacity: 1
            },
            [`& .${_useTableSelectionCellStylesstyles.tableSelectionCellClassNames.root}`]: {
                opacity: 1
            }
        },
        ':hover': {
            backgroundColor: _reacttheme.tokens.colorSubtleBackgroundHover,
            color: _reacttheme.tokens.colorNeutralForeground1Hover,
            [`& .${_useTableCellActionsStylesstyles.tableCellActionsClassNames.root}`]: {
                opacity: 1
            },
            [`& .${_useTableSelectionCellStylesstyles.tableSelectionCellClassNames.root}`]: {
                opacity: 1
            }
        },
        // High contrast styles
        '@media (forced-colors: active)': {
            ':hover': {
                color: 'Highlight',
                ..._react.shorthands.borderColor('Highlight')
            }
        }
    },
    medium: {
        borderBottom: `${_reacttheme.tokens.strokeWidthThin} solid ${_reacttheme.tokens.colorNeutralStroke2}`
    },
    small: {
        borderBottom: `${_reacttheme.tokens.strokeWidthThin} solid ${_reacttheme.tokens.colorNeutralStroke2}`
    },
    'extra-small': {
        fontSize: _reacttheme.tokens.fontSizeBase200
    },
    brand: {
        backgroundColor: _reacttheme.tokens.colorBrandBackground2,
        ..._react.shorthands.borderColor(_reacttheme.tokens.colorTransparentStrokeInteractive),
        ':active': {
            backgroundColor: _reacttheme.tokens.colorBrandBackground2,
            color: _reacttheme.tokens.colorNeutralForeground1
        },
        '@media(forced-colors: active)': {
            border: '2px solid transparent',
            borderRadius: _reacttheme.tokens.borderRadiusMedium,
            boxSizing: 'border-box',
            ':focus-visible': {
                outlineOffset: '-4px'
            }
        }
    },
    neutral: {
        '@media(forced-colors: active)': {
            border: '2px solid transparent',
            borderRadius: _reacttheme.tokens.borderRadiusMedium,
            boxSizing: 'border-box',
            ':focus-visible': {
                outlineOffset: '-4px'
            }
        },
        backgroundColor: _reacttheme.tokens.colorSubtleBackgroundSelected,
        color: _reacttheme.tokens.colorNeutralForeground1Hover,
        ':hover': {
            backgroundColor: _reacttheme.tokens.colorSubtleBackgroundSelected
        },
        ':active': {
            backgroundColor: _reacttheme.tokens.colorSubtleBackgroundSelected
        },
        ..._react.shorthands.borderColor(_reacttheme.tokens.colorNeutralStrokeOnBrand)
    },
    none: {}
});
const useTableRowStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    const layoutStyles = {
        table: useTableLayoutStyles(),
        flex: useFlexLayoutStyles()
    };
    state.root.className = (0, _react.mergeClasses)(tableRowClassNames.root, styles.root, !state.isHeaderRow && styles.rootInteractive, styles[state.size], state.noNativeElements ? layoutStyles.flex.root : layoutStyles.table.root, styles[state.appearance], state.root.className);
    return state;
};
