'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useTableRow_unstable", {
    enumerable: true,
    get: function() {
        return useTableRow_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _reacttabster = require("@fluentui/react-tabster");
const _tableContext = require("../../contexts/tableContext");
const _tableHeaderContext = require("../../contexts/tableHeaderContext");
const useTableRow_unstable = (props, ref)=>{
    const { noNativeElements, size } = (0, _tableContext.useTableContext)();
    var _props_as;
    const rootComponent = ((_props_as = props.as) !== null && _props_as !== void 0 ? _props_as : noNativeElements) ? 'div' : 'tr';
    const focusVisibleRef = (0, _reacttabster.useFocusVisible)();
    const focusWithinRef = (0, _reacttabster.useFocusWithin)();
    const isHeaderRow = (0, _tableHeaderContext.useIsInTableHeader)();
    var _props_appearance;
    return {
        components: {
            root: rootComponent
        },
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)(rootComponent, {
            // FIXME:
            // `ref` is wrongly assigned to be `HTMLElement` instead of `HTMLDivElement`
            // but since it would be a breaking change to fix it, we are casting ref to it's proper type
            ref: (0, _reactutilities.useMergedRefs)(ref, focusVisibleRef, focusWithinRef),
            role: rootComponent === 'div' ? 'row' : undefined,
            ...props
        }), {
            elementType: rootComponent
        }),
        size,
        noNativeElements,
        appearance: (_props_appearance = props.appearance) !== null && _props_appearance !== void 0 ? _props_appearance : 'none',
        isHeaderRow
    };
};
