'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    tableResizeHandleClassNames: function() {
        return tableResizeHandleClassNames;
    },
    useTableResizeHandleStyles_unstable: function() {
        return useTableResizeHandleStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const tableResizeHandleClassNames = {
    root: 'fui-TableResizeHandle'
};
/**
 * Styles for the root slot
 */ const useStyles = (0, _react.makeStyles)({
    root: {
        position: 'absolute',
        right: 0,
        top: 0,
        bottom: 0,
        width: '16px',
        margin: '0 -8px',
        cursor: 'col-resize',
        opacity: 0,
        transitionProperty: 'opacity',
        transitionDuration: '.2s',
        zIndex: 1,
        // If mouse users focus on the resize handle through a context menu, we want the handle
        // to be visible because the mouse might not be hovering over the handle
        ':focus': {
            opacity: 1,
            outlineStyle: 'none'
        },
        ':hover': {
            opacity: 1
        },
        '::after': {
            content: '" "',
            display: 'block',
            width: '1px',
            position: 'absolute',
            left: '50%',
            top: 0,
            bottom: 0,
            backgroundColor: _reacttheme.tokens.colorNeutralStroke1
        }
    }
});
const useTableResizeHandleStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    state.root.className = (0, _react.mergeClasses)(tableResizeHandleClassNames.root, styles.root, state.root.className);
    return state;
};
