'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    tableHeaderCellClassName: function() {
        return tableHeaderCellClassName;
    },
    tableHeaderCellClassNames: function() {
        return tableHeaderCellClassNames;
    },
    useTableHeaderCellStyles_unstable: function() {
        return useTableHeaderCellStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const _reacttabster = require("@fluentui/react-tabster");
const tableHeaderCellClassName = 'fui-TableHeaderCell';
const tableHeaderCellClassNames = {
    root: 'fui-TableHeaderCell',
    button: 'fui-TableHeaderCell__button',
    sortIcon: 'fui-TableHeaderCell__sortIcon',
    aside: 'fui-TableHeaderCell__aside'
};
const useTableLayoutStyles = (0, _react.makeStyles)({
    root: {
        display: 'table-cell',
        verticalAlign: 'middle'
    }
});
const useFlexLayoutStyles = (0, _react.makeStyles)({
    root: {
        display: 'flex',
        flex: '1 1 0px',
        minWidth: '0px'
    }
});
/**
 * Styles for the root slot
 */ const useStyles = (0, _react.makeStyles)({
    root: {
        fontWeight: _reacttheme.tokens.fontWeightRegular,
        padding: `0px ${_reacttheme.tokens.spacingHorizontalS}`,
        ...(0, _reacttabster.createCustomFocusIndicatorStyle)({
            outline: `2px solid ${_reacttheme.tokens.colorStrokeFocus2}`,
            borderRadius: _reacttheme.tokens.borderRadiusMedium
        }, {
            selector: 'focus-within'
        }),
        position: 'relative'
    },
    rootInteractive: {
        ':hover': {
            color: _reacttheme.tokens.colorNeutralForeground1Hover,
            backgroundColor: _reacttheme.tokens.colorSubtleBackgroundHover
        },
        ':active': {
            color: _reacttheme.tokens.colorNeutralForeground1Pressed,
            backgroundColor: _reacttheme.tokens.colorSubtleBackgroundPressed
        }
    },
    resetButton: {
        resize: 'horizontal',
        boxSizing: 'content-box',
        backgroundColor: 'inherit',
        color: 'inherit',
        fontFamily: 'inherit',
        fontSize: 'inherit',
        lineHeight: 'normal',
        overflow: 'visible',
        padding: '0',
        border: 'none',
        textAlign: 'unset'
    },
    button: {
        position: 'relative',
        width: '100%',
        display: 'flex',
        flexGrow: 1,
        height: '100%',
        alignItems: 'center',
        gap: _reacttheme.tokens.spacingHorizontalXS,
        minHeight: '32px',
        flex: '1 1 0px',
        outlineStyle: 'none'
    },
    sortable: {
        cursor: 'pointer'
    },
    sortIcon: {
        display: 'flex',
        alignItems: 'center',
        paddingTop: _reacttheme.tokens.spacingVerticalXXS
    },
    resizeHandle: {}
});
const useTableHeaderCellStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    const layoutStyles = {
        table: useTableLayoutStyles(),
        flex: useFlexLayoutStyles()
    };
    state.root.className = (0, _react.mergeClasses)(tableHeaderCellClassNames.root, styles.root, state.sortable && styles.rootInteractive, state.noNativeElements ? layoutStyles.flex.root : layoutStyles.table.root, state.root.className);
    state.button.className = (0, _react.mergeClasses)(tableHeaderCellClassNames.button, styles.resetButton, styles.button, state.sortable && styles.sortable, state.button.className);
    if (state.sortIcon) {
        state.sortIcon.className = (0, _react.mergeClasses)(tableHeaderCellClassNames.sortIcon, styles.sortIcon, state.sortIcon.className);
    }
    if (state.aside) {
        state.aside.className = (0, _react.mergeClasses)(tableHeaderCellClassNames.aside, styles.resizeHandle, state.aside.className);
    }
    return state;
};
