'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useTableHeaderCell_unstable", {
    enumerable: true,
    get: function() {
        return useTableHeaderCell_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _reacttabster = require("@fluentui/react-tabster");
const _reacticons = require("@fluentui/react-icons");
const _reactaria = require("@fluentui/react-aria");
const _tableContext = require("../../contexts/tableContext");
const sortIcons = {
    ascending: /*#__PURE__*/ _react.createElement(_reacticons.ArrowUpRegular, {
        fontSize: 12
    }),
    descending: /*#__PURE__*/ _react.createElement(_reacticons.ArrowDownRegular, {
        fontSize: 12
    })
};
const useTableHeaderCell_unstable = (props, ref)=>{
    const { noNativeElements, sortable: contextSortable } = (0, _tableContext.useTableContext)();
    const { sortable = contextSortable } = props;
    var _props_as;
    const rootComponent = ((_props_as = props.as) !== null && _props_as !== void 0 ? _props_as : noNativeElements) ? 'div' : 'th';
    // The sort button is rendered as a div when not sortable, and as an ARIA button when sortable.
    const buttonSlot = _reactutilities.slot.always(props.button, {
        elementType: 'div',
        defaultProps: {
            as: 'div'
        }
    });
    const ariaButtonProps = (0, _reactaria.useARIAButtonProps)(buttonSlot.as, buttonSlot);
    var _props_sortDirection;
    return {
        components: {
            root: rootComponent,
            button: 'div',
            sortIcon: 'span',
            aside: 'span'
        },
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)(rootComponent, {
            // FIXME:
            // `ref` is wrongly assigned to be `HTMLElement` instead of `HTMLDivElement`
            // but since it would be a breaking change to fix it, we are casting ref to it's proper type
            ref: (0, _reactutilities.useMergedRefs)(ref, (0, _reacttabster.useFocusWithin)()),
            role: rootComponent === 'div' ? 'columnheader' : undefined,
            'aria-sort': sortable ? (_props_sortDirection = props.sortDirection) !== null && _props_sortDirection !== void 0 ? _props_sortDirection : 'none' : undefined,
            ...props
        }), {
            elementType: rootComponent
        }),
        aside: _reactutilities.slot.optional(props.aside, {
            elementType: 'span'
        }),
        sortIcon: _reactutilities.slot.optional(props.sortIcon, {
            renderByDefault: !!props.sortDirection,
            defaultProps: {
                children: props.sortDirection ? sortIcons[props.sortDirection] : undefined
            },
            elementType: 'span'
        }),
        button: sortable ? ariaButtonProps : buttonSlot,
        sortable,
        noNativeElements
    };
};
