'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    tableCellLayoutClassNames: function() {
        return tableCellLayoutClassNames;
    },
    useTableCellLayoutStyles_unstable: function() {
        return useTableCellLayoutStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const tableCellLayoutClassNames = {
    root: 'fui-TableCellLayout',
    media: 'fui-TableCellLayout__media',
    main: 'fui-TableCellLayout__main',
    description: 'fui-TableCellLayout__description',
    content: 'fui-TableCellLayout__content'
};
/**
 * Styles for the root slot
 */ const useStyles = (0, _react.makeStyles)({
    root: {
        display: 'flex',
        alignItems: 'center',
        gap: _reacttheme.tokens.spacingHorizontalS,
        flex: '1 1 0px'
    },
    rootTruncate: {
        overflowX: 'hidden'
    },
    content: {
        display: 'flex',
        flexDirection: 'column'
    },
    contentTruncate: {
        overflowX: 'hidden'
    },
    media: {
        display: 'flex',
        alignItems: 'center'
    },
    mediaExtraSmall: {
        fontSize: '16px'
    },
    mediaSmallAndMedium: {
        fontSize: '20px'
    },
    mediaPrimary: {
        fontSize: '24px'
    },
    mainPrimary: {
        fontWeight: _reacttheme.tokens.fontWeightSemibold
    },
    mainTruncate: {
        overflowX: 'hidden',
        whiteSpace: 'nowrap',
        textOverflow: 'ellipsis'
    },
    description: {
        color: _reacttheme.tokens.colorNeutralForeground2,
        ..._reacttheme.typographyStyles.caption1
    }
});
const useTableCellLayoutStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    const { truncate } = state;
    state.root.className = (0, _react.mergeClasses)(tableCellLayoutClassNames.root, styles.root, truncate && styles.rootTruncate, state.root.className);
    const primary = state.appearance === 'primary';
    if (state.media) {
        const mediaSizedStyles = {
            small: styles.mediaSmallAndMedium,
            medium: styles.mediaSmallAndMedium,
            'extra-small': styles.mediaExtraSmall
        };
        state.media.className = (0, _react.mergeClasses)(tableCellLayoutClassNames.media, styles.media, mediaSizedStyles[state.size], primary && styles.mediaPrimary, state.media.className);
    }
    if (state.main) {
        state.main.className = (0, _react.mergeClasses)(tableCellLayoutClassNames.main, truncate && styles.mainTruncate, primary && styles.mainPrimary, state.main.className);
    }
    if (state.description) {
        state.description.className = (0, _react.mergeClasses)(tableCellLayoutClassNames.description, styles.description, state.description.className);
    }
    if (state.content) {
        state.content.className = (0, _react.mergeClasses)(tableCellLayoutClassNames.content, styles.content, truncate && styles.contentTruncate, state.content.className);
    }
    return state;
};
