'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useTableCellLayout_unstable", {
    enumerable: true,
    get: function() {
        return useTableCellLayout_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _tableContext = require("../../contexts/tableContext");
const tableAvatarSizeMap = {
    medium: 32,
    small: 24,
    'extra-small': 20
};
const useTableCellLayout_unstable = (props, ref)=>{
    const { size } = (0, _tableContext.useTableContext)();
    return {
        components: {
            root: 'div',
            main: 'span',
            description: 'span',
            content: 'div',
            media: 'span'
        },
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('div', {
            // FIXME:
            // `ref` is wrongly assigned to be `HTMLElement` instead of `HTMLDivElement`
            // but since it would be a breaking change to fix it, we are casting ref to it's proper type
            ref: ref,
            ...props
        }, [
            'content'
        ]), {
            elementType: 'div'
        }),
        appearance: props.appearance,
        truncate: props.truncate,
        main: _reactutilities.slot.optional(props.main, {
            renderByDefault: true,
            elementType: 'span'
        }),
        media: _reactutilities.slot.optional(props.media, {
            elementType: 'span'
        }),
        description: _reactutilities.slot.optional(props.description, {
            elementType: 'span'
        }),
        content: _reactutilities.slot.optional(props.content, {
            renderByDefault: !!props.description || !!props.children,
            elementType: 'div'
        }),
        avatarSize: tableAvatarSizeMap[size],
        size
    };
};
