'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    tableCellClassName: function() {
        return tableCellClassName;
    },
    tableCellClassNames: function() {
        return tableCellClassNames;
    },
    useTableCellStyles_unstable: function() {
        return useTableCellStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const _reacttabster = require("@fluentui/react-tabster");
const tableCellClassName = 'fui-TableCell';
const tableCellClassNames = {
    root: tableCellClassName
};
const useTableLayoutStyles = (0, _react.makeStyles)({
    root: {
        display: 'table-cell',
        verticalAlign: 'middle'
    },
    medium: {
        height: '44px'
    },
    small: {
        height: '34px'
    },
    'extra-small': {
        height: '24px'
    }
});
const useFlexLayoutStyles = (0, _react.makeStyles)({
    root: {
        display: 'flex',
        minWidth: '0px',
        alignItems: 'center',
        flex: '1 1 0px'
    },
    medium: {
        minHeight: '44px'
    },
    small: {
        minHeight: '34px'
    },
    'extra-small': {
        minHeight: '24px'
    }
});
/**
 * Styles for the root slot
 */ const useStyles = (0, _react.makeStyles)({
    root: {
        position: 'relative',
        padding: `0px ${_reacttheme.tokens.spacingHorizontalS}`,
        ...(0, _reacttabster.createCustomFocusIndicatorStyle)({
            outline: `2px solid ${_reacttheme.tokens.colorStrokeFocus2}`,
            borderRadius: _reacttheme.tokens.borderRadiusMedium
        }, {
            selector: 'focus'
        })
    }
});
const useTableCellStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    const layoutStyles = {
        table: useTableLayoutStyles(),
        flex: useFlexLayoutStyles()
    };
    state.root.className = (0, _react.mergeClasses)(tableCellClassNames.root, styles.root, state.noNativeElements ? layoutStyles.flex.root : layoutStyles.table.root, state.noNativeElements ? layoutStyles.flex[state.size] : layoutStyles.table[state.size], state.root.className);
    return state;
};
