'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    tableClassName: function() {
        return tableClassName;
    },
    tableClassNames: function() {
        return tableClassNames;
    },
    useTableStyles_unstable: function() {
        return useTableStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const tableClassName = 'fui-Table';
const tableClassNames = {
    root: 'fui-Table'
};
const useTableLayoutStyles = (0, _react.makeStyles)({
    root: {
        display: 'table',
        verticalAlign: 'middle',
        width: '100%',
        tableLayout: 'fixed'
    }
});
const useFlexLayoutStyles = (0, _react.makeStyles)({
    root: {
        display: 'block'
    }
});
/**
 * Styles for the root slot
 */ const useStyles = (0, _react.makeStyles)({
    root: {
        borderCollapse: 'collapse',
        backgroundColor: _reacttheme.tokens.colorSubtleBackground
    }
});
const useTableStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    const layoutStyles = {
        table: useTableLayoutStyles(),
        flex: useFlexLayoutStyles()
    };
    state.root.className = (0, _react.mergeClasses)(tableClassName, styles.root, state.noNativeElements ? layoutStyles.flex.root : layoutStyles.table.root, state.root.className);
    return state;
};
