'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useDataGridSelectionCell_unstable", {
    enumerable: true,
    get: function() {
        return useDataGridSelectionCell_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _dataGridContext = require("../../contexts/dataGridContext");
const _rowIdContext = require("../../contexts/rowIdContext");
const _tableHeaderContext = require("../../contexts/tableHeaderContext");
const _useTableSelectionCell = require("../TableSelectionCell/useTableSelectionCell");
const useDataGridSelectionCell_unstable = (props, ref)=>{
    const isHeader = (0, _tableHeaderContext.useIsInTableHeader)();
    const rowId = (0, _rowIdContext.useTableRowIdContext)();
    const subtle = (0, _dataGridContext.useDataGridContext_unstable)((ctx)=>ctx.subtleSelection);
    const checked = (0, _dataGridContext.useDataGridContext_unstable)((ctx)=>{
        if (isHeader && ctx.selection.selectionMode === 'multiselect') {
            return ctx.selection.allRowsSelected ? true : ctx.selection.someRowsSelected ? 'mixed' : false;
        }
        return ctx.selection.isRowSelected(rowId);
    });
    const toggleAllRows = (0, _dataGridContext.useDataGridContext_unstable)((ctx)=>ctx.selection.toggleAllRows);
    const type = (0, _dataGridContext.useDataGridContext_unstable)((ctx)=>ctx.selection.selectionMode === 'multiselect' ? 'checkbox' : 'radio');
    const onClick = (0, _reactutilities.useEventCallback)((e)=>{
        var _props_onClick;
        if (isHeader) {
            toggleAllRows(e);
        }
        (_props_onClick = props.onClick) === null || _props_onClick === void 0 ? void 0 : _props_onClick.call(props, e);
    });
    return (0, _useTableSelectionCell.useTableSelectionCell_unstable)({
        as: 'div',
        role: 'gridcell',
        checked,
        type,
        invisible: isHeader && type === 'radio',
        'aria-selected': checked === 'mixed' ? undefined : checked,
        subtle,
        radioIndicator: isHeader ? null : undefined,
        ...props,
        onClick
    }, ref);
};
