'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useDataGridRow_unstable", {
    enumerable: true,
    get: function() {
        return useDataGridRow_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _keyboardkeys = require("@fluentui/keyboard-keys");
const _useTableRow = require("../TableRow/useTableRow");
const _dataGridContext = require("../../contexts/dataGridContext");
const _DataGridSelectionCell = require("../DataGridSelectionCell/DataGridSelectionCell");
const _rowIdContext = require("../../contexts/rowIdContext");
const _tableHeaderContext = require("../../contexts/tableHeaderContext");
const useDataGridRow_unstable = (props, ref)=>{
    const rowId = (0, _rowIdContext.useTableRowIdContext)();
    const isHeader = (0, _tableHeaderContext.useIsInTableHeader)();
    const columnDefs = (0, _dataGridContext.useDataGridContext_unstable)((ctx)=>ctx.columns);
    const selectable = (0, _dataGridContext.useDataGridContext_unstable)((ctx)=>ctx.selectableRows);
    const selected = (0, _dataGridContext.useDataGridContext_unstable)((ctx)=>ctx.selection.isRowSelected(rowId));
    const focusMode = (0, _dataGridContext.useDataGridContext_unstable)((ctx)=>ctx.focusMode);
    const compositeRowTabsterAttribute = (0, _dataGridContext.useDataGridContext_unstable)((ctx)=>ctx.compositeRowTabsterAttribute);
    const tabbable = focusMode === 'row_unstable' || focusMode === 'composite';
    const appearance = (0, _dataGridContext.useDataGridContext_unstable)((ctx)=>{
        if (!isHeader && selectable && ctx.selection.isRowSelected(rowId)) {
            return ctx.selectionAppearance;
        }
        return 'none';
    });
    const toggleRow = (0, _dataGridContext.useDataGridContext_unstable)((ctx)=>ctx.selection.toggleRow);
    const onClick = (0, _reactutilities.useEventCallback)((e)=>{
        var _props_onClick;
        if (selectable && !isHeader) {
            toggleRow(e, rowId);
        }
        (_props_onClick = props.onClick) === null || _props_onClick === void 0 ? void 0 : _props_onClick.call(props, e);
    });
    const onKeyDown = (0, _reactutilities.useEventCallback)((e)=>{
        var _props_onKeyDown;
        if (selectable && !isHeader && e.key === _keyboardkeys.Space && !(0, _reactutilities.isInteractiveHTMLElement)(e.target)) {
            // stop scrolling
            e.preventDefault();
            toggleRow(e, rowId);
        }
        (_props_onKeyDown = props.onKeyDown) === null || _props_onKeyDown === void 0 ? void 0 : _props_onKeyDown.call(props, e);
    });
    const baseState = (0, _useTableRow.useTableRow_unstable)({
        appearance,
        'aria-selected': selectable ? selected : undefined,
        tabIndex: tabbable && !isHeader ? 0 : undefined,
        ...focusMode === 'composite' && !isHeader && compositeRowTabsterAttribute,
        ...props,
        onClick,
        onKeyDown,
        children: null,
        as: 'div'
    }, ref);
    return {
        ...baseState,
        components: {
            // eslint-disable-next-line @typescript-eslint/no-deprecated
            ...baseState.components,
            selectionCell: _DataGridSelectionCell.DataGridSelectionCell
        },
        selectionCell: _reactutilities.slot.optional(props.selectionCell, {
            renderByDefault: selectable,
            elementType: _DataGridSelectionCell.DataGridSelectionCell
        }),
        renderCell: props.children,
        columnDefs,
        // This context value should not be used internally
        // It's intended to help power user render functions
        dataGridContextValue: useStableDataGridContextValue()
    };
};
function useStableDataGridContextValue() {
    const ref = _react.useRef(_dataGridContext.dataGridContextDefaultValue);
    // Heads up!
    // We will not re-render when the context value changes, but we will have the latest value of the context when we do
    // render for other reasons.
    //
    // This relies on a context selector that always returns the same value:
    // - we will not re-render when the context value changes
    // - we will store the context value in a ref
    (0, _dataGridContext.useDataGridContext_unstable)((ctx)=>{
        ref.current = ctx;
        return null;
    });
    return ref.current;
}
