'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useDataGridHeaderCell_unstable", {
    enumerable: true,
    get: function() {
        return useDataGridHeaderCell_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reacttabster = require("@fluentui/react-tabster");
const _reactutilities = require("@fluentui/react-utilities");
const _useTableHeaderCell = require("../TableHeaderCell/useTableHeaderCell");
const _dataGridContext = require("../../contexts/dataGridContext");
const _columnIdContext = require("../../contexts/columnIdContext");
const _tableContext = require("../../contexts/tableContext");
const _isColumnSortable = require("../../utils/isColumnSortable");
const useDataGridHeaderCell_unstable = (props, ref)=>{
    const columnId = (0, _columnIdContext.useColumnIdContext)();
    const { sortable: gridSortable } = (0, _tableContext.useTableContext)();
    const toggleColumnSort = (0, _dataGridContext.useDataGridContext_unstable)((ctx)=>ctx.sort.toggleColumnSort);
    const sortable = (0, _dataGridContext.useDataGridContext_unstable)((ctx)=>{
        const columnSortable = !!ctx.columns.find((c)=>c.columnId === columnId && (0, _isColumnSortable.isColumnSortable)(c));
        if (!gridSortable) {
            // if the grid is not sortable - disable sorting on all columns
            return false;
        }
        return columnSortable;
    });
    const sortDirection = (0, _dataGridContext.useDataGridContext_unstable)((ctx)=>sortable ? ctx.sort.getSortDirection(columnId) : undefined);
    const resizableColumns = (0, _dataGridContext.useDataGridContext_unstable)((ctx)=>ctx.resizableColumns);
    const getTableHeaderCellProps = (0, _dataGridContext.useDataGridContext_unstable)((ctx)=>{
        return ctx.columnSizing_unstable.getTableHeaderCellProps;
    });
    const { focusMode = sortable ? 'none' : 'cell' } = props;
    const focusableGroupAttr = (0, _reacttabster.useFocusableGroup)({
        tabBehavior: 'limited-trap-focus'
    });
    // eslint-disable-next-line @typescript-eslint/no-deprecated -- prefer HTMLTableCellElement
    const onClick = (0, _reactutilities.useEventCallback)((e)=>{
        var _props_onClick;
        if (sortable) {
            toggleColumnSort(e, columnId);
        }
        (_props_onClick = props.onClick) === null || _props_onClick === void 0 ? void 0 : _props_onClick.call(props, e);
    });
    return (0, _useTableHeaderCell.useTableHeaderCell_unstable)({
        sortable,
        sortDirection,
        as: 'div',
        tabIndex: focusMode !== 'none' ? 0 : undefined,
        ...focusMode === 'group' && focusableGroupAttr,
        ...resizableColumns ? getTableHeaderCellProps(columnId) : {},
        ...props,
        onClick
    }, ref);
};
