'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useDataGridCell_unstable", {
    enumerable: true,
    get: function() {
        return useDataGridCell_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reacttabster = require("@fluentui/react-tabster");
const _useTableCell = require("../TableCell/useTableCell");
const _dataGridContext = require("../../contexts/dataGridContext");
const _columnIdContext = require("../../contexts/columnIdContext");
const useDataGridCell_unstable = (props, ref)=>{
    const { focusMode = 'cell' } = props;
    const columnId = (0, _columnIdContext.useColumnIdContext)();
    const tabbable = (0, _dataGridContext.useDataGridContext_unstable)((ctx)=>(ctx.focusMode === 'cell' || ctx.focusMode === 'composite') && focusMode !== 'none');
    const resizableColumns = (0, _dataGridContext.useDataGridContext_unstable)((ctx)=>ctx.resizableColumns);
    const getTableCellProps = (0, _dataGridContext.useDataGridContext_unstable)((ctx)=>{
        return ctx.columnSizing_unstable.getTableCellProps;
    });
    const focusableGroupAttr = (0, _reacttabster.useFocusableGroup)({
        tabBehavior: 'limited-trap-focus'
    });
    return (0, _useTableCell.useTableCell_unstable)({
        as: 'div',
        role: 'gridcell',
        ...focusMode === 'group' && focusableGroupAttr,
        tabIndex: tabbable ? 0 : undefined,
        ...resizableColumns ? getTableCellProps(columnId) : {},
        ...props
    }, ref);
};
