'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useDataGrid_unstable", {
    enumerable: true,
    get: function() {
        return useDataGrid_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reacttabster = require("@fluentui/react-tabster");
const _useTable = require("../Table/useTable");
const _reactutilities = require("@fluentui/react-utilities");
const _keyboardkeys = require("@fluentui/keyboard-keys");
const _hooks = require("../../hooks");
const _TableSelectionCell = require("../TableSelectionCell");
const useDataGrid_unstable = (props, ref)=>{
    const { items, columns, focusMode = 'cell', selectionMode, onSortChange, onSelectionChange, defaultSortState, sortState, selectedItems, defaultSelectedItems, subtleSelection = false, selectionAppearance = 'brand', getRowId, resizableColumns, columnSizingOptions, onColumnResize, containerWidthOffset, resizableColumnsOptions = {} } = props;
    const widthOffset = containerWidthOffset !== null && containerWidthOffset !== void 0 ? containerWidthOffset : selectionMode ? -_TableSelectionCell.CELL_WIDTH : 0;
    const gridTabsterAttribute = (0, _reacttabster.useArrowNavigationGroup)({
        axis: 'grid'
    });
    const { onTableKeyDown: onCompositeKeyDown, tableTabsterAttribute: compositeTabsterAttribute, tableRowTabsterAttribute: compositeRowTabsterAttribute } = (0, _hooks.useTableCompositeNavigation)();
    var _resizableColumnsOptions_autoFitColumns;
    const tableState = (0, _hooks.useTableFeatures)({
        items,
        columns,
        getRowId
    }, [
        (0, _hooks.useTableSort)({
            defaultSortState,
            sortState,
            onSortChange
        }),
        (0, _hooks.useTableSelection)({
            defaultSelectedItems,
            selectedItems,
            onSelectionChange,
            selectionMode: selectionMode !== null && selectionMode !== void 0 ? selectionMode : 'multiselect'
        }),
        (0, _hooks.useTableColumnSizing_unstable)({
            onColumnResize,
            columnSizingOptions,
            // The selection cell is not part of the columns, therefore its width needs to be subtracted
            // from the container to make sure the columns don't overflow the table.
            containerWidthOffset: widthOffset,
            // Disables automatic resizing of columns when the container overflows.
            // This allows the sum of the columns to be larger than the container.
            autoFitColumns: (_resizableColumnsOptions_autoFitColumns = resizableColumnsOptions.autoFitColumns) !== null && _resizableColumnsOptions_autoFitColumns !== void 0 ? _resizableColumnsOptions_autoFitColumns : true
        })
    ]);
    const innerRef = _react.useRef(null);
    const { findFirstFocusable, findLastFocusable } = (0, _reacttabster.useFocusFinders)();
    const onKeyDown = (0, _reactutilities.useEventCallback)((e)=>{
        var _props_onKeyDown;
        (_props_onKeyDown = props.onKeyDown) === null || _props_onKeyDown === void 0 ? void 0 : _props_onKeyDown.call(props, e);
        focusMode === 'composite' && onCompositeKeyDown(e);
        // handle ctrl+home and ctrl+end
        if (!innerRef.current || !e.ctrlKey || e.defaultPrevented) {
            return;
        }
        if (e.key === _keyboardkeys.Home) {
            const firstRow = innerRef.current.querySelector('[role="row"]');
            if (firstRow) {
                var _findFirstFocusable;
                (_findFirstFocusable = findFirstFocusable(firstRow)) === null || _findFirstFocusable === void 0 ? void 0 : _findFirstFocusable.focus();
            }
        }
        if (e.key === _keyboardkeys.End) {
            const rows = innerRef.current.querySelectorAll('[role="row"]');
            if (rows.length) {
                var _findLastFocusable;
                const lastRow = rows.item(rows.length - 1);
                (_findLastFocusable = findLastFocusable(lastRow)) === null || _findLastFocusable === void 0 ? void 0 : _findLastFocusable.focus();
            }
        }
    });
    const baseTableState = (0, _useTable.useTable_unstable)({
        role: 'grid',
        as: 'div',
        noNativeElements: true,
        ...focusMode === 'cell' && gridTabsterAttribute,
        ...focusMode === 'composite' && compositeTabsterAttribute,
        ...props,
        onKeyDown,
        ...resizableColumns ? tableState.columnSizing_unstable.getTableProps(props) : {}
    }, (0, _reactutilities.useMergedRefs)(ref, tableState.tableRef, innerRef));
    return {
        ...baseTableState,
        focusMode,
        tableState,
        selectableRows: !!selectionMode,
        subtleSelection,
        selectionAppearance,
        resizableColumns,
        compositeRowTabsterAttribute
    };
};
