import { ARIAButtonSlotProps } from '@fluentui/react-aria';
import type { AvatarSize } from '@fluentui/react-avatar';
import type { Checkbox } from '@fluentui/react-checkbox';
import type { CheckboxProps } from '@fluentui/react-checkbox';
import type { ComponentProps } from '@fluentui/react-utilities';
import type { ComponentState } from '@fluentui/react-utilities';
import type { ContextSelector } from '@fluentui/react-context-selector';
import { FC } from 'react';
import type { ForwardRefComponent } from '@fluentui/react-utilities';
import type { JSXElement } from '@fluentui/react-utilities';
import { Provider } from 'react';
import { ProviderProps } from 'react';
import type { Radio } from '@fluentui/react-radio';
import * as React_2 from 'react';
import { SelectionHookParams } from '@fluentui/react-utilities';
import { SelectionMode as SelectionMode_2 } from '@fluentui/react-utilities';
import type { Slot } from '@fluentui/react-utilities';
import type { SlotClassNames } from '@fluentui/react-utilities';
import { TabsterDOMAttribute } from '@fluentui/react-tabster';

export declare type CellRenderFunction<TItem = unknown> = (column: TableColumnDefinition<TItem>, dataGridContextValue: DataGridContextValue) => React_2.ReactNode;

export declare const ColumnIdContextProvider: React_2.Provider<TableColumnId | undefined>;

declare type ColumnSizingTableCellProps = Pick<TableHeaderCellProps, 'style'>;

declare type ColumnSizingTableHeaderCellProps = Pick<TableHeaderCellProps, 'style' | 'aside'>;

declare type ColumnSizingTableProps = TableProps;

declare interface ColumnWidthState {
    columnId: TableColumnId;
    width: number;
    minWidth: number;
    idealWidth: number;
    padding: number;
}

/**
 * Helper function to create column definition with defaults
 * @param options - column definition options
 * @returns - column definition with defaults
 */
export declare function createTableColumn<TItem>(options: CreateTableColumnOptions<TItem>): {
    columnId: TableColumnId;
    renderCell: (item: TItem) => React_2.ReactNode;
    renderHeaderCell: (data?: unknown) => React_2.ReactNode;
    compare: (a: TItem, b: TItem) => number;
};

export declare interface CreateTableColumnOptions<TItem> extends Partial<TableColumnDefinition<TItem>> {
    columnId: TableColumnId;
}

/**
 * DataGrid component
 */
export declare const DataGrid: ForwardRefComponent<DataGridProps>;

/**
 * DataGridBody component
 */
export declare const DataGridBody: ForwardRefComponent<DataGridBodyProps> & (<TItem>(props: DataGridBodyProps<TItem>) => JSXElement);

export declare const dataGridBodyClassNames: SlotClassNames<DataGridBodySlots>;

/**
 * DataGridBody Props
 */
export declare type DataGridBodyProps<TItem = unknown> = Omit<TableBodyProps, 'children'> & {
    /**
     * Render function for rows
     */
    children: RowRenderFunction<TItem>;
};

export declare type DataGridBodySlots = TableBodySlots;

/**
 * State used in rendering DataGridBody
 */
export declare type DataGridBodyState = TableBodyState & {
    rows: TableRowData<unknown>[];
    renderRow: RowRenderFunction;
};

/**
 * DataGridCell component
 */
export declare const DataGridCell: ForwardRefComponent<DataGridCellProps>;

export declare const dataGridCellClassNames: SlotClassNames<DataGridCellSlots>;

/**
 * Used when there are nested focusble elements inside a focusable cell
 * - `group`: Enter keypress moves focus inside the cell, focus is trapped inside the cell until Escape keypress
 * - `cell`: The cell is focusable - if there are focusable elements in the cell use `group`
 * - `none`: The cell is not focusable
 */
export declare type DataGridCellFocusMode = 'group' | 'none' | 'cell';

/**
 * DataGridCell Props
 */
export declare type DataGridCellProps = TableCellProps & {
    /**
     * Used when there are nested focusble elements inside a focusable cell
     * - `group`: Enter keypress moves focus inside the cell, focus is trapped inside the cell until Escape keypress
     * - `cell`: The cell is focusable - if there are focusable elements in the cell use `group`
     * - `none`: The cell is not focusable
     * @default cell
     */
    focusMode?: DataGridCellFocusMode;
};

export declare type DataGridCellSlots = TableCellSlots;

/**
 * State used in rendering DataGridCell
 */
export declare type DataGridCellState = TableCellState;

export declare const dataGridClassNames: SlotClassNames<DataGridSlots>;

export declare const DataGridContextProvider: Provider<DataGridContextValue | undefined> & FC<ProviderProps<DataGridContextValue | undefined>>;

export declare type DataGridContextValue = TableFeaturesState<any> & {
    /**
     * How focus navigation will work in the datagrid
     * @default cell
     */
    focusMode: DataGridFocusMode;
    /**
     * Lets child components know if rows selection is enabled
     * @see selectionMode prop enables row selection on the component
     */
    selectableRows: boolean;
    /**
     * Enables subtle selection style
     * @default false
     */
    subtleSelection: boolean;
    /**
     * Row appearance when selected
     * @default brand
     */
    selectionAppearance: TableRowProps['appearance'];
    /**
     * Enables column resizing
     */
    resizableColumns?: boolean;
    compositeRowTabsterAttribute: TabsterDOMAttribute;
};

export declare type DataGridContextValues = TableContextValues & {
    dataGrid: DataGridContextValue;
};

export declare type DataGridFocusMode = 'none' | 'cell' | 'row_unstable' | 'composite';

/**
 * DataGridHeader component
 */
export declare const DataGridHeader: ForwardRefComponent<DataGridHeaderProps>;

/**
 * DataGridHeaderCell component
 */
export declare const DataGridHeaderCell: ForwardRefComponent<DataGridHeaderCellProps>;

export declare const dataGridHeaderCellClassNames: SlotClassNames<DataGridHeaderCellSlots>;

/**
 * DataGridHeaderCell Props
 */
export declare type DataGridHeaderCellProps = Omit<TableHeaderCellProps, 'sortable'> & Pick<DataGridCellProps, 'focusMode'>;

export declare type DataGridHeaderCellSlots = TableHeaderCellSlots;

/**
 * State used in rendering DataGridHeaderCell
 */
export declare type DataGridHeaderCellState = TableHeaderCellState;

export declare const dataGridHeaderClassNames: SlotClassNames<DataGridHeaderSlots>;

/**
 * DataGridHeader Props
 */
export declare type DataGridHeaderProps = TableHeaderProps;

export declare type DataGridHeaderSlots = TableHeaderSlots;

/**
 * State used in rendering DataGridHeader
 */
export declare type DataGridHeaderState = TableHeaderState;

/**
 * DataGrid Props
 */
export declare type DataGridProps = TableProps & Pick<DataGridContextValue, 'items' | 'columns' | 'getRowId'> & Pick<Partial<DataGridContextValue>, 'focusMode' | 'subtleSelection' | 'selectionAppearance' | 'resizableColumns'> & Pick<UseTableSortOptions, 'sortState' | 'defaultSortState'> & Pick<SelectionHookParams, 'defaultSelectedItems' | 'selectedItems'> & {
    onSortChange?: (e: React_2.MouseEvent, sortState: SortState) => void;
    onSelectionChange?: (e: React_2.MouseEvent | React_2.KeyboardEvent, data: OnSelectionChangeData) => void;
    /**
     * Enables row selection and sets the selection mode
     * @default false
     */
    selectionMode?: SelectionMode_2;
    /**
     * Options for column resizing, specific for each column
     */
    columnSizingOptions?: TableColumnSizingOptions;
    /**
     * A callback triggered when a column is resized.
     */
    onColumnResize?: (e: KeyboardEvent | TouchEvent | MouseEvent | undefined, data: {
        columnId: TableColumnId;
        width: number;
    }) => void;
    /**
     * For column resizing. Allows for a container size to be adjusted by a number of pixels, to make
     * sure the columns don't overflow the table.
     * By default, this value is calculated internally based on other props, but can be overriden.
     */
    containerWidthOffset?: number;
    /**
     * Custom options for column resizing.
     */
    resizableColumnsOptions?: {
        /**
         * If true, columns will be auto-fitted to the container width.
         * @default true
         * */
        autoFitColumns?: boolean;
    };
};

/**
 * DataGridRow component
 */
export declare const DataGridRow: ForwardRefComponent<DataGridRowProps> & (<TItem>(props: DataGridRowProps<TItem>) => JSXElement);

export declare const dataGridRowClassNames: SlotClassNames<DataGridRowSlots>;

/**
 * DataGridRow Props
 */
export declare type DataGridRowProps<TItem = unknown> = Omit<TableRowProps, 'children'> & Omit<ComponentProps<DataGridRowSlots>, 'children'> & {
    children: CellRenderFunction<TItem>;
};

export declare type DataGridRowSlots = TableRowSlots & {
    /**
     * When selection is enabled on the @see DataGrid, all rows
     * will render the selection cell.
     */
    selectionCell?: Slot<typeof TableSelectionCell>;
};

/**
 * State used in rendering DataGridRow
 */
export declare type DataGridRowState = TableRowState & ComponentState<DataGridRowSlots> & {
    renderCell: CellRenderFunction;
    columnDefs: TableColumnDefinition<any>[];
    dataGridContextValue: DataGridContextValue;
};

/**
 * DataGridSelectionCell component
 */
export declare const DataGridSelectionCell: ForwardRefComponent<DataGridSelectionCellProps>;

export declare const dataGridSelectionCellClassNames: SlotClassNames<DataGridSelectionCellSlots>;

/**
 * DataGridSelectionCell Props
 */
export declare type DataGridSelectionCellProps = TableSelectionCellProps;

export declare type DataGridSelectionCellSlots = TableSelectionCellSlots;

/**
 * State used in rendering DataGridSelectionCell
 */
export declare type DataGridSelectionCellState = TableSelectionCellState;

export declare type DataGridSlots = TableSlots;

/**
 * State used in rendering DataGrid
 */
export declare type DataGridState = TableState & {
    tableState: TableFeaturesState<unknown>;
} & Pick<DataGridContextValue, 'focusMode' | 'selectableRows' | 'subtleSelection' | 'selectionAppearance' | 'getRowId' | 'resizableColumns' | 'compositeRowTabsterAttribute'>;

declare type EnableKeyboardModeOnChangeCallback = (columnId: TableColumnId, isKeyboardMode: boolean) => void;

declare interface OnSelectionChangeData {
    selectedItems: Set<TableRowId>;
}

/**
 * Render the final JSX of DataGrid
 */
export declare const renderDataGrid_unstable: (state: DataGridState, contextValues: DataGridContextValues) => JSXElement;

/**
 * Render the final JSX of DataGridBody
 */
export declare const renderDataGridBody_unstable: (state: DataGridBodyState) => JSXElement;

/**
 * Render the final JSX of DataGridCell
 */
export declare const renderDataGridCell_unstable: (state: DataGridCellState) => JSXElement;

/**
 * Render the final JSX of DataGridHeader
 */
export declare const renderDataGridHeader_unstable: (state: DataGridHeaderState) => JSXElement;

/**
 * Render the final JSX of DataGridHeaderCell
 */
export declare const renderDataGridHeaderCell_unstable: (state: DataGridHeaderCellState) => JSXElement;

/**
 * Render the final JSX of DataGridRow
 */
export declare const renderDataGridRow_unstable: (state: DataGridRowState) => JSXElement;

/**
 * Render the final JSX of DataGridSelectionCell
 */
export declare const renderDataGridSelectionCell_unstable: (state: DataGridSelectionCellState) => JSXElement;

/**
 * Render the final JSX of Table
 */
export declare const renderTable_unstable: (state: TableState, contextValues: TableContextValues) => JSXElement;

/**
 * Render the final JSX of TableBody
 */
export declare const renderTableBody_unstable: (state: TableBodyState) => JSXElement;

/**
 * Render the final JSX of TableCell
 */
export declare const renderTableCell_unstable: (state: TableCellState) => JSXElement;

/**
 * Render the final JSX of TableCellActions
 */
export declare const renderTableCellActions_unstable: (state: TableCellActionsState) => JSXElement;

/**
 * Render the final JSX of TableCellLayout
 */
export declare const renderTableCellLayout_unstable: (state: TableCellLayoutState, contextValues: TableCellLayoutContextValues) => JSXElement;

/**
 * Render the final JSX of TableHeader
 */
export declare const renderTableHeader_unstable: (state: TableHeaderState) => JSXElement;

/**
 * Render the final JSX of TableHeaderCell
 */
export declare const renderTableHeaderCell_unstable: (state: TableHeaderCellState) => JSXElement;

/**
 * Render the final JSX of TableResizeHandle
 */
export declare const renderTableResizeHandle_unstable: (state: TableResizeHandleState) => JSXElement;

/**
 * Render the final JSX of TableRow
 */
export declare const renderTableRow_unstable: (state: TableRowState) => JSXElement;

/**
 * Render the final JSX of TableSelectionCell
 */
export declare const renderTableSelectionCell_unstable: (state: TableSelectionCellState) => JSXElement;

declare type RowEnhancer<TItem, TRowState extends TableRowData<TItem> = TableRowData<TItem>> = (row: TableRowData<TItem>) => TRowState;

export declare type RowRenderFunction<TItem = unknown> = (row: TableRowData<TItem>, ...rest: unknown[]) => React_2.ReactNode;

export declare type SortDirection = 'ascending' | 'descending';

declare interface SortState {
    sortColumn: TableColumnId | undefined;
    sortDirection: SortDirection;
}

/**
 * Table component
 */
export declare const Table: ForwardRefComponent<TableProps>;

export declare const TABLE_SELECTION_CELL_WIDTH = 44;

/**
 * TableBody component
 */
export declare const TableBody: ForwardRefComponent<TableBodyProps>;

export declare const tableBodyClassName = "fui-TableBody";

export declare const tableBodyClassNames: SlotClassNames<TableBodySlots>;

/**
 * TableBody Props
 */
export declare type TableBodyProps = ComponentProps<TableBodySlots>;

export declare type TableBodySlots = {
    root: Slot<'tbody', 'div'>;
};

/**
 * State used in rendering TableBody
 */
export declare type TableBodyState = ComponentState<TableBodySlots> & Pick<TableContextValue, 'noNativeElements'>;

/**
 * TableCell component
 */
export declare const TableCell: ForwardRefComponent<TableCellProps>;

/**
 * TableCellActions component
 */
export declare const TableCellActions: ForwardRefComponent<TableCellActionsProps>;

export declare const tableCellActionsClassNames: SlotClassNames<TableCellActionsSlots>;

/**
 * TableCellActions Props
 */
export declare type TableCellActionsProps = ComponentProps<TableCellActionsSlots> & {
    /**
     * When true, the actions are always visible regardless of row hover.
     * Can be useful keeping the actions visible when a popout surface is opened.
     */
    visible?: boolean;
};

export declare type TableCellActionsSlots = {
    root: Slot<'div'>;
};

/**
 * State used in rendering TableCellActions
 */
export declare type TableCellActionsState = ComponentState<TableCellActionsSlots> & Pick<Required<TableCellActionsProps>, 'visible'>;

export declare const tableCellClassName = "fui-TableCell";

export declare const tableCellClassNames: SlotClassNames<TableCellSlots>;

/**
 * TableCellLayout component
 */
export declare const TableCellLayout: ForwardRefComponent<TableCellLayoutProps>;

export declare const tableCellLayoutClassNames: SlotClassNames<TableCellLayoutSlots>;

declare type TableCellLayoutContextValues = {
    avatar: {
        size?: AvatarSize;
    };
};

/**
 * TableCellLayout Props
 */
export declare type TableCellLayoutProps = Omit<ComponentProps<Partial<TableCellLayoutSlots>>, 'content'> & Pick<Partial<TableCellLayoutSlots>, 'content'> & {
    /**
     * Renders design variants of the table cell
     * @default undefined
     */
    appearance?: 'primary';
    /**
     * Renders content with overflow: hidden and text-overflow: ellipsis
     */
    truncate?: boolean;
};

export declare type TableCellLayoutSlots = {
    root: Slot<'div'>;
    /**
     * Slot for an icon or other visual element
     */
    media: Slot<'span'>;
    /**
     * Main text for the table cell. Children of the root slot are automatically rendered here
     */
    main: Slot<'span'>;
    /**
     * Secondary text that describes or complements the main text
     */
    description: Slot<'span'>;
    /**
     * A layout wrapper for the main and description slots
     */
    content: Slot<'div'>;
};

/**
 * State used in rendering TableCellLayout
 */
export declare type TableCellLayoutState = ComponentState<TableCellLayoutSlots> & Pick<TableCellLayoutProps, 'appearance' | 'truncate'> & {
    avatarSize: AvatarSize | undefined;
} & Pick<TableContextValue, 'size'>;

/**
 * TableCell Props
 */
export declare type TableCellProps = ComponentProps<TableCellSlots> & {};

export declare type TableCellSlots = {
    root: Slot<'td', 'div'>;
};

/**
 * State used in rendering TableCell
 */
export declare type TableCellState = ComponentState<TableCellSlots> & Pick<TableContextValue, 'noNativeElements' | 'size'>;

export declare const tableClassName = "fui-Table";

export declare const tableClassNames: SlotClassNames<TableSlots>;

export declare interface TableColumnDefinition<TItem> {
    columnId: TableColumnId;
    compare: (a: TItem, b: TItem) => number;
    renderHeaderCell: (data?: unknown) => React_2.ReactNode;
    renderCell: (item: TItem) => React_2.ReactNode;
}

export declare type TableColumnId = string | number;

export declare type TableColumnSizingOptions = Record<TableColumnId, Partial<Pick<ColumnWidthState, 'minWidth' | 'idealWidth' | 'padding'>> & {
    defaultWidth?: number;
    autoFitColumns?: boolean;
}>;

declare interface TableColumnSizingState {
    getOnMouseDown: (columnId: TableColumnId) => (e: React_2.MouseEvent | React_2.TouchEvent) => void;
    setColumnWidth: (columnId: TableColumnId, newSize: number) => void;
    getColumnWidths: () => ColumnWidthState[];
    getTableProps: (props?: TableProps) => ColumnSizingTableProps;
    getTableHeaderCellProps: (columnId: TableColumnId) => ColumnSizingTableHeaderCellProps;
    getTableCellProps: (columnId: TableColumnId) => ColumnSizingTableCellProps;
    enableKeyboardMode: (columnId: TableColumnId, onChange?: EnableKeyboardModeOnChangeCallback) => (e: React_2.MouseEvent | React_2.TouchEvent) => void;
}

export declare const TableContextProvider: React_2.Provider<TableContextValue | undefined>;

export declare type TableContextValue = {
    /**
     * Affects the sizes of all table subcomponents
     * @default medium
     */
    size: 'extra-small' | 'small' | 'medium';
    /**
     * Render all table elements as divs instead of semantic table elements
     * Using divs no longer uses `display: table` layout but `display: flex`
     * @default false
     */
    noNativeElements: boolean;
    /**
     * Whether the table is sortable
     * @default false
     */
    sortable: boolean;
};

export declare type TableContextValues = {
    table: TableContextValue;
};

export declare type TableFeaturePlugin = <TItem>(tableState: TableFeaturesState<TItem>) => TableFeaturesState<TItem>;

export declare interface TableFeaturesState<TItem> extends Pick<UseTableFeaturesOptions<TItem>, 'items' | 'getRowId'> {
    /**
     * The row data for rendering
     * @param rowEnhancer - Enhances the row with extra user data
     */
    getRows: <TRowState extends TableRowData<TItem> = TableRowData<TItem>>(rowEnhancer?: RowEnhancer<TItem, TRowState>) => TRowState[];
    /**
     * State and actions to manage row selection
     */
    selection: TableSelectionState;
    /**
     * State and actions to manage row sorting
     */
    sort: TableSortState<TItem>;
    /**
     * Table columns
     */
    columns: TableColumnDefinition<TItem>[];
    /**
     * State and actions to manage column resizing
     */
    columnSizing_unstable: TableColumnSizingState;
    /**
     * A React.Ref object to be set as a ref for the table.
     * Used with column resizing.
     */
    tableRef: React_2.Ref<HTMLDivElement>;
}

/**
 * TableHeader component
 */
export declare const TableHeader: ForwardRefComponent<TableHeaderProps>;

/**
 * TableHeaderCell component
 */
export declare const TableHeaderCell: ForwardRefComponent<TableHeaderCellProps>;

export declare const tableHeaderCellClassName = "fui-TableHeaderCell";

export declare const tableHeaderCellClassNames: SlotClassNames<TableHeaderCellSlots>;

/**
 * TableHeaderCell Props
 */
export declare type TableHeaderCellProps = ComponentProps<Partial<TableHeaderCellSlots>> & {
    /**
     * Whether the column is sortable
     * @default false
     */
    sortable?: boolean;
    /**
     * @default undefined
     */
    sortDirection?: SortDirection;
};

export declare type TableHeaderCellSlots = {
    root: Slot<'th', 'div'>;
    sortIcon: Slot<'span'>;
    /**
     * Button handles correct narration and interactions for sorting;
     */
    button: NonNullable<Slot<ARIAButtonSlotProps>>;
    /**
     * aside content for anything that should be after main content of the table header cell
     */
    aside: Slot<'span'>;
};

/**
 * State used in rendering TableHeaderCell
 */
export declare type TableHeaderCellState = ComponentState<TableHeaderCellSlots> & Pick<TableContextValue, 'noNativeElements'> & Pick<TableHeaderCellProps, 'sortable'>;

export declare const tableHeaderClassName = "fui-TableHeader";

export declare const tableHeaderClassNames: SlotClassNames<TableHeaderSlots>;

export declare const TableHeaderContextProvider: React_2.Provider<string | undefined>;

/**
 * TableHeader Props
 */
export declare type TableHeaderProps = ComponentProps<TableHeaderSlots> & {};

export declare type TableHeaderSlots = {
    root: Slot<'thead', 'div'>;
};

/**
 * State used in rendering TableHeader
 */
export declare type TableHeaderState = ComponentState<TableHeaderSlots> & Pick<TableContextValue, 'noNativeElements'>;

/**
 * Table Props
 */
export declare type TableProps = ComponentProps<TableSlots> & Partial<TableContextValue>;

/**
 * TableResizeHandle component - TODO: add more docs
 */
export declare const TableResizeHandle: ForwardRefComponent<TableResizeHandleProps>;

export declare const tableResizeHandleClassNames: SlotClassNames<TableResizeHandleSlots>;

/**
 * TableResizeHandle Props
 */
export declare type TableResizeHandleProps = ComponentProps<TableResizeHandleSlots> & {};

export declare type TableResizeHandleSlots = {
    root: Slot<'div'>;
};

/**
 * State used in rendering TableResizeHandle
 */
export declare type TableResizeHandleState = ComponentState<TableResizeHandleSlots>;

/**
 * TableRow component
 */
export declare const TableRow: ForwardRefComponent<TableRowProps>;

export declare const tableRowClassName = "fui-TableRow";

export declare const tableRowClassNames: SlotClassNames<TableRowSlots>;

export declare interface TableRowData<TItem> {
    /**
     * User provided data
     */
    item: TItem;
    /**
     * The row id, defaults to index position in the collection
     */
    rowId: TableRowId;
}

export declare type TableRowId = string | number;

export declare const TableRowIdContextProvider: React_2.Provider<TableRowId | undefined>;

/**
 * TableRow Props
 */
export declare type TableRowProps = ComponentProps<TableRowSlots> & {
    /**
     * A table row can have different variants. These appearances are
     * intended to be used with selection.
     * @default none
     */
    appearance?: 'brand' | 'neutral' | 'none';
};

export declare type TableRowSlots = {
    root: Slot<'tr', 'div'>;
};

/**
 * State used in rendering TableRow
 */
export declare type TableRowState = ComponentState<TableRowSlots> & Pick<TableContextValue, 'noNativeElements' | 'size'> & Pick<Required<TableRowProps>, 'appearance'> & {
    isHeaderRow: boolean;
};

/**
 * TableSelectionCell component
 */
export declare const TableSelectionCell: ForwardRefComponent<TableSelectionCellProps>;

export declare const tableSelectionCellClassNames: SlotClassNames<TableSelectionCellSlots>;

/**
 * TableSelectionCell Props
 */
export declare type TableSelectionCellProps = ComponentProps<Partial<TableSelectionCellSlots>> & {
    /**
     * A table can have two kinds of selection modes.
     * @default checkbox
     */
    type?: 'checkbox' | 'radio';
    /**
     * @default false
     */
    checked?: CheckboxProps['checked'];
    /**
     * Only visible when checked or the parent row is hovered/focused
     * @default false
     */
    subtle?: boolean;
    /**
     * Completely hides the selection cell
     * @deprecated cells should never use hidden, since doing so breaks table structure and screen reader navigation. Use `invisible` instead.
     */
    hidden?: boolean;
    /**
     * Hides the selection cell visually but takes up the same space
     * @default false
     */
    invisible?: boolean;
};

export declare type TableSelectionCellSlots = {
    /**
     * Selection indicator if selection type is checkbox
     */
    checkboxIndicator: Slot<typeof Checkbox>;
    /**
     * Selection indicator if selection type is radio
     */
    radioIndicator: Slot<typeof Radio>;
} & Pick<TableCellSlots, 'root'>;

/**
 * State used in rendering TableSelectionCell
 */
export declare type TableSelectionCellState = ComponentState<TableSelectionCellSlots> & Pick<Required<TableSelectionCellProps>, 'type' | 'checked' | 'subtle'> & Pick<TableContextValue, 'noNativeElements'> & {
    hidden: boolean;
};

export declare interface TableSelectionState {
    /**
     * Clears all selected rows
     */
    clearRows: (e: React_2.SyntheticEvent) => void;
    /**
     * Selects single row
     */
    selectRow: (e: React_2.SyntheticEvent, rowId: TableRowId) => void;
    /**
     * De-selects single row
     */
    deselectRow: (e: React_2.SyntheticEvent, rowId: TableRowId) => void;
    /**
     * Toggle selection of all rows
     */
    toggleAllRows: (e: React_2.SyntheticEvent) => void;
    /**
     * Toggle selection of single row
     */
    toggleRow: (e: React_2.SyntheticEvent, rowId: TableRowId) => void;
    /**
     * Collection of row ids corresponding to selected rows
     */
    selectedRows: Set<TableRowId>;
    /**
     * Whether all rows are selected
     */
    allRowsSelected: boolean;
    /**
     * Whether some rows are selected
     */
    someRowsSelected: boolean;
    /**
     * Checks if a given rowId is selected
     */
    isRowSelected: (rowId: TableRowId) => boolean;
    selectionMode: SelectionMode_2;
}

export declare type TableSlots = {
    root: Slot<'table', 'div'>;
};

export declare interface TableSortState<TItem> {
    /**
     * Current sort direction
     */
    sortDirection: SortDirection;
    /**
     * Column id of the currently sorted column
     */
    sortColumn: TableColumnId | undefined;
    /**
     * Set the sort direction for the specified column
     */
    setColumnSort: (event: React_2.SyntheticEvent, columnId: TableColumnId, sortDirection: SortDirection) => void;
    /**
     * Toggles the sort direction for specified column
     */
    toggleColumnSort: (event: React_2.SyntheticEvent, columnId: TableColumnId) => void;
    /**
     * Returns the sort direction if a column is sorted,
     * returns undefined if the column is not sorted
     */
    getSortDirection: (columnId: TableColumnId) => SortDirection | undefined;
    /**
     * Sorts rows and returns a **shallow** copy of original items
     */
    sort: <TRowState extends TableRowData<TItem>>(rows: TRowState[]) => TRowState[];
}

/**
 * State used in rendering Table
 */
export declare type TableState = ComponentState<TableSlots> & Pick<Required<TableProps>, 'size' | 'noNativeElements'> & TableContextValue;

export declare const useColumnIdContext: () => TableColumnId;

/**
 * Create the state required to render DataGrid.
 *
 * The returned state can be modified with hooks such as useDataGridStyles_unstable,
 * before being passed to renderDataGrid_unstable.
 *
 * @param props - props from this instance of DataGrid
 * @param ref - reference to root HTMLElement of DataGrid
 */
export declare const useDataGrid_unstable: (props: DataGridProps, ref: React_2.Ref<HTMLElement>) => DataGridState;

/**
 * Create the state required to render DataGridBody.
 *
 * The returned state can be modified with hooks such as useDataGridBodyStyles_unstable,
 * before being passed to renderDataGridBody_unstable.
 *
 * @param props - props from this instance of DataGridBody
 * @param ref - reference to root HTMLElement of DataGridBody
 */
export declare const useDataGridBody_unstable: (props: DataGridBodyProps, ref: React_2.Ref<HTMLElement>) => DataGridBodyState;

/**
 * Apply styling to the DataGridBody slots based on the state
 */
export declare const useDataGridBodyStyles_unstable: (state: DataGridBodyState) => DataGridBodyState;

/**
 * Create the state required to render DataGridCell.
 *
 * The returned state can be modified with hooks such as useDataGridCellStyles_unstable,
 * before being passed to renderDataGridCell_unstable.
 *
 * @param props - props from this instance of DataGridCell
 * @param ref - reference to root HTMLElement of DataGridCell
 */
export declare const useDataGridCell_unstable: (props: DataGridCellProps, ref: React_2.Ref<HTMLElement>) => DataGridCellState;

/**
 * Apply styling to the DataGridCell slots based on the state
 */
export declare const useDataGridCellStyles_unstable: (state: DataGridCellState) => DataGridCellState;

export declare const useDataGridContext_unstable: <T>(selector: ContextSelector<DataGridContextValue, T>) => T;

export declare function useDataGridContextValues_unstable(state: DataGridState): DataGridContextValues;

/**
 * Create the state required to render DataGridHeader.
 *
 * The returned state can be modified with hooks such as useDataGridHeaderStyles_unstable,
 * before being passed to renderDataGridHeader_unstable.
 *
 * @param props - props from this instance of DataGridHeader
 * @param ref - reference to root HTMLElement of DataGridHeader
 */
export declare const useDataGridHeader_unstable: (props: DataGridHeaderProps, ref: React_2.Ref<HTMLElement>) => DataGridHeaderState;

/**
 * Create the state required to render DataGridHeaderCell.
 *
 * The returned state can be modified with hooks such as useDataGridHeaderCellStyles_unstable,
 * before being passed to renderDataGridHeaderCell_unstable.
 *
 * @param props - props from this instance of DataGridHeaderCell
 * @param ref - reference to root HTMLElement of DataGridHeaderCell
 */
export declare const useDataGridHeaderCell_unstable: (props: DataGridHeaderCellProps, ref: React_2.Ref<HTMLElement>) => DataGridHeaderCellState;

/**
 * Apply styling to the DataGridHeaderCell slots based on the state
 */
export declare const useDataGridHeaderCellStyles_unstable: (state: DataGridHeaderCellState) => DataGridHeaderCellState;

/**
 * Apply styling to the DataGridHeader slots based on the state
 */
export declare const useDataGridHeaderStyles_unstable: (state: DataGridHeaderState) => DataGridHeaderState;

/**
 * Create the state required to render DataGridRow.
 *
 * The returned state can be modified with hooks such as useDataGridRowStyles_unstable,
 * before being passed to renderDataGridRow_unstable.
 *
 * @param props - props from this instance of DataGridRow
 * @param ref - reference to root HTMLElement of DataGridRow
 */
export declare const useDataGridRow_unstable: (props: DataGridRowProps, ref: React_2.Ref<HTMLElement>) => DataGridRowState;

/**
 * Apply styling to the DataGridRow slots based on the state
 */
export declare const useDataGridRowStyles_unstable: (state: DataGridRowState) => DataGridRowState;

/**
 * Create the state required to render DataGridSelectionCell.
 *
 * The returned state can be modified with hooks such as useDataGridSelectionCellStyles_unstable,
 * before being passed to renderDataGridSelectionCell_unstable.
 *
 * @param props - props from this instance of DataGridSelectionCell
 * @param ref - reference to root HTMLElement of DataGridSelectionCell
 */
export declare const useDataGridSelectionCell_unstable: (props: DataGridSelectionCellProps, ref: React_2.Ref<HTMLElement>) => DataGridSelectionCellState;

/**
 * Apply styling to the DataGridSelectionCell slots based on the state
 */
export declare const useDataGridSelectionCellStyles_unstable: (state: DataGridSelectionCellState) => DataGridSelectionCellState;

/**
 * Apply styling to the DataGrid slots based on the state
 */
export declare const useDataGridStyles_unstable: (state: DataGridState) => DataGridState;

export declare const useIsInTableHeader: () => boolean;

/**
 * Create the state required to render Table.
 *
 * The returned state can be modified with hooks such as useTableStyles_unstable,
 * before being passed to renderTable_unstable.
 *
 * @param props - props from this instance of Table
 * @param ref - reference to root HTMLElement of Table
 */
export declare const useTable_unstable: (props: TableProps, ref: React_2.Ref<HTMLElement>) => TableState;

/**
 * Create the state required to render TableBody.
 *
 * The returned state can be modified with hooks such as useTableBodyStyles_unstable,
 * before being passed to renderTableBody_unstable.
 *
 * @param props - props from this instance of TableBody
 * @param ref - reference to root HTMLElement of TableBody
 */
export declare const useTableBody_unstable: (props: TableBodyProps, ref: React_2.Ref<HTMLElement>) => TableBodyState;

/**
 * Apply styling to the TableBody slots based on the state
 */
export declare const useTableBodyStyles_unstable: (state: TableBodyState) => TableBodyState;

/**
 * Create the state required to render TableCell.
 *
 * The returned state can be modified with hooks such as useTableCellStyles_unstable,
 * before being passed to renderTableCell_unstable.
 *
 * @param props - props from this instance of TableCell
 * @param ref - reference to root HTMLElement of TableCell
 */
export declare const useTableCell_unstable: (props: TableCellProps, ref: React_2.Ref<HTMLElement>) => TableCellState;

/**
 * Create the state required to render TableCellActions.
 *
 * The returned state can be modified with hooks such as useTableCellActionsStyles_unstable,
 * before being passed to renderTableCellActions_unstable.
 *
 * @param props - props from this instance of TableCellActions
 * @param ref - reference to root HTMLElement of TableCellActions
 */
export declare const useTableCellActions_unstable: (props: TableCellActionsProps, ref: React_2.Ref<HTMLElement>) => TableCellActionsState;

/**
 * Apply styling to the TableCellActions slots based on the state
 */
export declare const useTableCellActionsStyles_unstable: (state: TableCellActionsState) => TableCellActionsState;

/**
 * Create the state required to render TableCellLayout.
 *
 * The returned state can be modified with hooks such as useTableCellLayoutStyles_unstable,
 * before being passed to renderTableCellLayout_unstable.
 *
 * @param props - props from this instance of TableCellLayout
 * @param ref - reference to root HTMLElement of TableCellLayout
 */
export declare const useTableCellLayout_unstable: (props: TableCellLayoutProps, ref: React_2.Ref<HTMLElement>) => TableCellLayoutState;

/**
 * Apply styling to the TableCellLayout slots based on the state
 */
export declare const useTableCellLayoutStyles_unstable: (state: TableCellLayoutState) => TableCellLayoutState;

/**
 * Apply styling to the TableCell slots based on the state
 */
export declare const useTableCellStyles_unstable: (state: TableCellState) => TableCellState;

export declare function useTableColumnSizing_unstable<TItem>(params?: UseTableColumnSizingParams): (tableState: TableFeaturesState<TItem>) => TableFeaturesState<TItem>;

declare type UseTableColumnSizingParams = {
    columnSizingOptions?: TableColumnSizingOptions;
    onColumnResize?: (e: KeyboardEvent | TouchEvent | MouseEvent | undefined, data: {
        columnId: TableColumnId;
        width: number;
    }) => void;
    containerWidthOffset?: number;
    autoFitColumns?: boolean;
};

export declare function useTableCompositeNavigation(): {
    onTableKeyDown: React_2.KeyboardEventHandler;
    tableTabsterAttribute: TabsterDOMAttribute;
    tableRowTabsterAttribute: TabsterDOMAttribute;
};

export declare const useTableContext: () => TableContextValue;

export declare function useTableFeatures<TItem>(options: UseTableFeaturesOptions<TItem>, plugins?: TableFeaturePlugin[]): TableFeaturesState<TItem>;

export declare interface UseTableFeaturesOptions<TItem> {
    columns: TableColumnDefinition<TItem>[];
    items: TItem[];
    getRowId?: (item: TItem) => TableRowId;
}

/**
 * Create the state required to render TableHeader.
 *
 * The returned state can be modified with hooks such as useTableHeaderStyles_unstable,
 * before being passed to renderTableHeader_unstable.
 *
 * @param props - props from this instance of TableHeader
 * @param ref - reference to root HTMLElement of TableHeader
 */
export declare const useTableHeader_unstable: (props: TableHeaderProps, ref: React_2.Ref<HTMLElement>) => TableHeaderState;

/**
 * Create the state required to render TableHeaderCell.
 *
 * The returned state can be modified with hooks such as useTableHeaderCellStyles_unstable,
 * before being passed to renderTableHeaderCell_unstable.
 *
 * @param props - props from this instance of TableHeaderCell
 * @param ref - reference to root HTMLElement of TableHeaderCell
 */
export declare const useTableHeaderCell_unstable: (props: TableHeaderCellProps, ref: React_2.Ref<HTMLElement>) => TableHeaderCellState;

/**
 * Apply styling to the TableHeaderCell slots based on the state
 */
export declare const useTableHeaderCellStyles_unstable: (state: TableHeaderCellState) => TableHeaderCellState;

/**
 * Apply styling to the TableHeader slots based on the state
 */
export declare const useTableHeaderStyles_unstable: (state: TableHeaderState) => TableHeaderState;

/**
 * Create the state required to render TableResizeHandle.
 *
 * The returned state can be modified with hooks such as useTableResizeHandleStyles_unstable,
 * before being passed to renderTableResizeHandle_unstable.
 *
 * @param props - props from this instance of TableResizeHandle
 * @param ref - reference to root HTMLElement of TableResizeHandle
 */
export declare const useTableResizeHandle_unstable: (props: TableResizeHandleProps, ref: React_2.Ref<HTMLElement>) => TableResizeHandleState;

/**
 * Apply styling to the TableResizeHandle slots based on the state
 */
export declare const useTableResizeHandleStyles_unstable: (state: TableResizeHandleState) => TableResizeHandleState;

/**
 * Create the state required to render TableRow.
 *
 * The returned state can be modified with hooks such as useTableRowStyles_unstable,
 * before being passed to renderTableRow_unstable.
 *
 * @param props - props from this instance of TableRow
 * @param ref - reference to root HTMLElement of TableRow
 */
export declare const useTableRow_unstable: (props: TableRowProps, ref: React_2.Ref<HTMLElement>) => TableRowState;

export declare const useTableRowIdContext: () => TableRowId;

/**
 * Apply styling to the TableRow slots based on the state
 */
export declare const useTableRowStyles_unstable: (state: TableRowState) => TableRowState;

export declare function useTableSelection<TItem>(options: SelectionHookParams): (tableState: TableFeaturesState<TItem>) => TableFeaturesState<TItem>;

/**
 * Create the state required to render TableSelectionCell.
 *
 * The returned state can be modified with hooks such as useTableSelectionCellStyles_unstable,
 * before being passed to renderTableSelectionCell_unstable.
 *
 * @param props - props from this instance of TableSelectionCell
 * @param ref - reference to root HTMLElement of TableSelectionCell
 */
export declare const useTableSelectionCell_unstable: (props: TableSelectionCellProps, ref: React_2.Ref<HTMLElement>) => TableSelectionCellState;

/**
 * Apply styling to the TableSelectionCell slots based on the state
 */
export declare const useTableSelectionCellStyles_unstable: (state: TableSelectionCellState) => TableSelectionCellState;

export declare function useTableSort<TItem>(options: UseTableSortOptions): (tableState: TableFeaturesState<TItem>) => TableFeaturesState<TItem>;

declare interface UseTableSortOptions {
    /**
     * Used to control sorting
     */
    sortState?: SortState;
    /**
     * Used in uncontrolled mode to set initial sort column and direction on mount
     */
    defaultSortState?: SortState;
    /**
     * Called when sort changes
     */
    onSortChange?(e: React_2.SyntheticEvent, state: SortState): void;
}

/**
 * Apply styling to the Table slots based on the state
 */
export declare const useTableStyles_unstable: (state: TableState) => TableState;

export { }
