'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    switchClassName: function() {
        return switchClassName;
    },
    switchClassNames: function() {
        return switchClassNames;
    },
    useSwitchStyles_unstable: function() {
        return useSwitchStyles_unstable;
    }
});
const _reacttabster = require("@fluentui/react-tabster");
const _reacttheme = require("@fluentui/react-theme");
const _react = require("@griffel/react");
const switchClassNames = {
    root: 'fui-Switch',
    indicator: 'fui-Switch__indicator',
    input: 'fui-Switch__input',
    label: 'fui-Switch__label'
};
const switchClassName = switchClassNames.root;
// Thumb and track sizes used by the component.
const spaceBetweenThumbAndTrack = 2;
const trackHeight = 20;
const trackWidth = 40;
const thumbSize = trackHeight - spaceBetweenThumbAndTrack;
const useRootBaseClassName = (0, _react.makeResetStyles)({
    alignItems: 'flex-start',
    boxSizing: 'border-box',
    display: 'inline-flex',
    position: 'relative',
    ...(0, _reacttabster.createFocusOutlineStyle)({
        style: {},
        selector: 'focus-within'
    })
});
const useRootStyles = (0, _react.makeStyles)({
    vertical: {
        flexDirection: 'column'
    }
});
const useIndicatorBaseClassName = (0, _react.makeResetStyles)({
    borderRadius: _reacttheme.tokens.borderRadiusCircular,
    border: '1px solid',
    lineHeight: 0,
    boxSizing: 'border-box',
    fill: 'currentColor',
    flexShrink: 0,
    fontSize: `${thumbSize}px`,
    height: `${trackHeight}px`,
    margin: _reacttheme.tokens.spacingVerticalS + ' ' + _reacttheme.tokens.spacingHorizontalS,
    pointerEvents: 'none',
    transitionDuration: _reacttheme.tokens.durationNormal,
    transitionTimingFunction: _reacttheme.tokens.curveEasyEase,
    transitionProperty: 'background, border, color',
    width: `${trackWidth}px`,
    '@media screen and (prefers-reduced-motion: reduce)': {
        transitionDuration: '0.01ms'
    },
    '@media (forced-colors: active)': {
        color: 'CanvasText',
        '> i': {
            forcedColorAdjust: 'none'
        }
    },
    '> *': {
        transitionDuration: _reacttheme.tokens.durationNormal,
        transitionTimingFunction: _reacttheme.tokens.curveEasyEase,
        transitionProperty: 'transform',
        '@media screen and (prefers-reduced-motion: reduce)': {
            transitionDuration: '0.01ms'
        }
    }
});
const useIndicatorStyles = (0, _react.makeStyles)({
    labelAbove: {
        marginTop: 0
    }
});
const useInputBaseClassName = (0, _react.makeResetStyles)({
    boxSizing: 'border-box',
    cursor: 'pointer',
    height: '100%',
    margin: 0,
    opacity: 0,
    position: 'absolute',
    // Calculate the width of the hidden input by taking into account the size of the indicator + the padding around it.
    // This is done so that clicking on that "empty space" still toggles the switch.
    width: `calc(${trackWidth}px + 2 * ${_reacttheme.tokens.spacingHorizontalS})`,
    // Checked (both enabled and disabled)
    ':checked': {
        [`& ~ .${switchClassNames.indicator}`]: {
            '> *': {
                transform: `translateX(${trackWidth - thumbSize - spaceBetweenThumbAndTrack}px)`
            }
        }
    },
    // Disabled (both checked and unchecked)
    ':disabled': {
        cursor: 'default',
        [`& ~ .${switchClassNames.indicator}`]: {
            color: _reacttheme.tokens.colorNeutralForegroundDisabled
        },
        [`& ~ .${switchClassNames.label}`]: {
            cursor: 'default',
            color: _reacttheme.tokens.colorNeutralForegroundDisabled
        }
    },
    // Enabled and unchecked
    ':enabled:not(:checked)': {
        [`& ~ .${switchClassNames.indicator}`]: {
            color: _reacttheme.tokens.colorNeutralStrokeAccessible,
            borderColor: _reacttheme.tokens.colorNeutralStrokeAccessible
        },
        [`& ~ .${switchClassNames.label}`]: {
            color: _reacttheme.tokens.colorNeutralForeground1
        },
        ':hover': {
            [`& ~ .${switchClassNames.indicator}`]: {
                color: _reacttheme.tokens.colorNeutralStrokeAccessibleHover,
                borderColor: _reacttheme.tokens.colorNeutralStrokeAccessibleHover
            }
        },
        ':hover:active': {
            [`& ~ .${switchClassNames.indicator}`]: {
                color: _reacttheme.tokens.colorNeutralStrokeAccessiblePressed,
                borderColor: _reacttheme.tokens.colorNeutralStrokeAccessiblePressed
            }
        }
    },
    // Enabled and checked
    ':enabled:checked': {
        [`& ~ .${switchClassNames.indicator}`]: {
            backgroundColor: _reacttheme.tokens.colorCompoundBrandBackground,
            color: _reacttheme.tokens.colorNeutralForegroundInverted,
            borderColor: _reacttheme.tokens.colorTransparentStroke
        },
        ':hover': {
            [`& ~ .${switchClassNames.indicator}`]: {
                backgroundColor: _reacttheme.tokens.colorCompoundBrandBackgroundHover,
                borderColor: _reacttheme.tokens.colorTransparentStrokeInteractive
            }
        },
        ':hover:active': {
            [`& ~ .${switchClassNames.indicator}`]: {
                backgroundColor: _reacttheme.tokens.colorCompoundBrandBackgroundPressed,
                borderColor: _reacttheme.tokens.colorTransparentStrokeInteractive
            }
        }
    },
    // Disabled and unchecked
    ':disabled:not(:checked)': {
        [`& ~ .${switchClassNames.indicator}`]: {
            borderColor: _reacttheme.tokens.colorNeutralStrokeDisabled
        }
    },
    // Disabled and checked
    ':disabled:checked': {
        [`& ~ .${switchClassNames.indicator}`]: {
            backgroundColor: _reacttheme.tokens.colorNeutralBackgroundDisabled,
            borderColor: _reacttheme.tokens.colorTransparentStrokeDisabled
        }
    },
    '@media (forced-colors: active)': {
        ':disabled': {
            [`& ~ .${switchClassNames.indicator}`]: {
                color: 'GrayText',
                borderColor: 'GrayText'
            },
            [`& ~ .${switchClassNames.label}`]: {
                color: 'GrayText'
            }
        },
        ':hover': {
            color: 'CanvasText'
        },
        ':hover:active': {
            color: 'CanvasText'
        },
        ':enabled:checked': {
            ':hover': {
                [`& ~ .${switchClassNames.indicator}`]: {
                    backgroundColor: 'Highlight',
                    color: 'Canvas'
                }
            },
            ':hover:active': {
                [`& ~ .${switchClassNames.indicator}`]: {
                    backgroundColor: 'Highlight',
                    color: 'Canvas'
                }
            },
            [`& ~ .${switchClassNames.indicator}`]: {
                backgroundColor: 'Highlight',
                color: 'Canvas'
            }
        }
    }
});
const useInputStyles = (0, _react.makeStyles)({
    before: {
        right: 0,
        top: 0
    },
    after: {
        left: 0,
        top: 0
    },
    above: {
        bottom: 0,
        height: `calc(${trackHeight}px + ${_reacttheme.tokens.spacingVerticalS})`,
        width: '100%'
    }
});
// Can't use makeResetStyles here because Label is a component that may itself use makeResetStyles.
const useLabelStyles = (0, _react.makeStyles)({
    base: {
        cursor: 'pointer',
        // Use a (negative) margin to account for the difference between the track's height and the label's line height.
        // This prevents the label from expanding the height of the switch, but preserves line height if the label wraps.
        marginBottom: `calc((${trackHeight}px - ${_reacttheme.tokens.lineHeightBase300}) / 2)`,
        marginTop: `calc((${trackHeight}px - ${_reacttheme.tokens.lineHeightBase300}) / 2)`,
        padding: `${_reacttheme.tokens.spacingVerticalS} ${_reacttheme.tokens.spacingHorizontalS}`
    },
    above: {
        paddingTop: _reacttheme.tokens.spacingVerticalXS,
        paddingBottom: _reacttheme.tokens.spacingVerticalXS,
        width: '100%'
    },
    after: {
        paddingLeft: _reacttheme.tokens.spacingHorizontalXS
    },
    before: {
        paddingRight: _reacttheme.tokens.spacingHorizontalXS
    }
});
const useSwitchStyles_unstable = (state)=>{
    'use no memo';
    const rootBaseClassName = useRootBaseClassName();
    const rootStyles = useRootStyles();
    const indicatorBaseClassName = useIndicatorBaseClassName();
    const indicatorStyles = useIndicatorStyles();
    const inputBaseClassName = useInputBaseClassName();
    const inputStyles = useInputStyles();
    const labelStyles = useLabelStyles();
    const { label, labelPosition } = state;
    state.root.className = (0, _react.mergeClasses)(switchClassNames.root, rootBaseClassName, labelPosition === 'above' && rootStyles.vertical, state.root.className);
    state.indicator.className = (0, _react.mergeClasses)(switchClassNames.indicator, indicatorBaseClassName, label && labelPosition === 'above' && indicatorStyles.labelAbove, state.indicator.className);
    state.input.className = (0, _react.mergeClasses)(switchClassNames.input, inputBaseClassName, label && inputStyles[labelPosition], state.input.className);
    if (state.label) {
        state.label.className = (0, _react.mergeClasses)(switchClassNames.label, labelStyles.base, labelStyles[labelPosition], state.label.className);
    }
    return state;
};
