'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useSwitch_unstable", {
    enumerable: true,
    get: function() {
        return useSwitch_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactfield = require("@fluentui/react-field");
const _reacticons = require("@fluentui/react-icons");
const _reactlabel = require("@fluentui/react-label");
const _reacttabster = require("@fluentui/react-tabster");
const _reactutilities = require("@fluentui/react-utilities");
const useSwitch_unstable = (props, ref)=>{
    // Merge props from surrounding <Field>, if any
    props = (0, _reactfield.useFieldControlProps_unstable)(props, {
        supportsLabelFor: true,
        supportsRequired: true
    });
    const { checked, defaultChecked, disabled, labelPosition = 'after', onChange, required } = props;
    const nativeProps = (0, _reactutilities.getPartitionedNativeProps)({
        props,
        primarySlotTagName: 'input',
        excludedPropNames: [
            'checked',
            'defaultChecked',
            'onChange'
        ]
    });
    const id = (0, _reactutilities.useId)('switch-', nativeProps.primary.id);
    const root = _reactutilities.slot.always(props.root, {
        defaultProps: {
            ref: (0, _reacttabster.useFocusWithin)(),
            ...nativeProps.root
        },
        elementType: 'div'
    });
    const indicator = _reactutilities.slot.always(props.indicator, {
        defaultProps: {
            'aria-hidden': true,
            children: /*#__PURE__*/ _react.createElement(_reacticons.CircleFilled, null)
        },
        elementType: 'div'
    });
    const input = _reactutilities.slot.always(props.input, {
        defaultProps: {
            checked,
            defaultChecked,
            id,
            ref,
            role: 'switch',
            type: 'checkbox',
            ...nativeProps.primary
        },
        elementType: 'input'
    });
    input.onChange = (0, _reactutilities.mergeCallbacks)(input.onChange, (ev)=>onChange === null || onChange === void 0 ? void 0 : onChange(ev, {
            checked: ev.currentTarget.checked
        }));
    const label = _reactutilities.slot.optional(props.label, {
        defaultProps: {
            disabled,
            htmlFor: id,
            required,
            size: 'medium'
        },
        elementType: _reactlabel.Label
    });
    return {
        labelPosition,
        components: {
            root: 'div',
            indicator: 'div',
            input: 'input',
            label: _reactlabel.Label
        },
        root,
        indicator,
        input,
        label
    };
};
