import type { ComponentProps } from '@fluentui/react-utilities';
import type { ComponentState } from '@fluentui/react-utilities';
import type { ForwardRefComponent } from '@fluentui/react-utilities';
import type { JSXElement } from '@fluentui/react-utilities';
import { Label } from '@fluentui/react-label';
import * as React_2 from 'react';
import type { Slot } from '@fluentui/react-utilities';
import type { SlotClassNames } from '@fluentui/react-utilities';

/**
 * Render a Switch component by passing the state defined props to the appropriate slots.
 */
export declare const renderSwitch_unstable: (state: SwitchState) => JSXElement;

/**
 * Switches enable users to trigger an option on or off through pressing the component.
 */
export declare const Switch: ForwardRefComponent<SwitchProps>;

/**
 * @deprecated Use `switchClassNames.root` instead.
 */
export declare const switchClassName: string;

export declare const switchClassNames: SlotClassNames<SwitchSlots>;

export declare type SwitchOnChangeData = {
    checked: boolean;
};

/**
 * Switch Props
 */
export declare type SwitchProps = Omit<ComponentProps<Partial<SwitchSlots>, 'input'>, 'checked' | 'defaultChecked' | 'onChange'> & {
    /**
     * Defines the controlled checked state of the Switch.
     * If passed, Switch ignores the `defaultChecked` property.
     * This should only be used if the checked state is to be controlled at a higher level and there is a plan to pass the
     * correct value based on handling `onChange` events and re-rendering.
     *
     * @default false
     */
    checked?: boolean;
    /**
     * Defines whether the Switch is initially in a checked state or not when rendered.
     *
     * @default false
     */
    defaultChecked?: boolean;
    /**
     * The position of the label relative to the Switch.
     *
     * @default after
     */
    labelPosition?: 'above' | 'after' | 'before';
    /**
     * Callback to be called when the checked state value changes.
     */
    onChange?: (ev: React_2.ChangeEvent<HTMLInputElement>, data: SwitchOnChangeData) => void;
};

export declare type SwitchSlots = {
    /**
     * The root element of the Switch.
     *
     * The root slot receives the `className` and `style` specified directly on the `<Switch>` tag.
     * All other native props will be applied to the primary slot: `input`.
     */
    root: NonNullable<Slot<'div'>>;
    /**
     * The track and the thumb sliding over it indicating the on and off status of the Switch.
     */
    indicator: NonNullable<Slot<'div'>>;
    /**
     * Hidden input that handles the Switch's functionality.
     *
     * This is the PRIMARY slot: all native properties specified directly on the `<Switch>` tag will be applied to this
     * slot, except `className` and `style`, which remain on the root slot.
     */
    input: NonNullable<Slot<'input'>>;
    /**
     * The Switch's label.
     */
    label?: Slot<typeof Label>;
};

/**
 * State used in rendering Switch
 */
export declare type SwitchState = ComponentState<SwitchSlots> & Required<Pick<SwitchProps, 'labelPosition'>>;

/**
 * Create the state required to render Switch.
 *
 * The returned state can be modified with hooks such as useSwitchStyles_unstable,
 * before being passed to renderSwitch_unstable.
 *
 * @param props - props from this instance of Switch
 * @param ref - reference to `<input>` element of Switch
 */
export declare const useSwitch_unstable: (props: SwitchProps, ref: React_2.Ref<HTMLInputElement>) => SwitchState;

/**
 * Apply styling to the Switch slots based on the state
 */
export declare const useSwitchStyles_unstable: (state: SwitchState) => SwitchState;

export { }
