'use client';
import * as React from 'react';
import { createContext, useContextSelector } from '@fluentui/react-context-selector';
export const useSwatchPickerContextValues = (state)=>{
    const { isGrid, size, shape, spacing, requestSelectionChange, selectedValue } = state;
    // This context is created with "@fluentui/react-context-selector", these is no sense to memoize it
    const swatchPicker = {
        isGrid,
        size,
        shape,
        spacing,
        selectedValue,
        requestSelectionChange
    };
    return {
        swatchPicker
    };
};
export const swatchPickerContextDefaultValue = {
    requestSelectionChange: ()=>{
    /*noop*/ },
    isGrid: false,
    size: 'medium',
    shape: 'square',
    spacing: 'medium',
    selectedValue: undefined
};
const SwatchPickerContext = createContext(undefined);
export const SwatchPickerProvider = SwatchPickerContext.Provider;
export const useSwatchPickerContextValue_unstable = (selector)=>useContextSelector(SwatchPickerContext, (ctx = swatchPickerContextDefaultValue)=>selector(ctx));
