'use client';

import { __resetStyles, mergeClasses, __styles } from '@griffel/react';
export const swatchPickerRowClassNames = {
  root: 'fui-SwatchPickerRow'
};
/**
 * Styles for the root slot
 */
const useResetStyles = /*#__PURE__*/__resetStyles("r1xhj18k", null, [".r1xhj18k{display:flex;flex-direction:row;}"]);
const useStyles = /*#__PURE__*/__styles({
  spacingSmall: {
    i8kkvl: "f16mnhsx"
  },
  spacingMedium: {
    i8kkvl: "f1q8lukm"
  }
}, {
  d: [".f16mnhsx{column-gap:2px;}", ".f1q8lukm{column-gap:4px;}"]
});
/**
 * Apply styling to the SwatchPickerRow slots based on the state
 */
export const useSwatchPickerRowStyles_unstable = state => {
  'use no memo';

  const resetStyles = useResetStyles();
  const styles = useStyles();
  const spacingStyle = state.spacing === 'small' ? styles.spacingSmall : styles.spacingMedium;
  state.root.className = mergeClasses(swatchPickerRowClassNames.root, resetStyles, spacingStyle, state.root.className);
  return state;
};