'use client';

import { __styles, mergeClasses, __resetStyles } from '@griffel/react';
import { tokens } from '@fluentui/react-theme';
import { createCustomFocusIndicatorStyle } from '@fluentui/react-tabster';
export const imageSwatchClassNames = {
  root: 'fui-ImageSwatch'
};
/**
 * Styles for the root slot
 */
const useStyles = /*#__PURE__*/__resetStyles("r18b5q7m", null, {
  r: [".r18b5q7m{display:inline-flex;box-sizing:border-box;border:1px solid var(--colorTransparentStroke);background-size:cover;background-repeat:no-repeat;padding:0;}", ".r18b5q7m:hover{cursor:pointer;border:none;box-shadow:inset 0 0 0 var(--strokeWidthThick) var(--colorBrandStroke1),inset 0 0 0 var(--strokeWidthThicker) var(--colorStrokeFocus1);}", ".r18b5q7m:hover:active{border:none;box-shadow:inset 0 0 0 var(--strokeWidthThicker) var(--colorCompoundBrandStrokePressed),inset 0 0 0 var(--strokeWidthThickest) var(--colorStrokeFocus1);}", ".r18b5q7m:focus{outline:none;}", ".r18b5q7m:focus-visible{outline:none;}", ".r18b5q7m[data-fui-focus-visible]{border:none;outline:none;box-shadow:inset 0 0 0 var(--strokeWidthThick) var(--colorStrokeFocus2),inset 0 0 0 var(--strokeWidthThicker) var(--colorStrokeFocus1);}"],
  s: ["@media (forced-colors: active){.r18b5q7m{forced-color-adjust:none;}.r18b5q7m:hover{box-shadow:inset 0 0 0 var(--strokeWidthThick) var(--colorBrandStroke2Hover),inset 0 0 0 var(--strokeWidthThicker) var(--colorStrokeFocus1);}.r18b5q7m:hover:active{box-shadow:inset 0 0 0 var(--strokeWidthThicker) var(--colorBrandStroke2Pressed),inset 0 0 0 var(--strokeWidthThickest) var(--colorStrokeFocus1);}}"]
});
const useStylesSelected = /*#__PURE__*/__styles({
  selected: {
    Bgfg5da: 0,
    B9xav0g: 0,
    oivjwe: 0,
    Bn0qgzm: 0,
    B4g9neb: 0,
    zhjwy3: 0,
    wvpqe5: 0,
    ibv6hh: 0,
    u1mtju: 0,
    h3c5rm: 0,
    vrafjx: 0,
    Bekrc4i: 0,
    i8vvqc: 0,
    g2u3we: 0,
    icvyot: 0,
    B4j52fo: 0,
    irswps: "f3bhgqh",
    E5pizo: "f8ps3yo",
    Bvxd0ez: "f106r15f",
    vajtyg: "ft0nc49",
    j6ew2k: "f16jq8vy",
    Bspt33j: "f18nq7tj"
  }
}, {
  d: [[".f3bhgqh{border:none;}", {
    p: -2
  }], ".f8ps3yo{box-shadow:inset 0 0 0 var(--strokeWidthThicker) var(--colorBrandStroke1),inset 0 0 0 5px var(--colorStrokeFocus1);}", ".f16jq8vy[data-fui-focus-visible]{box-shadow:inset 0 0 0 var(--strokeWidthThicker) var(--colorStrokeFocus2),inset 0 0 0 5px var(--colorStrokeFocus1);}"],
  h: [".f106r15f:hover{box-shadow:inset 0 0 0 var(--strokeWidthThickest) var(--colorCompoundBrandStrokeHover),inset 0 0 0 6px var(--colorStrokeFocus1);}", ".ft0nc49:hover:active{box-shadow:inset 0 0 0 var(--strokeWidthThickest) var(--colorCompoundBrandStrokePressed),inset 0 0 0 7px var(--colorStrokeFocus1);}"],
  m: [["@media (forced-colors: active){.f18nq7tj{box-shadow:inset 0 0 0 var(--strokeWidthThicker) var(--colorBrandStroke2Pressed),inset 0 0 0 5px var(--colorStrokeFocus1);}}", {
    m: "(forced-colors: active)"
  }]]
});
const useSizeStyles = /*#__PURE__*/__styles({
  "extra-small": {
    a9b677: "f64fuq3",
    Bqenvij: "fjamq6b"
  },
  small: {
    a9b677: "fq4mcun",
    Bqenvij: "frvgh55"
  },
  medium: {
    a9b677: "f1w9dchk",
    Bqenvij: "fxldao9"
  },
  large: {
    a9b677: "f1szoe96",
    Bqenvij: "f1d2rq10"
  }
}, {
  d: [".f64fuq3{width:20px;}", ".fjamq6b{height:20px;}", ".fq4mcun{width:24px;}", ".frvgh55{height:24px;}", ".f1w9dchk{width:28px;}", ".fxldao9{height:28px;}", ".f1szoe96{width:32px;}", ".f1d2rq10{height:32px;}"]
});
const useShapeStyles = /*#__PURE__*/__styles({
  rounded: {
    Beyfa6y: 0,
    Bbmb7ep: 0,
    Btl43ni: 0,
    B7oj6ja: 0,
    Dimara: "ft85np5",
    Bw81rd7: 0,
    kdpuga: 0,
    dm238s: 0,
    B6xbmo0: 0,
    B3whbx2: "f2krc9w"
  },
  circular: {
    Beyfa6y: 0,
    Bbmb7ep: 0,
    Btl43ni: 0,
    B7oj6ja: 0,
    Dimara: "f44lkw9",
    Bw81rd7: 0,
    kdpuga: 0,
    dm238s: 0,
    B6xbmo0: 0,
    B3whbx2: "f1062rbf"
  },
  square: {
    Beyfa6y: 0,
    Bbmb7ep: 0,
    Btl43ni: 0,
    B7oj6ja: 0,
    Dimara: "f1fabniw",
    Bw81rd7: 0,
    kdpuga: 0,
    dm238s: 0,
    B6xbmo0: 0,
    B3whbx2: "fj0ryk1"
  }
}, {
  d: [[".ft85np5{border-radius:var(--borderRadiusMedium);}", {
    p: -1
  }], [".f2krc9w[data-fui-focus-visible]{border-radius:var(--borderRadiusMedium);}", {
    p: -1
  }], [".f44lkw9{border-radius:var(--borderRadiusCircular);}", {
    p: -1
  }], [".f1062rbf[data-fui-focus-visible]{border-radius:var(--borderRadiusCircular);}", {
    p: -1
  }], [".f1fabniw{border-radius:var(--borderRadiusNone);}", {
    p: -1
  }], [".fj0ryk1[data-fui-focus-visible]{border-radius:var(--borderRadiusNone);}", {
    p: -1
  }]]
});
/**
 * Apply styling to the ImageSwatch slots based on the state
 */
export const useImageSwatchStyles_unstable = state => {
  'use no memo';

  const styles = useStyles();
  const selectedStyles = useStylesSelected();
  const sizeStyles = useSizeStyles();
  const shapeStyles = useShapeStyles();
  const {
    size = 'medium',
    shape = 'square'
  } = state;
  state.root.className = mergeClasses(imageSwatchClassNames.root, styles, sizeStyles[size], shapeStyles[shape], state.selected && selectedStyles.selected, state.root.className);
  return state;
};