'use client';
import * as React from 'react';
import { useImageSwatch_unstable } from './useImageSwatch';
import { renderImageSwatch_unstable } from './renderImageSwatch';
import { useImageSwatchStyles_unstable } from './useImageSwatchStyles.styles';
import { useCustomStyleHook_unstable } from '@fluentui/react-shared-contexts';
/**
 * ImageSwatch component is used to render an images, patterns and textures.
 */ export const ImageSwatch = /*#__PURE__*/ React.forwardRef((props, ref)=>{
    const state = useImageSwatch_unstable(props, ref);
    useImageSwatchStyles_unstable(state);
    useCustomStyleHook_unstable('useImageSwatchStyles_unstable')(state);
    return renderImageSwatch_unstable(state);
});
ImageSwatch.displayName = 'ImageSwatch';
