'use client';
import * as React from 'react';
import { useEmptySwatch_unstable } from './useEmptySwatch';
import { renderEmptySwatch_unstable } from './renderEmptySwatch';
import { useEmptySwatchStyles_unstable } from './useEmptySwatchStyles.styles';
import { useCustomStyleHook_unstable } from '@fluentui/react-shared-contexts';
/**
 * EmptySwatch component is used for adding new color swatches.
 */ export const EmptySwatch = /*#__PURE__*/ React.forwardRef((props, ref)=>{
    const state = useEmptySwatch_unstable(props, ref);
    useEmptySwatchStyles_unstable(state);
    useCustomStyleHook_unstable('useEmptySwatchStyles_unstable')(state);
    return renderEmptySwatch_unstable(state);
});
EmptySwatch.displayName = 'EmptySwatch';
