'use client';

import { __resetStyles, __styles, mergeClasses } from '@griffel/react';
import { tokens } from '@fluentui/react-theme';
import { createCustomFocusIndicatorStyle } from '@fluentui/react-tabster';
export const colorSwatchClassNames = {
  root: 'fui-ColorSwatch',
  icon: 'fui-ColorSwatch__icon',
  disabledIcon: 'fui-ColorSwatch__disabledIcon'
};
export const swatchCSSVars = {
  color: `--fui-SwatchPicker--color`,
  borderColor: `--fui-SwatchPicker--borderColor`
};
const {
  color,
  borderColor
} = swatchCSSVars;
/**
 * Styles for the root slot
 */
const useResetStyles = /*#__PURE__*/__resetStyles("ryw27oi", null, {
  r: [".ryw27oi{display:inline-flex;flex-shrink:0;align-items:center;justify-content:center;box-sizing:border-box;border:1px solid var(--fui-SwatchPicker--borderColor);background:var(--fui-SwatchPicker--color);overflow:hidden;padding:0;}", ".ryw27oi:hover{cursor:pointer;border:none;box-shadow:inset 0 0 0 var(--strokeWidthThick) var(--colorBrandStroke1),inset 0 0 0 var(--strokeWidthThicker) var(--colorStrokeFocus1);}", ".ryw27oi:hover:active{border:none;box-shadow:inset 0 0 0 var(--strokeWidthThicker) var(--colorCompoundBrandStrokePressed),inset 0 0 0 var(--strokeWidthThickest) var(--colorStrokeFocus1);}", ".ryw27oi:focus{outline:none;}", ".ryw27oi:focus-visible{outline:none;}", ".ryw27oi[data-fui-focus-visible]{border:none;outline:none;box-shadow:inset 0 0 0 var(--strokeWidthThick) var(--colorStrokeFocus2),inset 0 0 0 var(--strokeWidthThicker) var(--colorStrokeFocus1);}"],
  s: ["@media (forced-colors: active){.ryw27oi{forced-color-adjust:none;}.ryw27oi:hover{box-shadow:inset 0 0 0 var(--strokeWidthThick) var(--colorBrandStroke2Hover),inset 0 0 0 var(--strokeWidthThicker) var(--colorStrokeFocus1);}.ryw27oi:hover:active{box-shadow:inset 0 0 0 var(--strokeWidthThicker) var(--colorBrandStroke2Pressed),inset 0 0 0 var(--strokeWidthThickest) var(--colorStrokeFocus1);}}"]
});
const useStyles = /*#__PURE__*/__styles({
  disabled: {
    eoavqd: "fphbwmw",
    Bvxd0ez: "f1q3txrk",
    Bs5ihcz: "f1hjbkfk"
  },
  selected: {
    Bgfg5da: 0,
    B9xav0g: 0,
    oivjwe: 0,
    Bn0qgzm: 0,
    B4g9neb: 0,
    zhjwy3: 0,
    wvpqe5: 0,
    ibv6hh: 0,
    u1mtju: 0,
    h3c5rm: 0,
    vrafjx: 0,
    Bekrc4i: 0,
    i8vvqc: 0,
    g2u3we: 0,
    icvyot: 0,
    B4j52fo: 0,
    irswps: "f3bhgqh",
    E5pizo: "f8ps3yo",
    Bvxd0ez: "f106r15f",
    vajtyg: "ft0nc49",
    j6ew2k: "f16jq8vy",
    Bspt33j: "f18nq7tj"
  },
  selectedSmall: {
    E5pizo: "fxflcoq",
    Bvxd0ez: "fha7ylp",
    vajtyg: "fb3iqi"
  }
}, {
  h: [".fphbwmw:hover{cursor:not-allowed;}", ".f1q3txrk:hover{box-shadow:none;}", ".f106r15f:hover{box-shadow:inset 0 0 0 var(--strokeWidthThickest) var(--colorCompoundBrandStrokeHover),inset 0 0 0 6px var(--colorStrokeFocus1);}", ".ft0nc49:hover:active{box-shadow:inset 0 0 0 var(--strokeWidthThickest) var(--colorCompoundBrandStrokePressed),inset 0 0 0 7px var(--colorStrokeFocus1);}", ".fha7ylp:hover{box-shadow:inset 0 0 0 var(--strokeWidthThick) var(--colorCompoundBrandStrokeHover),inset 0 0 0 var(--strokeWidthThicker) var(--colorStrokeFocus1);}", ".fb3iqi:hover:active{box-shadow:inset 0 0 0 var(--strokeWidthThicker) var(--colorCompoundBrandStrokePressed),inset 0 0 0 var(--strokeWidthThickest) var(--colorStrokeFocus1);}"],
  m: [["@media (forced-colors: active){.f1hjbkfk:hover{box-shadow:none;}}", {
    m: "(forced-colors: active)"
  }], ["@media (forced-colors: active){.f18nq7tj{box-shadow:inset 0 0 0 var(--strokeWidthThicker) var(--colorBrandStroke2Pressed),inset 0 0 0 5px var(--colorStrokeFocus1);}}", {
    m: "(forced-colors: active)"
  }]],
  d: [[".f3bhgqh{border:none;}", {
    p: -2
  }], ".f8ps3yo{box-shadow:inset 0 0 0 var(--strokeWidthThicker) var(--colorBrandStroke1),inset 0 0 0 5px var(--colorStrokeFocus1);}", ".f16jq8vy[data-fui-focus-visible]{box-shadow:inset 0 0 0 var(--strokeWidthThicker) var(--colorStrokeFocus2),inset 0 0 0 5px var(--colorStrokeFocus1);}", ".fxflcoq{box-shadow:inset 0 0 0 var(--strokeWidthThick) var(--colorBrandStroke1),inset 0 0 0 var(--strokeWidthThicker) var(--colorStrokeFocus1);}"]
});
const useSizeStyles = /*#__PURE__*/__styles({
  "extra-small": {
    a9b677: "f64fuq3",
    Bqenvij: "fjamq6b",
    Bvxd0ez: "fnzblak",
    Bfsrqk8: 0,
    B9zn80p: 0,
    libdba: 0,
    qi15n7: 0,
    G6mxvm: 0,
    Bpld233: 0,
    B2v0cj4: 0,
    qv9p00: 0,
    Bg6oviu: 0,
    Bk6r4ia: 0,
    Bckajt6: 0,
    Bone85h: 0,
    hkxzgu: 0,
    b661bw: 0,
    kpb45w: 0,
    uiygdg: 0,
    rljib7: "f18wa7jm",
    vajtyg: "faswyoo"
  },
  small: {
    a9b677: "fq4mcun",
    Bqenvij: "frvgh55",
    Bfsrqk8: 0,
    B9zn80p: 0,
    libdba: 0,
    qi15n7: 0,
    G6mxvm: 0,
    Bpld233: 0,
    B2v0cj4: 0,
    qv9p00: 0,
    Bg6oviu: 0,
    Bk6r4ia: 0,
    Bckajt6: 0,
    Bone85h: 0,
    hkxzgu: 0,
    b661bw: 0,
    kpb45w: 0,
    uiygdg: 0,
    rljib7: "f18wa7jm",
    vajtyg: "faswyoo"
  },
  medium: {
    a9b677: "f1w9dchk",
    Bqenvij: "fxldao9"
  },
  large: {
    a9b677: "f1szoe96",
    Bqenvij: "f1d2rq10"
  }
}, {
  d: [".f64fuq3{width:20px;}", ".fjamq6b{height:20px;}", ".fq4mcun{width:24px;}", ".frvgh55{height:24px;}", ".f1w9dchk{width:28px;}", ".fxldao9{height:28px;}", ".f1szoe96{width:32px;}", ".f1d2rq10{height:32px;}"],
  h: [".fnzblak:hover{box-shadow:inset 0 0 0 var(--strokeWidthThin) var(--colorBrandStroke1),inset 0 0 0 var(--strokeWidthThick) var(--colorStrokeFocus1);}", [".f18wa7jm:hover:active{border:none;}", {
    p: -2
  }], ".faswyoo:hover:active{box-shadow:inset 0 0 0 var(--strokeWidthThick) var(--colorCompoundBrandStrokePressed),inset 0 0 0 var(--strokeWidthThicker) var(--colorStrokeFocus1);}", [".f18wa7jm:hover:active{border:none;}", {
    p: -2
  }]]
});
const useShapeStyles = /*#__PURE__*/__styles({
  rounded: {
    Beyfa6y: 0,
    Bbmb7ep: 0,
    Btl43ni: 0,
    B7oj6ja: 0,
    Dimara: "ft85np5",
    Bw81rd7: 0,
    kdpuga: 0,
    dm238s: 0,
    B6xbmo0: 0,
    B3whbx2: "f2krc9w"
  },
  circular: {
    Beyfa6y: 0,
    Bbmb7ep: 0,
    Btl43ni: 0,
    B7oj6ja: 0,
    Dimara: "f44lkw9",
    Bw81rd7: 0,
    kdpuga: 0,
    dm238s: 0,
    B6xbmo0: 0,
    B3whbx2: "f1062rbf"
  },
  square: {
    Beyfa6y: 0,
    Bbmb7ep: 0,
    Btl43ni: 0,
    B7oj6ja: 0,
    Dimara: "f1fabniw",
    Bw81rd7: 0,
    kdpuga: 0,
    dm238s: 0,
    B6xbmo0: 0,
    B3whbx2: "fj0ryk1"
  }
}, {
  d: [[".ft85np5{border-radius:var(--borderRadiusMedium);}", {
    p: -1
  }], [".f2krc9w[data-fui-focus-visible]{border-radius:var(--borderRadiusMedium);}", {
    p: -1
  }], [".f44lkw9{border-radius:var(--borderRadiusCircular);}", {
    p: -1
  }], [".f1062rbf[data-fui-focus-visible]{border-radius:var(--borderRadiusCircular);}", {
    p: -1
  }], [".f1fabniw{border-radius:var(--borderRadiusNone);}", {
    p: -1
  }], [".fj0ryk1[data-fui-focus-visible]{border-radius:var(--borderRadiusNone);}", {
    p: -1
  }]]
});
const useIconStyles = /*#__PURE__*/__styles({
  disabledIcon: {
    sj55zd: "fqpbvvt",
    Bhu2qc9: "f14y0k3d"
  },
  icon: {
    qhf8xq: "f1euv43f",
    mc9l5x: "f22iagw",
    qb2dma: "f7nlbp4"
  },
  "extra-small": {
    Be2twd7: "f4ybsrx"
  },
  small: {
    Be2twd7: "f4ybsrx"
  },
  medium: {
    Be2twd7: "fe5j1ua"
  },
  large: {
    Be2twd7: "f1rt2boy"
  }
}, {
  d: [".fqpbvvt{color:var(--colorNeutralForegroundInverted);}", ".f14y0k3d{filter:drop-shadow(0 1px 1px rgb(0 0 0 / 1));}", ".f1euv43f{position:absolute;}", ".f22iagw{display:flex;}", ".f7nlbp4{align-self:center;}", ".f4ybsrx{font-size:16px;}", ".fe5j1ua{font-size:20px;}", ".f1rt2boy{font-size:24px;}"]
});
/**
 * Apply styling to the ColorSwatch slots based on the state
 */
export const useColorSwatchStyles_unstable = state => {
  'use no memo';

  const {
    size = 'medium',
    shape = 'square'
  } = state;
  const resetStyles = useResetStyles();
  const styles = useStyles();
  const sizeStyles = useSizeStyles();
  const shapeStyles = useShapeStyles();
  const iconStyles = useIconStyles();
  const smallerSelectedStyles = size === 'small' || size === 'extra-small' ? styles.selectedSmall : '';
  state.root.className = mergeClasses(colorSwatchClassNames.root, resetStyles, sizeStyles[size], shapeStyles[shape], state.selected && styles.selected, state.selected && smallerSelectedStyles, state.disabled && styles.disabled, state.root.className);
  if (state.disabled && state.disabledIcon) {
    state.disabledIcon.className = mergeClasses(iconStyles.icon, iconStyles[size], iconStyles.disabledIcon, state.disabledIcon.className);
  }
  if (state.icon) {
    state.icon.className = mergeClasses(iconStyles.icon, iconStyles[size], state.icon.className);
  }
  return state;
};