'use client';
import * as React from 'react';
import { useColorSwatch_unstable } from './useColorSwatch';
import { renderColorSwatch_unstable } from './renderColorSwatch';
import { useColorSwatchStyles_unstable } from './useColorSwatchStyles.styles';
import { useCustomStyleHook_unstable } from '@fluentui/react-shared-contexts';
/**
 * ColorSwatch component is used to render a colors, icons and gradients.
 */ export const ColorSwatch = /*#__PURE__*/ React.forwardRef((props, ref)=>{
    const state = useColorSwatch_unstable(props, ref);
    useColorSwatchStyles_unstable(state);
    useCustomStyleHook_unstable('useColorSwatchStyles_unstable')(state);
    return renderColorSwatch_unstable(state);
});
ColorSwatch.displayName = 'ColorSwatch';
