'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    swatchPickerRowClassNames: function() {
        return swatchPickerRowClassNames;
    },
    useSwatchPickerRowStyles_unstable: function() {
        return useSwatchPickerRowStyles_unstable;
    }
});
const _react = require("@griffel/react");
const swatchPickerRowClassNames = {
    root: 'fui-SwatchPickerRow'
};
/**
 * Styles for the root slot
 */ const useResetStyles = (0, _react.makeResetStyles)({
    display: 'flex',
    flexDirection: 'row'
});
const useStyles = (0, _react.makeStyles)({
    spacingSmall: {
        columnGap: '2px'
    },
    spacingMedium: {
        columnGap: '4px'
    }
});
const useSwatchPickerRowStyles_unstable = (state)=>{
    'use no memo';
    const resetStyles = useResetStyles();
    const styles = useStyles();
    const spacingStyle = state.spacing === 'small' ? styles.spacingSmall : styles.spacingMedium;
    state.root.className = (0, _react.mergeClasses)(swatchPickerRowClassNames.root, resetStyles, spacingStyle, state.root.className);
    return state;
};
