'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    swatchPickerClassNames: function() {
        return swatchPickerClassNames;
    },
    useSwatchPickerStyles_unstable: function() {
        return useSwatchPickerStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const swatchPickerClassNames = {
    root: 'fui-SwatchPicker'
};
/**
 * Styles for the root slot
 */ const useStyles = (0, _react.makeStyles)({
    root: {
        padding: `${_reacttheme.tokens.spacingHorizontalNone} ${_reacttheme.tokens.spacingVerticalNone}`,
        display: 'flex'
    },
    row: {
        flexDirection: 'row'
    },
    grid: {
        flexDirection: 'column'
    },
    spacingSmall: {
        gap: '2px'
    },
    spacingMedium: {
        gap: '4px'
    }
});
const useSwatchPickerStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    const layoutStyle = state.isGrid ? styles.grid : styles.row;
    const spacingStyle = state.spacing === 'small' ? styles.spacingSmall : styles.spacingMedium;
    state.root.className = (0, _react.mergeClasses)(swatchPickerClassNames.root, styles.root, layoutStyle, spacingStyle, state.root.className);
    return state;
};
