'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useSwatchPicker_unstable", {
    enumerable: true,
    get: function() {
        return useSwatchPicker_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactfield = require("@fluentui/react-field");
const _reacttabster = require("@fluentui/react-tabster");
const _reactutilities = require("@fluentui/react-utilities");
const useSwatchPicker_unstable = (props, ref)=>{
    // Merge props from surrounding <Field>, if any
    props = (0, _reactfield.useFieldControlProps_unstable)(props);
    const { layout, onSelectionChange, size = 'medium', shape, spacing = 'medium', style, ...rest } = props;
    const isGrid = layout === 'grid';
    const focusAttributes = (0, _reacttabster.useArrowNavigationGroup)({
        circular: true,
        axis: isGrid ? 'grid-linear' : 'both',
        memorizeCurrent: true
    });
    const role = isGrid ? 'grid' : 'radiogroup';
    const [selectedValue, setSelectedValue] = (0, _reactutilities.useControllableState)({
        state: props.selectedValue,
        defaultState: props.defaultSelectedValue,
        initialState: ''
    });
    const requestSelectionChange = (0, _reactutilities.useEventCallback)((event, data)=>{
        onSelectionChange === null || onSelectionChange === void 0 ? void 0 : onSelectionChange(event, {
            type: 'click',
            event,
            selectedValue: data.selectedValue,
            selectedSwatch: data.selectedSwatch
        });
        setSelectedValue(data.selectedValue);
    });
    return {
        components: {
            root: 'div'
        },
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('div', {
            ref,
            role,
            ...focusAttributes,
            ...rest
        }), {
            elementType: 'div'
        }),
        isGrid,
        requestSelectionChange,
        selectedValue,
        size,
        shape,
        spacing
    };
};
