'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    imageSwatchClassNames: function() {
        return imageSwatchClassNames;
    },
    useImageSwatchStyles_unstable: function() {
        return useImageSwatchStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const _reacttabster = require("@fluentui/react-tabster");
const imageSwatchClassNames = {
    root: 'fui-ImageSwatch'
};
/**
 * Styles for the root slot
 */ const useStyles = (0, _react.makeResetStyles)({
    display: 'inline-flex',
    boxSizing: 'border-box',
    border: `1px solid ${_reacttheme.tokens.colorTransparentStroke}`,
    backgroundSize: 'cover',
    backgroundRepeat: 'no-repeat',
    padding: '0',
    ':hover': {
        cursor: 'pointer',
        border: 'none',
        boxShadow: `inset 0 0 0 ${_reacttheme.tokens.strokeWidthThick} ${_reacttheme.tokens.colorBrandStroke1}, inset 0 0 0 ${_reacttheme.tokens.strokeWidthThicker} ${_reacttheme.tokens.colorStrokeFocus1}`
    },
    ':hover:active': {
        border: 'none',
        boxShadow: `inset 0 0 0 ${_reacttheme.tokens.strokeWidthThicker} ${_reacttheme.tokens.colorCompoundBrandStrokePressed}, inset 0 0 0 ${_reacttheme.tokens.strokeWidthThickest} ${_reacttheme.tokens.colorStrokeFocus1}`
    },
    ':focus': {
        outline: 'none'
    },
    ':focus-visible': {
        outline: 'none'
    },
    ...(0, _reacttabster.createCustomFocusIndicatorStyle)({
        border: 'none',
        outline: 'none',
        boxShadow: `inset 0 0 0 ${_reacttheme.tokens.strokeWidthThick} ${_reacttheme.tokens.colorStrokeFocus2}, inset 0 0 0 ${_reacttheme.tokens.strokeWidthThicker} ${_reacttheme.tokens.colorStrokeFocus1}`
    }),
    // High contrast styles
    '@media (forced-colors: active)': {
        forcedColorAdjust: 'none',
        ':hover': {
            boxShadow: `inset 0 0 0 ${_reacttheme.tokens.strokeWidthThick} ${_reacttheme.tokens.colorBrandStroke2Hover}, inset 0 0 0 ${_reacttheme.tokens.strokeWidthThicker} ${_reacttheme.tokens.colorStrokeFocus1}`
        },
        ':hover:active': {
            boxShadow: `inset 0 0 0 ${_reacttheme.tokens.strokeWidthThicker} ${_reacttheme.tokens.colorBrandStroke2Pressed}, inset 0 0 0 ${_reacttheme.tokens.strokeWidthThickest} ${_reacttheme.tokens.colorStrokeFocus1}`
        }
    }
});
const useStylesSelected = (0, _react.makeStyles)({
    selected: {
        border: 'none',
        boxShadow: `inset 0 0 0 ${_reacttheme.tokens.strokeWidthThicker} ${_reacttheme.tokens.colorBrandStroke1}, inset 0 0 0 5px ${_reacttheme.tokens.colorStrokeFocus1}`,
        ':hover': {
            boxShadow: `inset 0 0 0 ${_reacttheme.tokens.strokeWidthThickest} ${_reacttheme.tokens.colorCompoundBrandStrokeHover}, inset 0 0 0 6px ${_reacttheme.tokens.colorStrokeFocus1}`
        },
        ':hover:active': {
            boxShadow: `inset 0 0 0 ${_reacttheme.tokens.strokeWidthThickest} ${_reacttheme.tokens.colorCompoundBrandStrokePressed}, inset 0 0 0 7px ${_reacttheme.tokens.colorStrokeFocus1}`
        },
        ...(0, _reacttabster.createCustomFocusIndicatorStyle)({
            boxShadow: `inset 0 0 0 ${_reacttheme.tokens.strokeWidthThicker} ${_reacttheme.tokens.colorStrokeFocus2}, inset 0 0 0 5px ${_reacttheme.tokens.colorStrokeFocus1}`
        }),
        '@media (forced-colors: active)': {
            boxShadow: `inset 0 0 0 ${_reacttheme.tokens.strokeWidthThicker} ${_reacttheme.tokens.colorBrandStroke2Pressed}, inset 0 0 0 5px ${_reacttheme.tokens.colorStrokeFocus1}`
        }
    }
});
const useSizeStyles = (0, _react.makeStyles)({
    'extra-small': {
        width: '20px',
        height: '20px'
    },
    small: {
        width: '24px',
        height: '24px'
    },
    medium: {
        width: '28px',
        height: '28px'
    },
    large: {
        width: '32px',
        height: '32px'
    }
});
const useShapeStyles = (0, _react.makeStyles)({
    rounded: {
        borderRadius: _reacttheme.tokens.borderRadiusMedium,
        ...(0, _reacttabster.createCustomFocusIndicatorStyle)({
            borderRadius: _reacttheme.tokens.borderRadiusMedium
        })
    },
    circular: {
        borderRadius: _reacttheme.tokens.borderRadiusCircular,
        ...(0, _reacttabster.createCustomFocusIndicatorStyle)({
            borderRadius: _reacttheme.tokens.borderRadiusCircular
        })
    },
    square: {
        borderRadius: _reacttheme.tokens.borderRadiusNone,
        ...(0, _reacttabster.createCustomFocusIndicatorStyle)({
            borderRadius: _reacttheme.tokens.borderRadiusNone
        })
    }
});
const useImageSwatchStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    const selectedStyles = useStylesSelected();
    const sizeStyles = useSizeStyles();
    const shapeStyles = useShapeStyles();
    const { size = 'medium', shape = 'square' } = state;
    state.root.className = (0, _react.mergeClasses)(imageSwatchClassNames.root, styles, sizeStyles[size], shapeStyles[shape], state.selected && selectedStyles.selected, state.root.className);
    return state;
};
