'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useImageSwatch_unstable", {
    enumerable: true,
    get: function() {
        return useImageSwatch_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _swatchPicker = require("../../contexts/swatchPicker");
const useImageSwatch_unstable = (props, ref)=>{
    const { src, value, onClick, style, ...rest } = props;
    const size = (0, _swatchPicker.useSwatchPickerContextValue_unstable)((ctx)=>ctx.size);
    const shape = (0, _swatchPicker.useSwatchPickerContextValue_unstable)((ctx)=>ctx.shape);
    const isGrid = (0, _swatchPicker.useSwatchPickerContextValue_unstable)((ctx)=>ctx.isGrid);
    const requestSelectionChange = (0, _swatchPicker.useSwatchPickerContextValue_unstable)((ctx)=>ctx.requestSelectionChange);
    const selected = (0, _swatchPicker.useSwatchPickerContextValue_unstable)((ctx)=>ctx.selectedValue === value);
    const role = isGrid ? 'gridcell' : 'radio';
    const ariaSelected = isGrid ? {
        'aria-selected': selected
    } : {
        'aria-checked': selected
    };
    const onImageSwatchClick = (0, _reactutilities.useEventCallback)((0, _reactutilities.mergeCallbacks)(onClick, (event)=>requestSelectionChange(event, {
            selectedValue: value,
            selectedSwatch: src
        })));
    return {
        components: {
            root: 'button'
        },
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('button', {
            ref,
            role,
            ...ariaSelected,
            onClick: onImageSwatchClick,
            ...rest,
            style: {
                backgroundImage: `url(${src})`,
                ...style
            }
        }), {
            elementType: 'button'
        }),
        value,
        selected,
        size,
        shape
    };
};
