'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    emptySwatchClassNames: function() {
        return emptySwatchClassNames;
    },
    useEmptySwatchStyles_unstable: function() {
        return useEmptySwatchStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const _reacttabster = require("@fluentui/react-tabster");
const emptySwatchClassNames = {
    root: 'fui-EmptySwatch'
};
/**
 * Styles for the root slot
 */ const useStyles = (0, _react.makeResetStyles)({
    backgroundColor: _reacttheme.tokens.colorTransparentBackground,
    border: `1px dashed ${_reacttheme.tokens.colorNeutralForeground4}`
});
const useSizeStyles = (0, _react.makeStyles)({
    'extra-small': {
        width: '20px',
        height: '20px'
    },
    small: {
        width: '24px',
        height: '24px'
    },
    medium: {
        width: '28px',
        height: '28px'
    },
    large: {
        width: '32px',
        height: '32px'
    }
});
const useShapeStyles = (0, _react.makeStyles)({
    rounded: {
        borderRadius: _reacttheme.tokens.borderRadiusMedium,
        ...(0, _reacttabster.createCustomFocusIndicatorStyle)({
            borderRadius: _reacttheme.tokens.borderRadiusMedium
        })
    },
    circular: {
        borderRadius: _reacttheme.tokens.borderRadiusCircular,
        ...(0, _reacttabster.createCustomFocusIndicatorStyle)({
            borderRadius: _reacttheme.tokens.borderRadiusCircular
        })
    },
    square: {
        borderRadius: _reacttheme.tokens.borderRadiusNone,
        ...(0, _reacttabster.createCustomFocusIndicatorStyle)({
            borderRadius: _reacttheme.tokens.borderRadiusNone
        })
    }
});
const useEmptySwatchStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    const sizeStyles = useSizeStyles();
    const shapeStyles = useShapeStyles();
    var _state_size;
    const size = (_state_size = state.size) !== null && _state_size !== void 0 ? _state_size : 'medium';
    var _state_shape;
    state.root.className = (0, _react.mergeClasses)(emptySwatchClassNames.root, styles, sizeStyles[size], shapeStyles[(_state_shape = state.shape) !== null && _state_shape !== void 0 ? _state_shape : 'square'], state.root.className);
    return state;
};
