'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    colorSwatchClassNames: function() {
        return colorSwatchClassNames;
    },
    swatchCSSVars: function() {
        return swatchCSSVars;
    },
    useColorSwatchStyles_unstable: function() {
        return useColorSwatchStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const _reacttabster = require("@fluentui/react-tabster");
const colorSwatchClassNames = {
    root: 'fui-ColorSwatch',
    icon: 'fui-ColorSwatch__icon',
    disabledIcon: 'fui-ColorSwatch__disabledIcon'
};
const swatchCSSVars = {
    color: `--fui-SwatchPicker--color`,
    borderColor: `--fui-SwatchPicker--borderColor`
};
const { color, borderColor } = swatchCSSVars;
/**
 * Styles for the root slot
 */ const useResetStyles = (0, _react.makeResetStyles)({
    display: 'inline-flex',
    flexShrink: 0,
    alignItems: 'center',
    justifyContent: 'center',
    boxSizing: 'border-box',
    border: `1px solid var(${borderColor})`,
    background: `var(${color})`,
    overflow: 'hidden',
    padding: '0',
    ':hover': {
        cursor: 'pointer',
        border: 'none',
        boxShadow: `inset 0 0 0 ${_reacttheme.tokens.strokeWidthThick} ${_reacttheme.tokens.colorBrandStroke1}, inset 0 0 0 ${_reacttheme.tokens.strokeWidthThicker} ${_reacttheme.tokens.colorStrokeFocus1}`
    },
    ':hover:active': {
        border: 'none',
        boxShadow: `inset 0 0 0 ${_reacttheme.tokens.strokeWidthThicker} ${_reacttheme.tokens.colorCompoundBrandStrokePressed}, inset 0 0 0 ${_reacttheme.tokens.strokeWidthThickest} ${_reacttheme.tokens.colorStrokeFocus1}`
    },
    ':focus': {
        outline: 'none'
    },
    ':focus-visible': {
        outline: 'none'
    },
    ...(0, _reacttabster.createCustomFocusIndicatorStyle)({
        border: 'none',
        outline: 'none',
        boxShadow: `inset 0 0 0 ${_reacttheme.tokens.strokeWidthThick} ${_reacttheme.tokens.colorStrokeFocus2}, inset 0 0 0 ${_reacttheme.tokens.strokeWidthThicker} ${_reacttheme.tokens.colorStrokeFocus1}`
    }),
    // High contrast styles
    '@media (forced-colors: active)': {
        forcedColorAdjust: 'none',
        ':hover': {
            boxShadow: `inset 0 0 0 ${_reacttheme.tokens.strokeWidthThick} ${_reacttheme.tokens.colorBrandStroke2Hover}, inset 0 0 0 ${_reacttheme.tokens.strokeWidthThicker} ${_reacttheme.tokens.colorStrokeFocus1}`
        },
        ':hover:active': {
            boxShadow: `inset 0 0 0 ${_reacttheme.tokens.strokeWidthThicker} ${_reacttheme.tokens.colorBrandStroke2Pressed}, inset 0 0 0 ${_reacttheme.tokens.strokeWidthThickest} ${_reacttheme.tokens.colorStrokeFocus1}`
        }
    }
});
const useStyles = (0, _react.makeStyles)({
    disabled: {
        ':hover': {
            cursor: 'not-allowed',
            boxShadow: 'none'
        },
        '@media (forced-colors: active)': {
            ':hover': {
                boxShadow: 'none'
            }
        }
    },
    selected: {
        border: 'none',
        boxShadow: `inset 0 0 0 ${_reacttheme.tokens.strokeWidthThicker} ${_reacttheme.tokens.colorBrandStroke1}, inset 0 0 0 5px ${_reacttheme.tokens.colorStrokeFocus1}`,
        ':hover': {
            boxShadow: `inset 0 0 0 ${_reacttheme.tokens.strokeWidthThickest} ${_reacttheme.tokens.colorCompoundBrandStrokeHover}, inset 0 0 0 6px ${_reacttheme.tokens.colorStrokeFocus1}`
        },
        ':hover:active': {
            boxShadow: `inset 0 0 0 ${_reacttheme.tokens.strokeWidthThickest} ${_reacttheme.tokens.colorCompoundBrandStrokePressed}, inset 0 0 0 7px ${_reacttheme.tokens.colorStrokeFocus1}`
        },
        ...(0, _reacttabster.createCustomFocusIndicatorStyle)({
            boxShadow: `inset 0 0 0 ${_reacttheme.tokens.strokeWidthThicker} ${_reacttheme.tokens.colorStrokeFocus2}, inset 0 0 0 5px ${_reacttheme.tokens.colorStrokeFocus1}`
        }),
        '@media (forced-colors: active)': {
            boxShadow: `inset 0 0 0 ${_reacttheme.tokens.strokeWidthThicker} ${_reacttheme.tokens.colorBrandStroke2Pressed}, inset 0 0 0 5px ${_reacttheme.tokens.colorStrokeFocus1}`
        }
    },
    selectedSmall: {
        boxShadow: `inset 0 0 0 ${_reacttheme.tokens.strokeWidthThick} ${_reacttheme.tokens.colorBrandStroke1}, inset 0 0 0 ${_reacttheme.tokens.strokeWidthThicker} ${_reacttheme.tokens.colorStrokeFocus1}`,
        ':hover': {
            boxShadow: `inset 0 0 0 ${_reacttheme.tokens.strokeWidthThick} ${_reacttheme.tokens.colorCompoundBrandStrokeHover}, inset 0 0 0 ${_reacttheme.tokens.strokeWidthThicker} ${_reacttheme.tokens.colorStrokeFocus1}`
        },
        ':hover:active': {
            boxShadow: `inset 0 0 0 ${_reacttheme.tokens.strokeWidthThicker} ${_reacttheme.tokens.colorCompoundBrandStrokePressed}, inset 0 0 0 ${_reacttheme.tokens.strokeWidthThickest} ${_reacttheme.tokens.colorStrokeFocus1}`
        }
    }
});
const useSizeStyles = (0, _react.makeStyles)({
    'extra-small': {
        width: '20px',
        height: '20px',
        ':hover': {
            boxShadow: `inset 0 0 0 ${_reacttheme.tokens.strokeWidthThin} ${_reacttheme.tokens.colorBrandStroke1}, inset 0 0 0 ${_reacttheme.tokens.strokeWidthThick} ${_reacttheme.tokens.colorStrokeFocus1}`
        },
        ':hover:active': {
            border: 'none',
            boxShadow: `inset 0 0 0 ${_reacttheme.tokens.strokeWidthThick} ${_reacttheme.tokens.colorCompoundBrandStrokePressed}, inset 0 0 0 ${_reacttheme.tokens.strokeWidthThicker} ${_reacttheme.tokens.colorStrokeFocus1}`
        }
    },
    small: {
        width: '24px',
        height: '24px',
        ':hover:active': {
            border: 'none',
            boxShadow: `inset 0 0 0 ${_reacttheme.tokens.strokeWidthThick} ${_reacttheme.tokens.colorCompoundBrandStrokePressed}, inset 0 0 0 ${_reacttheme.tokens.strokeWidthThicker} ${_reacttheme.tokens.colorStrokeFocus1}`
        }
    },
    medium: {
        width: '28px',
        height: '28px'
    },
    large: {
        width: '32px',
        height: '32px'
    }
});
const useShapeStyles = (0, _react.makeStyles)({
    rounded: {
        borderRadius: _reacttheme.tokens.borderRadiusMedium,
        ...(0, _reacttabster.createCustomFocusIndicatorStyle)({
            borderRadius: _reacttheme.tokens.borderRadiusMedium
        })
    },
    circular: {
        borderRadius: _reacttheme.tokens.borderRadiusCircular,
        ...(0, _reacttabster.createCustomFocusIndicatorStyle)({
            borderRadius: _reacttheme.tokens.borderRadiusCircular
        })
    },
    square: {
        borderRadius: _reacttheme.tokens.borderRadiusNone,
        ...(0, _reacttabster.createCustomFocusIndicatorStyle)({
            borderRadius: _reacttheme.tokens.borderRadiusNone
        })
    }
});
const useIconStyles = (0, _react.makeStyles)({
    disabledIcon: {
        color: _reacttheme.tokens.colorNeutralForegroundInverted,
        filter: 'drop-shadow(0 1px 1px rgb(0 0 0 / 1))'
    },
    icon: {
        position: 'absolute',
        display: 'flex',
        alignSelf: 'center'
    },
    'extra-small': {
        fontSize: '16px'
    },
    small: {
        fontSize: '16px'
    },
    medium: {
        fontSize: '20px'
    },
    large: {
        fontSize: '24px'
    }
});
const useColorSwatchStyles_unstable = (state)=>{
    'use no memo';
    const { size = 'medium', shape = 'square' } = state;
    const resetStyles = useResetStyles();
    const styles = useStyles();
    const sizeStyles = useSizeStyles();
    const shapeStyles = useShapeStyles();
    const iconStyles = useIconStyles();
    const smallerSelectedStyles = size === 'small' || size === 'extra-small' ? styles.selectedSmall : '';
    state.root.className = (0, _react.mergeClasses)(colorSwatchClassNames.root, resetStyles, sizeStyles[size], shapeStyles[shape], state.selected && styles.selected, state.selected && smallerSelectedStyles, state.disabled && styles.disabled, state.root.className);
    if (state.disabled && state.disabledIcon) {
        state.disabledIcon.className = (0, _react.mergeClasses)(iconStyles.icon, iconStyles[size], iconStyles.disabledIcon, state.disabledIcon.className);
    }
    if (state.icon) {
        state.icon.className = (0, _react.mergeClasses)(iconStyles.icon, iconStyles[size], state.icon.className);
    }
    return state;
};
