'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useColorSwatch_unstable", {
    enumerable: true,
    get: function() {
        return useColorSwatch_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _swatchPicker = require("../../contexts/swatchPicker");
const _useColorSwatchStylesstyles = require("./useColorSwatchStyles.styles");
const _reacticons = require("@fluentui/react-icons");
const _reacttheme = require("@fluentui/react-theme");
const useColorSwatch_unstable = (props, ref)=>{
    const { borderColor, color, disabled, disabledIcon, icon, value, onClick, size, shape, style, ...rest } = props;
    const _size = (0, _swatchPicker.useSwatchPickerContextValue_unstable)((ctx)=>ctx.size);
    const _shape = (0, _swatchPicker.useSwatchPickerContextValue_unstable)((ctx)=>ctx.shape);
    const isGrid = (0, _swatchPicker.useSwatchPickerContextValue_unstable)((ctx)=>ctx.isGrid);
    const requestSelectionChange = (0, _swatchPicker.useSwatchPickerContextValue_unstable)((ctx)=>ctx.requestSelectionChange);
    const selected = (0, _swatchPicker.useSwatchPickerContextValue_unstable)((ctx)=>ctx.selectedValue === value);
    const onColorSwatchClick = (0, _reactutilities.useEventCallback)((0, _reactutilities.mergeCallbacks)(onClick, (event)=>requestSelectionChange(event, {
            selectedValue: value,
            selectedSwatch: color
        })));
    const rootVariables = {
        [_useColorSwatchStylesstyles.swatchCSSVars.color]: color,
        [_useColorSwatchStylesstyles.swatchCSSVars.borderColor]: borderColor !== null && borderColor !== void 0 ? borderColor : _reacttheme.tokens.colorTransparentStroke
    };
    const role = isGrid ? 'gridcell' : 'radio';
    const ariaSelected = isGrid ? {
        'aria-selected': selected
    } : {
        'aria-checked': selected
    };
    const iconShorthand = _reactutilities.slot.optional(icon, {
        elementType: 'span'
    });
    const disabledIconShorthand = _reactutilities.slot.optional(disabledIcon, {
        defaultProps: {
            children: /*#__PURE__*/ _react.createElement(_reacticons.ProhibitedFilled, null)
        },
        renderByDefault: true,
        elementType: 'span'
    });
    return {
        components: {
            root: 'button',
            icon: 'span',
            disabledIcon: 'span'
        },
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('button', {
            ref,
            role,
            ...ariaSelected,
            onClick: onColorSwatchClick,
            type: 'button',
            disabled,
            ...rest,
            style: {
                ...rootVariables,
                ...style
            }
        }), {
            elementType: 'button'
        }),
        icon: iconShorthand,
        disabledIcon: disabledIconShorthand,
        disabled,
        size: size !== null && size !== void 0 ? size : _size,
        shape: shape !== null && shape !== void 0 ? shape : _shape,
        selected,
        color,
        value
    };
};
