import type { ComponentProps } from '@fluentui/react-utilities';
import type { ComponentState } from '@fluentui/react-utilities';
import type { ContextSelector } from '@fluentui/react-context-selector';
import type { EventData } from '@fluentui/react-utilities';
import type { EventHandler } from '@fluentui/react-utilities';
import type { ForwardRefComponent } from '@fluentui/react-utilities';
import type { JSXElement } from '@fluentui/react-utilities';
import * as React_2 from 'react';
import type { Slot } from '@fluentui/react-utilities';
import type { SlotClassNames } from '@fluentui/react-utilities';

/**
 * ColorSwatch component is used to render a colors, icons and gradients.
 */
export declare const ColorSwatch: ForwardRefComponent<ColorSwatchProps>;

export declare const colorSwatchClassNames: SlotClassNames<ColorSwatchSlots>;

/**
 * ColorSwatch Props
 */
export declare type ColorSwatchProps = ComponentProps<ColorSwatchSlots> & Pick<SwatchPickerProps, 'size' | 'shape'> & {
    /**
     * Border color when contrast is low
     */
    borderColor?: string;
    /**
     * Swatch color
     */
    color: string;
    /**
     * Whether the swatch is disabled
     */
    disabled?: boolean;
    /**
     * Swatch value
     */
    value: string;
};

export declare type ColorSwatchSlots = {
    root: NonNullable<Slot<'button'>>;
    icon?: Slot<'span'>;
    disabledIcon?: Slot<'span'>;
};

/**
 * State used in rendering ColorSwatch
 */
export declare type ColorSwatchState = ComponentState<ColorSwatchSlots> & Pick<ColorSwatchProps, 'color' | 'disabled' | 'size' | 'shape' | 'value'> & {
    selected: boolean;
};

/**
 * EmptySwatch component is used for adding new color swatches.
 */
export declare const EmptySwatch: ForwardRefComponent<EmptySwatchProps>;

export declare const emptySwatchClassNames: SlotClassNames<EmptySwatchSlots>;

/**
 * EmptySwatch Props
 */
export declare type EmptySwatchProps = ComponentProps<EmptySwatchSlots> & Pick<SwatchPickerProps, 'size' | 'shape'>;

export declare type EmptySwatchSlots = {
    root: Slot<'button'>;
};

/**
 * State used in rendering EmptySwatch
 */
export declare type EmptySwatchState = ComponentState<EmptySwatchSlots> & Pick<EmptySwatchProps, 'size' | 'shape'>;

/**
 * ImageSwatch component is used to render an images, patterns and textures.
 */
export declare const ImageSwatch: ForwardRefComponent<ImageSwatchProps>;

export declare const imageSwatchClassNames: SlotClassNames<ImageSwatchSlots>;

/**
 * ImageSwatch Props
 */
export declare type ImageSwatchProps = ComponentProps<ImageSwatchSlots> & Pick<SwatchPickerProps, 'size' | 'shape'> & {
    /**
     * Swatch color
     */
    src: string;
    /**
     * Swatch value
     */
    value: string;
};

export declare type ImageSwatchSlots = {
    root: Slot<'button'>;
};

/**
 * State used in rendering ImageSwatch
 */
export declare type ImageSwatchState = ComponentState<ImageSwatchSlots> & Pick<ImageSwatchProps, 'color' | 'size' | 'shape' | 'value'> & {
    selected: boolean;
};

/**
 * Render the final JSX of ColorSwatch
 */
export declare const renderColorSwatch_unstable: (state: ColorSwatchState) => JSXElement;

/**
 * Render the final JSX of EmptySwatch
 */
export declare const renderEmptySwatch_unstable: (state: EmptySwatchState) => JSXElement;

/**
 * Render the final JSX of ImageSwatch
 */
export declare const renderImageSwatch_unstable: (state: ImageSwatchState) => JSXElement;

/**
 * Render the final JSX of SwatchPicker
 */
export declare const renderSwatchPicker_unstable: (state: SwatchPickerState, contextValues: SwatchPickerContextValues) => JSXElement;

export declare const renderSwatchPickerGrid: (props: SwatchPickerGridProps) => JSXElement[];

/**
 * Render the final JSX of SwatchPickerRow
 */
export declare const renderSwatchPickerRow_unstable: (state: SwatchPickerRowState) => JSXElement;

export declare const swatchCSSVars: {
    color: string;
    borderColor: string;
};

/**
 * SwatchPicker component - TODO: add more docs
 */
export declare const SwatchPicker: ForwardRefComponent<SwatchPickerProps>;

export declare const swatchPickerClassNames: SlotClassNames<SwatchPickerSlots>;

export declare const swatchPickerContextDefaultValue: SwatchPickerContextValue;

/**
 * The context through which individual color controls communicate with the picker.
 */
export declare type SwatchPickerContextValue = Pick<SwatchPickerProps, 'size' | 'shape' | 'spacing' | 'selectedValue'> & {
    /**
     * Whether layout is grid.
     */
    isGrid: boolean;
    /**
     * @internal
     * Callback used by ColorSwatch to request a change on it's selected state
     * Should be used to select ColorSwatch
     */
    requestSelectionChange: (event: React_2.MouseEvent<HTMLButtonElement>, data: {
        selectedValue: string;
        selectedSwatch: string;
    }) => void;
};

export declare type SwatchPickerContextValues = {
    swatchPicker: SwatchPickerContextValue;
};

export declare type SwatchPickerGridProps = {
    items: SwatchProps[];
    columnCount: number;
    renderRow?: (props: {
        children: JSXElement[];
        rowId: string | number;
    }) => JSXElement;
    renderSwatch?: (item: SwatchProps) => JSXElement;
};

export declare type SwatchPickerOnSelectEventHandler = EventHandler<SwatchPickerOnSelectionChangeData>;

export declare type SwatchPickerOnSelectionChangeData = EventData<'click', React_2.MouseEvent<HTMLButtonElement>> & {
    selectedValue: string;
    selectedSwatch: string;
};

/**
 * SwatchPicker Props
 */
export declare type SwatchPickerProps = ComponentProps<SwatchPickerSlots> & {
    /**
     * Default selected value
     */
    defaultSelectedValue?: string;
    /**
     * Whether SwatchPicker is row or grid
     */
    layout?: 'row' | 'grid';
    /**
     * Triggers a callback when the value has been changed
     */
    onSelectionChange?: EventHandler<SwatchPickerOnSelectionChangeData>;
    /**
     * Controlled selected value
     */
    selectedValue?: string;
    /**
     * Swatch size
     * @defaultvalue 'medium'
     */
    size?: 'extra-small' | 'small' | 'medium' | 'large';
    /**
     * Swatch shape
     * @defaultvalue 'square'
     */
    shape?: 'rounded' | 'square' | 'circular';
    /**
     * Spacing between swatches
     * @defaultvalue 'medium'
     */
    spacing?: 'small' | 'medium';
};

export declare const SwatchPickerProvider: React_2.Provider<SwatchPickerContextValue> & React_2.FC<React_2.ProviderProps<SwatchPickerContextValue>>;

/**
 * SwatchPickerRow component is used to render a row of swatches.
 */
export declare const SwatchPickerRow: ForwardRefComponent<SwatchPickerRowProps>;

export declare const swatchPickerRowClassNames: SlotClassNames<SwatchPickerRowSlots>;

/**
 * SwatchPickerRow Props
 */
export declare type SwatchPickerRowProps = ComponentProps<SwatchPickerRowSlots>;

export declare type SwatchPickerRowSlots = {
    root: Slot<'div'>;
};

/**
 * State used in rendering SwatchPickerRow
 */
export declare type SwatchPickerRowState = ComponentState<SwatchPickerRowSlots> & Pick<SwatchPickerProps, 'spacing'>;

export declare type SwatchPickerSlots = {
    root: Slot<'div'>;
};

/**
 * State used in rendering SwatchPicker
 */
export declare type SwatchPickerState = ComponentState<SwatchPickerSlots> & SwatchPickerContextValue & Pick<SwatchPickerProps, 'layout' | 'size' | 'shape' | 'spacing'> & {
    isGrid: boolean;
};

export declare type SwatchProps = ImageSwatchProps | ColorSwatchProps;

/**
 * Create the state required to render ColorSwatch.
 *
 * The returned state can be modified with hooks such as useColorSwatchStyles_unstable,
 * before being passed to renderColorSwatch_unstable.
 *
 * @param props - props from this instance of ColorSwatch
 * @param ref - reference to root HTMLButtonElement of ColorSwatch
 */
export declare const useColorSwatch_unstable: (props: ColorSwatchProps, ref: React_2.Ref<HTMLButtonElement>) => ColorSwatchState;

/**
 * Apply styling to the ColorSwatch slots based on the state
 */
export declare const useColorSwatchStyles_unstable: (state: ColorSwatchState) => ColorSwatchState;

/**
 * Create the state required to render EmptySwatch.
 *
 * The returned state can be modified with hooks such as useEmptySwatchStyles_unstable,
 * before being passed to renderEmptySwatch_unstable.
 *
 * @param props - props from this instance of EmptySwatch
 * @param ref - reference to root HTMLDivElement of EmptySwatch
 */
export declare const useEmptySwatch_unstable: (props: EmptySwatchProps, ref: React_2.Ref<HTMLButtonElement>) => EmptySwatchState;

/**
 * Apply styling to the EmptySwatch slots based on the state
 */
export declare const useEmptySwatchStyles_unstable: (state: EmptySwatchState) => EmptySwatchState;

/**
 * Create the state required to render ImageSwatch.
 *
 * The returned state can be modified with hooks such as useImageSwatchStyles_unstable,
 * before being passed to renderImageSwatch_unstable.
 *
 * @param props - props from this instance of ImageSwatch
 * @param ref - reference to root HTMLDivElement of ImageSwatch
 */
export declare const useImageSwatch_unstable: (props: ImageSwatchProps, ref: React_2.Ref<HTMLButtonElement>) => ImageSwatchState;

/**
 * Apply styling to the ImageSwatch slots based on the state
 */
export declare const useImageSwatchStyles_unstable: (state: ImageSwatchState) => ImageSwatchState;

/**
 * Create the state required to render SwatchPicker.
 *
 * The returned state can be modified with hooks such as useSwatchPickerStyles_unstable,
 * before being passed to renderSwatchPicker_unstable.
 *
 * @param props - props from this instance of SwatchPicker
 * @param ref - reference to root HTMLElement of SwatchPicker
 */
export declare const useSwatchPicker_unstable: (props: SwatchPickerProps, ref: React_2.Ref<HTMLDivElement>) => SwatchPickerState;

export declare const useSwatchPickerContextValue_unstable: <T>(selector: ContextSelector<SwatchPickerContextValue, T>) => T;

export declare const useSwatchPickerContextValues: (state: SwatchPickerState) => SwatchPickerContextValues;

/**
 * Create the state required to render SwatchPickerRow.
 *
 * The returned state can be modified with hooks such as useSwatchPickerRowStyles_unstable,
 * before being passed to renderSwatchPickerRow_unstable.
 *
 * @param props - props from this instance of SwatchPickerRow
 * @param ref - reference to root HTMLDivElement of SwatchPickerRow
 */
export declare const useSwatchPickerRow_unstable: (props: SwatchPickerRowProps, ref: React_2.Ref<HTMLDivElement>) => SwatchPickerRowState;

/**
 * Apply styling to the SwatchPickerRow slots based on the state
 */
export declare const useSwatchPickerRowStyles_unstable: (state: SwatchPickerRowState) => SwatchPickerRowState;

/**
 * Apply styling to the SwatchPicker slots based on the state
 */
export declare const useSwatchPickerStyles_unstable: (state: SwatchPickerState) => SwatchPickerState;

export { }
