'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    spinnerClassNames: function() {
        return spinnerClassNames;
    },
    useSpinnerStyles_unstable: function() {
        return useSpinnerStyles_unstable;
    }
});
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
const _reacttheme = require("@fluentui/react-theme");
const _react = require("@griffel/react");
const spinnerClassNames = {
    root: 'fui-Spinner',
    spinner: 'fui-Spinner__spinner',
    spinnerTail: 'fui-Spinner__spinnerTail',
    label: 'fui-Spinner__label'
};
/**
 * CSS variables used internally by Spinner
 */ const vars = {
    strokeWidth: '--fui-Spinner--strokeWidth'
};
const useRootBaseClassName = (0, _react.makeResetStyles)({
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center',
    lineHeight: '0',
    gap: '8px',
    overflow: 'hidden',
    minWidth: 'min-content'
});
const useRootStyles = (0, _react.makeStyles)({
    vertical: {
        flexDirection: 'column'
    }
});
const useSpinnerBaseClassName = (0, _react.makeResetStyles)({
    position: 'relative',
    flexShrink: 0,
    // Use a mask to create the ring shape of the spinner.
    maskImage: `radial-gradient(closest-side, ` + `transparent calc(100% - var(${vars.strokeWidth}) - 1px), ` + `white calc(100% - var(${vars.strokeWidth})) calc(100% - 1px), ` + `transparent 100%)`,
    backgroundColor: _reacttheme.tokens.colorBrandStroke2Contrast,
    color: _reacttheme.tokens.colorBrandStroke1,
    '@media screen and (forced-colors: active)': {
        backgroundColor: 'HighlightText',
        color: 'Highlight',
        forcedColorAdjust: 'none'
    },
    animationDuration: '1.5s',
    animationIterationCount: 'infinite',
    animationTimingFunction: 'linear',
    animationName: {
        '0%': {
            transform: 'rotate(0deg)'
        },
        '100%': {
            transform: 'rotate(360deg)'
        }
    },
    '@media screen and (prefers-reduced-motion: reduce)': {
        animationDuration: '1.8s'
    }
});
// The spinner tail is rendered using two 135deg arc segments, behind a 105deg arc mask.
// The segments are rotated out from behind the mask to expand the visible arc from
// 30deg (min) to 255deg (max), and then back behind the mask again to shrink the arc.
// The tail and spinner itself also have 360deg rotation animations for the spin.
const useSpinnerTailBaseClassName = (0, _react.makeResetStyles)({
    position: 'absolute',
    display: 'block',
    width: '100%',
    height: '100%',
    maskImage: 'conic-gradient(transparent 105deg, white 105deg)',
    '&::before, &::after': {
        content: '""',
        position: 'absolute',
        display: 'block',
        width: '100%',
        height: '100%',
        animation: 'inherit',
        backgroundImage: 'conic-gradient(currentcolor 135deg, transparent 135deg)'
    },
    animationDuration: '1.5s',
    animationIterationCount: 'infinite',
    animationTimingFunction: _reacttheme.tokens.curveEasyEase,
    animationName: {
        '0%': {
            transform: 'rotate(-135deg)'
        },
        '50%': {
            transform: 'rotate(0deg)'
        },
        '100%': {
            transform: 'rotate(225deg)'
        }
    },
    '&::before': {
        animationName: {
            '0%': {
                transform: 'rotate(0deg)'
            },
            '50%': {
                transform: 'rotate(105deg)'
            },
            '100%': {
                transform: 'rotate(0deg)'
            }
        }
    },
    '&::after': {
        animationName: {
            '0%': {
                transform: 'rotate(0deg)'
            },
            '50%': {
                transform: 'rotate(225deg)'
            },
            '100%': {
                transform: 'rotate(0deg)'
            }
        }
    },
    '@media screen and (prefers-reduced-motion: reduce)': {
        animationIterationCount: '0',
        backgroundImage: 'conic-gradient(transparent 120deg, currentcolor 360deg)',
        '&::before, &::after': {
            content: 'none'
        }
    }
});
const useSpinnerStyles = (0, _react.makeStyles)({
    inverted: {
        backgroundColor: _reacttheme.tokens.colorNeutralStrokeAlpha2,
        color: _reacttheme.tokens.colorNeutralStrokeOnBrand2
    },
    rtlTail: {
        maskImage: 'conic-gradient(white 255deg, transparent 255deg)',
        '&::before, &::after': {
            backgroundImage: 'conic-gradient(transparent 225deg, currentcolor 225deg)'
        },
        '@media screen and (prefers-reduced-motion: reduce)': {
            backgroundImage: 'conic-gradient(currentcolor 0deg, transparent 240deg)'
        }
    },
    'extra-tiny': {
        height: '16px',
        width: '16px',
        [vars.strokeWidth]: _reacttheme.tokens.strokeWidthThick
    },
    tiny: {
        height: '20px',
        width: '20px',
        [vars.strokeWidth]: _reacttheme.tokens.strokeWidthThick
    },
    'extra-small': {
        height: '24px',
        width: '24px',
        [vars.strokeWidth]: _reacttheme.tokens.strokeWidthThick
    },
    small: {
        height: '28px',
        width: '28px',
        [vars.strokeWidth]: _reacttheme.tokens.strokeWidthThick
    },
    medium: {
        height: '32px',
        width: '32px',
        [vars.strokeWidth]: _reacttheme.tokens.strokeWidthThicker
    },
    large: {
        height: '36px',
        width: '36px',
        [vars.strokeWidth]: _reacttheme.tokens.strokeWidthThicker
    },
    'extra-large': {
        height: '40px',
        width: '40px',
        [vars.strokeWidth]: _reacttheme.tokens.strokeWidthThicker
    },
    huge: {
        height: '44px',
        width: '44px',
        [vars.strokeWidth]: _reacttheme.tokens.strokeWidthThickest
    }
});
const useLabelStyles = (0, _react.makeStyles)({
    inverted: {
        color: _reacttheme.tokens.colorNeutralForegroundStaticInverted
    },
    'extra-tiny': {
        ..._reacttheme.typographyStyles.body1
    },
    tiny: {
        ..._reacttheme.typographyStyles.body1
    },
    'extra-small': {
        ..._reacttheme.typographyStyles.body1
    },
    small: {
        ..._reacttheme.typographyStyles.body1
    },
    medium: {
        ..._reacttheme.typographyStyles.subtitle2
    },
    large: {
        ..._reacttheme.typographyStyles.subtitle2
    },
    'extra-large': {
        ..._reacttheme.typographyStyles.subtitle2
    },
    huge: {
        ..._reacttheme.typographyStyles.subtitle1
    }
});
const useSpinnerStyles_unstable = (state)=>{
    'use no memo';
    const { labelPosition, size, appearance } = state;
    const { dir } = (0, _reactsharedcontexts.useFluent_unstable)();
    const rootBaseClassName = useRootBaseClassName();
    const rootStyles = useRootStyles();
    const spinnerBaseClassName = useSpinnerBaseClassName();
    const spinnerStyles = useSpinnerStyles();
    const spinnerTailBaseClassName = useSpinnerTailBaseClassName();
    const labelStyles = useLabelStyles();
    state.root.className = (0, _react.mergeClasses)(spinnerClassNames.root, rootBaseClassName, (labelPosition === 'above' || labelPosition === 'below') && rootStyles.vertical, state.root.className);
    if (state.spinner) {
        state.spinner.className = (0, _react.mergeClasses)(spinnerClassNames.spinner, spinnerBaseClassName, spinnerStyles[size], appearance === 'inverted' && spinnerStyles.inverted, state.spinner.className);
    }
    if (state.spinnerTail) {
        state.spinnerTail.className = (0, _react.mergeClasses)(spinnerClassNames.spinnerTail, spinnerTailBaseClassName, dir === 'rtl' && spinnerStyles.rtlTail, state.spinnerTail.className);
    }
    if (state.label) {
        state.label.className = (0, _react.mergeClasses)(spinnerClassNames.label, labelStyles[size], appearance === 'inverted' && labelStyles.inverted, state.label.className);
    }
    return state;
};
