'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useSpinner_unstable", {
    enumerable: true,
    get: function() {
        return useSpinner_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _reactlabel = require("@fluentui/react-label");
const _SpinnerContext = require("../../contexts/SpinnerContext");
const useSpinner_unstable = (props, ref)=>{
    // Props
    const { size: contextSize } = (0, _SpinnerContext.useSpinnerContext)();
    const { appearance = 'primary', labelPosition = 'after', size = contextSize !== null && contextSize !== void 0 ? contextSize : 'medium', delay = 0 } = props;
    const baseId = (0, _reactutilities.useId)('spinner');
    const { role = 'progressbar', ...rest } = props;
    const nativeRoot = _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('div', {
        // FIXME:
        // `ref` is wrongly assigned to be `HTMLElement` instead of `HTMLDivElement`
        // but since it would be a breaking change to fix it, we are casting ref to it's proper type
        ref: ref,
        role,
        ...rest
    }, [
        'size'
    ]), {
        elementType: 'div'
    });
    const [isShownAfterDelay, setIsShownAfterDelay] = _react.useState(false);
    const [setDelayTimeout, clearDelayTimeout] = (0, _reactutilities.useTimeout)();
    _react.useEffect(()=>{
        if (delay <= 0) {
            return;
        }
        setDelayTimeout(()=>{
            setIsShownAfterDelay(true);
        }, delay);
        return ()=>{
            clearDelayTimeout();
        };
    }, [
        setDelayTimeout,
        clearDelayTimeout,
        delay
    ]);
    const labelShorthand = _reactutilities.slot.optional(props.label, {
        defaultProps: {
            id: baseId
        },
        renderByDefault: false,
        elementType: _reactlabel.Label
    });
    const spinnerShortHand = _reactutilities.slot.optional(props.spinner, {
        renderByDefault: true,
        elementType: 'span'
    });
    if (labelShorthand && nativeRoot && !nativeRoot['aria-labelledby']) {
        nativeRoot['aria-labelledby'] = labelShorthand.id;
    }
    const state = {
        appearance,
        delay,
        labelPosition,
        size,
        shouldRenderSpinner: !delay || isShownAfterDelay,
        components: {
            root: 'div',
            spinner: 'span',
            spinnerTail: 'span',
            label: _reactlabel.Label
        },
        root: nativeRoot,
        spinner: spinnerShortHand,
        spinnerTail: _reactutilities.slot.always(props.spinnerTail, {
            elementType: 'span'
        }),
        label: labelShorthand
    };
    return state;
};
