import type { ComponentProps } from '@fluentui/react-utilities';
import type { ComponentState } from '@fluentui/react-utilities';
import type { ForwardRefComponent } from '@fluentui/react-utilities';
import type { JSXElement } from '@fluentui/react-utilities';
import { Label } from '@fluentui/react-label';
import * as React_2 from 'react';
import type { Slot } from '@fluentui/react-utilities';
import type { SlotClassNames } from '@fluentui/react-utilities';

/**
 * Render the final JSX of Spinner
 */
export declare const renderSpinner_unstable: (state: SpinnerState) => JSXElement;

/**
 * Converged Spinner component for the fluentui repo
 */
export declare const Spinner: ForwardRefComponent<SpinnerProps>;

export declare const spinnerClassNames: SlotClassNames<SpinnerSlots>;

/**
 * @internal
 */
export declare const SpinnerContextProvider: React_2.Provider<SpinnerContextValue | undefined>;

/**
 * @internal
 */
export declare type SpinnerContextValue = Pick<SpinnerProps, 'size'>;

/**
 * Spinner Props
 */
export declare type SpinnerProps = Omit<ComponentProps<SpinnerSlots>, 'size'> & {
    /**
     * The appearance of the Spinner.
     * @default 'primary'
     */
    appearance?: 'primary' | 'inverted';
    /**
     * Time in milliseconds after component mount before spinner is visible.
     * @default 0
     */
    delay?: number;
    /**
     * Where the label is positioned relative to the Spinner
     * @default 'after'
     */
    labelPosition?: 'above' | 'below' | 'before' | 'after';
    /**
     * The size of the spinner.
     * @default 'medium'
     */
    size?: 'extra-tiny' | 'tiny' | 'extra-small' | 'small' | 'medium' | 'large' | 'extra-large' | 'huge';
};

export declare type SpinnerSlots = {
    /**
     * The root of the Spinner.
     * The root slot receives the `className` and `style` specified directly on the `<Spinner>`.
     */
    root: NonNullable<Slot<'div', 'span'>>;
    /**
     * The animated spinning ring.
     */
    spinner?: Slot<'span'>;
    /**
     * The part of the spinner that rotates.
     */
    spinnerTail?: NonNullable<Slot<'span'>>;
    /**
     * An optional label for the Spinner.
     */
    label?: Slot<typeof Label>;
};

/**
 * State used in rendering Spinner
 */
export declare type SpinnerState = ComponentState<SpinnerSlots> & Required<Pick<SpinnerProps, 'appearance' | 'delay' | 'labelPosition' | 'size'>> & {
    /**
     * Should the spinner be rendered in the DOM
     */
    shouldRenderSpinner: boolean;
};

/**
 * Create the state required to render Spinner.
 *
 * The returned state can be modified with hooks such as useSpinnerStyles_unstable,
 * before being passed to renderSpinner_unstable.
 *
 * @param props - props from this instance of Spinner
 * @param ref - reference to root HTMLElement of Spinner
 */
export declare const useSpinner_unstable: (props: SpinnerProps, ref: React_2.Ref<HTMLElement>) => SpinnerState;

/**
 * @internal
 */
export declare const useSpinnerContext: () => SpinnerContextValue;

/**
 * Apply styling to the Spinner slots based on the state
 */
export declare const useSpinnerStyles_unstable: (state: SpinnerState) => SpinnerState;

export { }
