'use client';

import { __resetStyles, __styles, mergeClasses, shorthands } from '@griffel/react';
import { tokens, typographyStyles } from '@fluentui/react-theme';
export const spinButtonClassNames = {
  root: 'fui-SpinButton',
  input: 'fui-SpinButton__input',
  incrementButton: 'fui-SpinButton__incrementButton',
  decrementButton: 'fui-SpinButton__decrementButton'
};
const spinButtonExtraClassNames = {
  buttonActive: 'fui-SpinButton__button_active'
};
const fieldHeights = {
  small: '24px',
  medium: '32px'
};
const useRootClassName = /*#__PURE__*/__resetStyles("r109xulx", "r1h2jnch", {
  r: [".r109xulx{display:inline-grid;grid-template-columns:1fr 24px;grid-template-rows:1fr 1fr;column-gap:var(--spacingHorizontalXS);row-gap:0;position:relative;isolation:isolate;vertical-align:middle;background-color:var(--colorNeutralBackground1);min-height:32px;padding:0 0 0 var(--spacingHorizontalMNudge);border-radius:var(--borderRadiusMedium);}", ".r109xulx::before{content:\"\";box-sizing:border-box;position:absolute;top:0;right:0;bottom:0;left:0;pointer-events:none;z-index:10;border:1px solid var(--colorNeutralStroke1);border-bottom-color:var(--colorNeutralStrokeAccessible);border-radius:var(--borderRadiusMedium);}", ".r109xulx::after{box-sizing:border-box;content:\"\";position:absolute;right:0;bottom:0;left:0;z-index:20;height:max(2px, var(--borderRadiusMedium));border-bottom-left-radius:var(--borderRadiusMedium);border-bottom-right-radius:var(--borderRadiusMedium);border-bottom:2px solid var(--colorCompoundBrandStroke);clip-path:inset(calc(100% - 2px) 0 0 0);transform:scaleX(0);transition-property:transform;transition-duration:var(--durationUltraFast);transition-delay:var(--curveAccelerateMid);}", ".r109xulx:focus-within::after{transform:scaleX(1);transition-property:transform;transition-duration:var(--durationNormal);transition-delay:var(--curveDecelerateMid);}", ".r109xulx:focus-within:active::after{border-bottom-color:var(--colorCompoundBrandStrokePressed);}", ".r109xulx:focus-within{outline:2px solid transparent;}", ".r1h2jnch{display:inline-grid;grid-template-columns:1fr 24px;grid-template-rows:1fr 1fr;column-gap:var(--spacingHorizontalXS);row-gap:0;position:relative;isolation:isolate;vertical-align:middle;background-color:var(--colorNeutralBackground1);min-height:32px;padding:0 var(--spacingHorizontalMNudge) 0 0;border-radius:var(--borderRadiusMedium);}", ".r1h2jnch::before{content:\"\";box-sizing:border-box;position:absolute;top:0;left:0;bottom:0;right:0;pointer-events:none;z-index:10;border:1px solid var(--colorNeutralStroke1);border-bottom-color:var(--colorNeutralStrokeAccessible);border-radius:var(--borderRadiusMedium);}", ".r1h2jnch::after{box-sizing:border-box;content:\"\";position:absolute;left:0;bottom:0;right:0;z-index:20;height:max(2px, var(--borderRadiusMedium));border-bottom-right-radius:var(--borderRadiusMedium);border-bottom-left-radius:var(--borderRadiusMedium);border-bottom:2px solid var(--colorCompoundBrandStroke);clip-path:inset(calc(100% - 2px) 0 0 0);transform:scaleX(0);transition-property:transform;transition-duration:var(--durationUltraFast);transition-delay:var(--curveAccelerateMid);}", ".r1h2jnch:focus-within::after{transform:scaleX(1);transition-property:transform;transition-duration:var(--durationNormal);transition-delay:var(--curveDecelerateMid);}", ".r1h2jnch:focus-within:active::after{border-bottom-color:var(--colorCompoundBrandStrokePressed);}", ".r1h2jnch:focus-within{outline:2px solid transparent;}"],
  s: ["@media screen and (prefers-reduced-motion: reduce){.r109xulx::after{transition-duration:0.01ms;transition-delay:0.01ms;}}", "@media screen and (prefers-reduced-motion: reduce){.r109xulx:focus-within::after{transition-duration:0.01ms;transition-delay:0.01ms;}}", "@media screen and (prefers-reduced-motion: reduce){.r1h2jnch::after{transition-duration:0.01ms;transition-delay:0.01ms;}}", "@media screen and (prefers-reduced-motion: reduce){.r1h2jnch:focus-within::after{transition-duration:0.01ms;transition-delay:0.01ms;}}"]
});
const useRootStyles = /*#__PURE__*/__styles({
  small: {
    sshi5w: "f1pha7fy",
    Bahqtrf: "fk6fouc",
    Be2twd7: "fy9rknc",
    Bhrd7zp: "figsok6",
    Bg96gwp: "fwrc4pm",
    uwmqm3: ["f1f5gg8d", "f1vdfbxk"]
  },
  medium: {},
  outline: {},
  outlineInteractive: {
    Bo3r8zu: "f1w2y1rc",
    Hpvxnh: ["f1gofhvl", "f18htlvq"],
    Bx11ytk: "ffcnd28",
    B1rg0w0: ["f18htlvq", "f1gofhvl"],
    Bsg1tlv: "f6lmxco",
    Brjw370: ["fcoc0mf", "f15r4wkl"],
    xcfy85: "f1ipdth8",
    Bcc6kan: ["f15r4wkl", "fcoc0mf"]
  },
  underline: {
    B0qfbqy: "f1o236ok",
    B4f6apu: ["faeg28l", "f64aojp"],
    y0oebl: "fdw6hkg",
    uvfttm: ["f64aojp", "faeg28l"],
    r59vdv: 0,
    Budzafs: 0,
    ck0cow: 0,
    n07z76: 0,
    Gng75u: "f1xyh2jw"
  },
  underlineInteractive: {
    Bx11ytk: "ffcnd28",
    xcfy85: "f1ipdth8",
    d9w3h3: 0,
    B3778ie: 0,
    B4j8arr: 0,
    Bl18szs: 0,
    Blrzh8d: "fkp7w9h"
  },
  filled: {
    Bcgcnre: 0,
    Bqjgrrk: 0,
    qa3bma: 0,
    y0oebl: 0,
    Biqmznv: 0,
    Bm6vgfq: 0,
    Bbv0w2i: 0,
    uvfttm: 0,
    eqrjj: 0,
    Bk5zm6e: 0,
    m598lv: 0,
    B4f6apu: 0,
    ydt019: 0,
    Bq4z7u6: 0,
    Bdkvgpv: 0,
    B0qfbqy: 0,
    kj8mxx: "f1kc0wz4"
  },
  "filled-darker": {
    De3pzq: "f16xq7d1"
  },
  "filled-lighter": {
    De3pzq: "fxugw4r"
  },
  filledInteractive: {
    B05mzqr: "f1xqt08",
    tb9y6h: ["fzt5lgo", "f8tv3r9"],
    jcehpj: "fyhrops",
    B23o0hn: ["f8tv3r9", "fzt5lgo"]
  },
  invalid: {
    emecyz: "fl48pg9",
    lz0pba: ["f1a168p3", "f1pvdymy"],
    Bo1k74p: "f11knvgl",
    Ba322q7: ["f1pvdymy", "f1a168p3"]
  },
  disabled: {
    Bceei9c: "fdrzuqr",
    De3pzq: "f1c21dwh",
    Bq4z7u6: "f1a0lfh7",
    Bk5zm6e: ["f1p2ejm6", "fmzytvz"],
    Bqjgrrk: "fas2e61",
    Bm6vgfq: ["fmzytvz", "f1p2ejm6"],
    Cffpyd: "flb8es4",
    hxi8he: ["f1lclws", "frjp63v"],
    Bcuq369: "f1yv9wnt",
    Imo2if: ["frjp63v", "f1lclws"]
  }
}, {
  d: [".f1pha7fy{min-height:24px;}", ".fk6fouc{font-family:var(--fontFamilyBase);}", ".fy9rknc{font-size:var(--fontSizeBase200);}", ".figsok6{font-weight:var(--fontWeightRegular);}", ".fwrc4pm{line-height:var(--lineHeightBase200);}", ".f1f5gg8d{padding-left:var(--spacingHorizontalS);}", ".f1vdfbxk{padding-right:var(--spacingHorizontalS);}", ".f1o236ok::before{border-top-width:0;}", ".faeg28l::before{border-right-width:0;}", ".f64aojp::before{border-left-width:0;}", ".fdw6hkg::before{border-bottom-width:1px;}", [".f1xyh2jw::before{border-radius:var(--borderRadiusNone);}", {
    p: -1
  }], [".fkp7w9h::after{border-radius:var(--borderRadiusNone);}", {
    p: -1
  }], [".f1kc0wz4::before{border:1px solid var(--colorTransparentStroke);}", {
    p: -2
  }], ".f16xq7d1{background-color:var(--colorNeutralBackground3);}", ".fxugw4r{background-color:var(--colorNeutralBackground1);}", ".fl48pg9:not(:focus-within)::before,.fl48pg9:hover:not(:focus-within)::before{border-top-color:var(--colorPaletteRedBorder2);}", ".f1a168p3:not(:focus-within)::before,.f1a168p3:hover:not(:focus-within)::before{border-right-color:var(--colorPaletteRedBorder2);}", ".f1pvdymy:not(:focus-within)::before,.f1pvdymy:hover:not(:focus-within)::before{border-left-color:var(--colorPaletteRedBorder2);}", ".f11knvgl:not(:focus-within)::before,.f11knvgl:hover:not(:focus-within)::before{border-bottom-color:var(--colorPaletteRedBorder2);}", ".fdrzuqr{cursor:not-allowed;}", ".f1c21dwh{background-color:var(--colorTransparentBackground);}", ".f1a0lfh7::before{border-top-color:var(--colorNeutralStrokeDisabled);}", ".f1p2ejm6::before{border-right-color:var(--colorNeutralStrokeDisabled);}", ".fmzytvz::before{border-left-color:var(--colorNeutralStrokeDisabled);}", ".fas2e61::before{border-bottom-color:var(--colorNeutralStrokeDisabled);}"],
  h: [".f1w2y1rc:hover::before{border-top-color:var(--colorNeutralStroke1Hover);}", ".f1gofhvl:hover::before{border-right-color:var(--colorNeutralStroke1Hover);}", ".f18htlvq:hover::before{border-left-color:var(--colorNeutralStroke1Hover);}", ".ffcnd28:hover::before{border-bottom-color:var(--colorNeutralStrokeAccessibleHover);}", ".f1xqt08:hover::before,.f1xqt08:focus-within::before{border-top-color:var(--colorTransparentStrokeInteractive);}", ".fzt5lgo:hover::before,.fzt5lgo:focus-within::before{border-right-color:var(--colorTransparentStrokeInteractive);}", ".f8tv3r9:hover::before,.f8tv3r9:focus-within::before{border-left-color:var(--colorTransparentStrokeInteractive);}", ".fyhrops:hover::before,.fyhrops:focus-within::before{border-bottom-color:var(--colorTransparentStrokeInteractive);}"],
  a: [".f6lmxco:active::before,.f6lmxco:focus-within::before{border-top-color:var(--colorNeutralStroke1Pressed);}", ".fcoc0mf:active::before,.fcoc0mf:focus-within::before{border-right-color:var(--colorNeutralStroke1Pressed);}", ".f15r4wkl:active::before,.f15r4wkl:focus-within::before{border-left-color:var(--colorNeutralStroke1Pressed);}", ".f1ipdth8:active::before,.f1ipdth8:focus-within::before{border-bottom-color:var(--colorNeutralStrokeAccessiblePressed);}"],
  m: [["@media (forced-colors: active){.flb8es4::before{border-top-color:GrayText;}}", {
    m: "(forced-colors: active)"
  }], ["@media (forced-colors: active){.f1lclws::before{border-right-color:GrayText;}.frjp63v::before{border-left-color:GrayText;}}", {
    m: "(forced-colors: active)"
  }], ["@media (forced-colors: active){.f1yv9wnt::before{border-bottom-color:GrayText;}}", {
    m: "(forced-colors: active)"
  }]]
});
const useInputClassName = /*#__PURE__*/__resetStyles("r1ljrqje", null, [".r1ljrqje{grid-column-start:1;grid-column-end:2;grid-row-start:1;grid-row-end:3;outline-style:none;border:0;padding:0;color:var(--colorNeutralForeground1);background-color:transparent;font-family:inherit;font-size:inherit;font-weight:inherit;line-height:inherit;width:100%;}", ".r1ljrqje::-webkit-input-placeholder{color:var(--colorNeutralForeground4);opacity:1;}", ".r1ljrqje::-moz-placeholder{color:var(--colorNeutralForeground4);opacity:1;}", ".r1ljrqje::placeholder{color:var(--colorNeutralForeground4);opacity:1;}"]);
const useInputStyles = /*#__PURE__*/__styles({
  disabled: {
    sj55zd: "f1s2aq7o",
    Bceei9c: "fdrzuqr",
    De3pzq: "f1c21dwh",
    yvdlaj: "fahhnxm"
  }
}, {
  d: [".f1s2aq7o{color:var(--colorNeutralForegroundDisabled);}", ".fdrzuqr{cursor:not-allowed;}", ".f1c21dwh{background-color:var(--colorTransparentBackground);}", ".fahhnxm::-webkit-input-placeholder{color:var(--colorNeutralForegroundDisabled);}", ".fahhnxm::-moz-placeholder{color:var(--colorNeutralForegroundDisabled);}"]
});
const useBaseButtonClassName = /*#__PURE__*/__resetStyles("r1g4chgs", null, [".r1g4chgs{display:inline-flex;width:24px;align-items:center;justify-content:center;border:0;position:absolute;outline-style:none;height:16px;background-color:transparent;color:var(--colorNeutralForeground3);grid-column-start:2;border-radius:0;padding:0 5px 0 5px;}", ".r1g4chgs:active{outline-style:none;}", ".r1g4chgs:enabled:hover{cursor:pointer;color:var(--colorNeutralForeground3Hover);background-color:var(--colorSubtleBackgroundHover);}", ".r1g4chgs:enabled:active{color:var(--colorNeutralForeground3Pressed);background-color:var(--colorSubtleBackgroundPressed);}", ".r1g4chgs:enabled.fui-SpinButton__button_active{color:var(--colorNeutralForeground3Pressed);background-color:var(--colorSubtleBackgroundPressed);}", ".r1g4chgs:disabled{cursor:not-allowed;color:var(--colorNeutralForegroundDisabled);}"]);
const useButtonStyles = /*#__PURE__*/__styles({
  increment: {
    Ijaq50: "f16hsg94",
    B7oj6ja: ["f1jar5jt", "fyu767a"],
    z8tnut: "f10ra9hq",
    Byoj8tv: "f1brlhvm"
  },
  decrement: {
    Ijaq50: "faunodf",
    Bbmb7ep: ["f1aa9q02", "f16jpd5f"],
    z8tnut: "f1sl3k7w",
    Byoj8tv: "f1y2xyjm"
  },
  incrementButtonSmall: {
    Byoj8tv: 0,
    uwmqm3: 0,
    z189sj: 0,
    z8tnut: 0,
    B0ocmuz: ["f4lv8q1", "fm3uwd2"],
    Bqenvij: "fvblgha"
  },
  decrementButtonSmall: {
    Byoj8tv: 0,
    uwmqm3: 0,
    z189sj: 0,
    z8tnut: 0,
    B0ocmuz: ["f1q86st8", "frkrfqj"],
    Bqenvij: "fvblgha"
  },
  outline: {},
  underline: {
    De3pzq: "f3rmtva",
    sj55zd: "f11d4kpn",
    r4wkhp: "f1no7wuu",
    B95qlz1: "f1bifk9c",
    p743kt: "fp1zg4s",
    B7xitij: "fo6hitd",
    B6siaa6: "f1wiab75",
    Ba9qmo4: "fj9zm5z",
    Dyrjrp: "f1cqwcg4"
  },
  "filled-darker": {
    De3pzq: "f3rmtva",
    sj55zd: "f11d4kpn",
    r4wkhp: "f1no7wuu",
    B95qlz1: "fwwxidx",
    p743kt: "fp1zg4s",
    B7xitij: "f14i52sd",
    B6siaa6: "f1wiab75",
    Ba9qmo4: "fwry2ka",
    Dyrjrp: "f1cqwcg4"
  },
  "filled-lighter": {
    De3pzq: "f3rmtva",
    sj55zd: "f11d4kpn",
    r4wkhp: "f1no7wuu",
    B95qlz1: "f1yywxnv",
    drw0cw: "fzaa11h",
    idzz8t: "f4fpmm9",
    Dyrjrp: "f1cqwcg4"
  }
}, {
  d: [".f16hsg94{grid-row-start:1;}", ".f1jar5jt{border-top-right-radius:var(--borderRadiusMedium);}", ".fyu767a{border-top-left-radius:var(--borderRadiusMedium);}", ".f10ra9hq{padding-top:4px;}", ".f1brlhvm{padding-bottom:1px;}", ".faunodf{grid-row-start:2;}", ".f1aa9q02{border-bottom-right-radius:var(--borderRadiusMedium);}", ".f16jpd5f{border-bottom-left-radius:var(--borderRadiusMedium);}", ".f1sl3k7w{padding-top:1px;}", ".f1y2xyjm{padding-bottom:4px;}", [".f4lv8q1{padding:3px 6px 0px 4px;}", {
    p: -1
  }], [".fm3uwd2{padding:3px 4px 0px 6px;}", {
    p: -1
  }], ".fvblgha{height:12px;}", [".f1q86st8{padding:0px 6px 3px 4px;}", {
    p: -1
  }], [".frkrfqj{padding:0px 4px 3px 6px;}", {
    p: -1
  }], ".f3rmtva{background-color:transparent;}", ".f11d4kpn{color:var(--colorNeutralForeground3);}", ".f1no7wuu:enabled:hover{color:var(--colorNeutralForeground3Hover);}", ".f1bifk9c:enabled:hover{background-color:var(--colorSubtleBackgroundHover);}", ".fp1zg4s:enabled:active{color:var(--colorNeutralForeground3Pressed);}", ".fo6hitd:enabled:active{background-color:var(--colorSubtleBackgroundPressed);}", ".f1wiab75:enabled.fui-SpinButton__button_active{color:var(--colorNeutralForeground3Pressed);}", ".fj9zm5z:enabled.fui-SpinButton__button_active{background-color:var(--colorSubtleBackgroundPressed);}", ".f1cqwcg4:disabled{color:var(--colorNeutralForegroundDisabled);}", ".fwwxidx:enabled:hover{background-color:var(--colorNeutralBackground3Hover);}", ".f14i52sd:enabled:active{background-color:var(--colorNeutralBackground3Pressed);}", ".fwry2ka:enabled.fui-SpinButton__button_active{background-color:var(--colorNeutralBackground3Pressed);}", ".f1yywxnv:enabled:hover{background-color:var(--colorNeutralBackground1Hover);}", ".fzaa11h:enabled:active,.fzaa11h:enabled.fui-SpinButton__button_active{color:var(--colorNeutralForeground3Pressed);}", ".f4fpmm9:enabled:active,.f4fpmm9:enabled.fui-SpinButton__button_active{background-color:var(--colorNeutralBackground1Pressed);}"]
});
/**
 * Apply styling to the SpinButton slots based on the state
 */
export const useSpinButtonStyles_unstable = state => {
  'use no memo';

  const {
    appearance,
    spinState,
    size
  } = state;
  const disabled = state.input.disabled;
  const invalid = `${state.input['aria-invalid']}` === 'true';
  const filled = appearance.startsWith('filled');
  const rootStyles = useRootStyles();
  const buttonStyles = useButtonStyles();
  const inputStyles = useInputStyles();
  state.root.className = mergeClasses(spinButtonClassNames.root, useRootClassName(), rootStyles[size], rootStyles[appearance], filled && rootStyles.filled, !disabled && appearance === 'outline' && rootStyles.outlineInteractive, !disabled && appearance === 'underline' && rootStyles.underlineInteractive, !disabled && filled && rootStyles.filledInteractive, !disabled && invalid && rootStyles.invalid, disabled && rootStyles.disabled, state.root.className);
  state.incrementButton.className = mergeClasses(spinButtonClassNames.incrementButton, spinState === 'up' && `${spinButtonExtraClassNames.buttonActive}`, useBaseButtonClassName(), buttonStyles.increment, buttonStyles[appearance], size === 'small' && buttonStyles.incrementButtonSmall, state.incrementButton.className);
  state.decrementButton.className = mergeClasses(spinButtonClassNames.decrementButton, spinState === 'down' && `${spinButtonExtraClassNames.buttonActive}`, useBaseButtonClassName(), buttonStyles.decrement, buttonStyles[appearance], size === 'small' && buttonStyles.decrementButtonSmall, state.decrementButton.className);
  state.input.className = mergeClasses(spinButtonClassNames.input, useInputClassName(), disabled && inputStyles.disabled, state.input.className);
  return state;
};