import type { ComponentProps } from '@fluentui/react-utilities';
import type { ComponentState } from '@fluentui/react-utilities';
import type { ForwardRefComponent } from '@fluentui/react-utilities';
import type { JSXElement } from '@fluentui/react-utilities';
import * as React_2 from 'react';
import type { Slot } from '@fluentui/react-utilities';
import { SlotClassNames } from '@fluentui/react-utilities';

/**
 * Render the final JSX of SpinButton
 */
export declare const renderSpinButton_unstable: (state: SpinButtonState) => JSXElement;

/**
 * A SpinButton allows someone to incrementally adjust a value in small steps.
 */
export declare const SpinButton: ForwardRefComponent<SpinButtonProps>;

export declare type SpinButtonBounds = 'none' | 'min' | 'max' | 'both';

export declare type SpinButtonChangeEvent = React_2.MouseEvent<HTMLButtonElement> | React_2.ChangeEvent<HTMLElement> | React_2.FocusEvent<HTMLInputElement> | React_2.KeyboardEvent<HTMLInputElement>;

export declare const spinButtonClassNames: SlotClassNames<SpinButtonSlots>;

export declare type SpinButtonOnChangeData = {
    value?: number | null;
    displayValue?: string;
};

/**
 * SpinButton Props
 */
export declare type SpinButtonProps = Omit<ComponentProps<Partial<SpinButtonSlots>, 'input'>, 'defaultValue' | 'onChange' | 'size' | 'value'> & {
    /**
     * Controls the colors and borders of the input.
     * @default 'outline'
     */
    appearance?: 'outline' | 'underline' | 'filled-darker' | 'filled-lighter';
    /**
     * Initial value of the control (assumed to be valid). Updates to this prop will not be respected.
     *
     * Use this if you intend for the SpinButton to be an uncontrolled component which maintains its
     * own value. For a controlled component, use `value` instead. (Mutually exclusive with `value`.)
     *
     * Use `null` to indicate the control has no value.
     */
    defaultValue?: number | null;
    /**
     * String representation of `value`.
     *
     * Use this when displaying the value to users as something other than a plain number.
     * For example, when displaying currency values this might be "$1.00" when value is `1`.
     *
     * Only provide this if the SpinButton is a controlled component where you are maintaining its
     * current state and passing updates based on change events. When SpinButton is used as an
     * uncontrolled component this prop is ignored.
     */
    displayValue?: string;
    /**
     * Max value of the control. If not provided, the control has no maximum value.
     */
    max?: number;
    /**
     * Min value of the control. If not provided, the control has no minimum value.
     */
    min?: number;
    /**
     * Callback for when the committed value changes.
     * - User presses the up/down buttons (on single press or every spin)
     * - User presses the up/down arrow keys (on single press or every spin)
     * - User *commits* edits to the input text by focusing away (blurring) or pressing enter.
     *   Note that this is NOT called for every key press while the user is editing.
     */
    onChange?: (event: SpinButtonChangeEvent, data: SpinButtonOnChangeData) => void;
    /**
     * How many decimal places the value should be rounded to.
     *
     * The default is calculated based on the precision of `step`: i.e. if step = 1, precision = 0.
     * step = 0.0089, precision = 4. step = 300, precision = 2. step = 23.00, precision = 2.
     */
    precision?: number;
    /**
     * Size of the input.
     * @default 'medium'
     */
    size?: 'small' | 'medium';
    /**
     * Difference between two adjacent values of the control.
     * This value is used to calculate the precision of the input if no `precision` is given.
     * The precision calculated this way will always be greater than or equal 0.
     * @default 1
     */
    step?: number;
    /**
     * Large difference between two values. This should be greater than `step` and is used
     * when users hit the Page Up or Page Down keys.
     * @default 1
     */
    stepPage?: number;
    /**
     * Current value of the control (assumed to be valid).
     *
     * Only provide this if the SpinButton is a controlled component where you are maintaining its
     * current state and passing updates based on change events; otherwise, use the `defaultValue`
     * property.
     *
     * Use `null` to indicate the control has no value.
     *
     * Mutually exclusive with `defaultValue`.
     */
    value?: number | null;
};

export declare type SpinButtonSlots = {
    /**
     * The root element of SpinButton is a container `<div>`.
     * The root slot receives the `className` and `style` specified on the `<SpinButton>`.
     * All other native props are applied to the primary slot: `input`.
     */
    root: NonNullable<Slot<'span'>>;
    /**
     * Input that displays the current value and accepts direct input from the user.
     * Displayed value is formatted.
     *
     * This is the primary slot.
     */
    input: NonNullable<Slot<'input'>>;
    /**
     * Renders the increment control.
     */
    incrementButton: NonNullable<Slot<'button'>>;
    /**
     * Renders the decrement control.
     */
    decrementButton: NonNullable<Slot<'button'>>;
};

export declare type SpinButtonSpinState = 'rest' | 'up' | 'down';

/**
 * State used in rendering SpinButton
 */
export declare type SpinButtonState = ComponentState<SpinButtonSlots> & Required<Pick<SpinButtonProps, 'appearance' | 'size'>> & {
    /**
     * State used to track which direction, if any, SpinButton is currently spinning.
     * @default 'rest'
     */
    spinState: SpinButtonSpinState;
    /**
     * State used to track if the value is at the range bounds of [min-max].
     * @default 'none'
     */
    atBound: SpinButtonBounds;
};

/**
 * Create the state required to render SpinButton.
 *
 * The returned state can be modified with hooks such as useSpinButtonStyles_unstable,
 * before being passed to renderSpinButton_unstable.
 *
 * @param props - props from this instance of SpinButton
 * @param ref - reference to root HTMLElement of SpinButton
 */
export declare const useSpinButton_unstable: (props: SpinButtonProps, ref: React_2.Ref<HTMLInputElement>) => SpinButtonState;

/**
 * Apply styling to the SpinButton slots based on the state
 */
export declare const useSpinButtonStyles_unstable: (state: SpinButtonState) => SpinButtonState;

export { }
