'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    sliderCSSVars: function() {
        return sliderCSSVars;
    },
    sliderClassNames: function() {
        return sliderClassNames;
    },
    useSliderStyles_unstable: function() {
        return useSliderStyles_unstable;
    }
});
const _react = require("@griffel/react");
const sliderClassNames = {
    root: 'fui-Slider',
    rail: 'fui-Slider__rail',
    thumb: 'fui-Slider__thumb',
    input: 'fui-Slider__input'
};
// Internal CSS variables
const thumbPositionVar = `--fui-Slider__thumb--position`;
const sliderCSSVars = {
    sliderDirectionVar: `--fui-Slider--direction`,
    sliderInnerThumbRadiusVar: `--fui-Slider__inner-thumb--radius`,
    sliderProgressVar: `--fui-Slider--progress`,
    sliderProgressColorVar: `--fui-Slider__progress--color`,
    sliderRailSizeVar: `--fui-Slider__rail--size`,
    sliderRailColorVar: `--fui-Slider__rail--color`,
    sliderStepsPercentVar: `--fui-Slider--steps-percent`,
    sliderThumbColorVar: `--fui-Slider__thumb--color`,
    sliderThumbSizeVar: `--fui-Slider__thumb--size`
};
const { sliderDirectionVar, sliderInnerThumbRadiusVar, sliderProgressVar, sliderProgressColorVar, sliderRailSizeVar, sliderRailColorVar, sliderStepsPercentVar, sliderThumbColorVar, sliderThumbSizeVar } = sliderCSSVars;
/**
 * Styles for the root slot
 */ const useRootStyles = /*#__PURE__*/ (0, _react.__styles)({
    root: {
        qhf8xq: "f10pi13n",
        mc9l5x: "fwk3njj",
        lpbzjs: "f1sdsnyy",
        Bt984gj: "f122n59",
        B7hvi0a: "f1oiokrs"
    },
    small: {
        Bi64ftq: "f1agqo6f",
        Bslxy2k: "f1mmvox9",
        Ba19x4e: "f1i7ztpd",
        sshi5w: "f1pha7fy"
    },
    medium: {
        Bi64ftq: "f1a78h9h",
        Bslxy2k: "fh1udnr",
        Ba19x4e: "fuok0yf",
        sshi5w: "f1nxs5xn"
    },
    horizontal: {
        Bf4jedk: "fyvtabn",
        wkccdc: "fgfd48t",
        Budl1dq: "f4t5rw1"
    },
    vertical: {
        sshi5w: "f1pzv1zu",
        wkccdc: "fktlcaf",
        Budl1dq: "fiadc6h"
    },
    enabled: {
        B7wi8oa: "f4l8x3l",
        B250r6j: "f671q34",
        Bpmy4es: "fvfzmw5",
        Buw9y6v: "faw1t00",
        Bq939m0: "fxdgx5",
        gjzr1t: "fii04fa",
        tg7hqu: "f36hzz8",
        ypdvl1: "f1volkfw",
        Bw5jdd4: "f1xddb6",
        Bdjie01: "fcdikl",
        Bvh9j6m: "fhpzgm6",
        Bvsvvpo: "f1q6pm3h"
    },
    disabled: {
        Bpmy4es: "foojseg",
        B7wi8oa: "f1lgdqhv",
        B250r6j: "f1veetlj",
        ypdvl1: "fu12m3e",
        Bw5jdd4: "fi9guym",
        Bdjie01: "fcdjl4u"
    },
    focusIndicatorHorizontal: {
        Brovlpu: "ftqa4ok",
        B486eqv: "f2hkw1w",
        Bssx7fj: "f1b1k54r",
        uh7if5: [
            "f4ne723",
            "fqqcjud"
        ],
        clntm0: "fh7aioi",
        Dlk2r6: [
            "fqqcjud",
            "f4ne723"
        ],
        Bm3wd5j: "f1k55ka9",
        Bbrhkcr: [
            "fgclinu",
            "f16pcs8n"
        ],
        f1oku: "fycbxed",
        aywvf2: [
            "f16pcs8n",
            "fgclinu"
        ],
        B2j2mmj: "ffht0p2",
        wigs8: "f1p0ul1q",
        pbfy6t: "f1c901ms",
        B0v4ure: "f1alokd7",
        Byrf0fs: 0,
        Bsiemmq: 0,
        Bwckmig: 0,
        skfxo0: 0,
        Iidy0u: 0,
        B98u21t: 0,
        Bvwlmkc: 0,
        jo1ztg: 0,
        Ba1iezr: 0,
        Blmvk6g: 0,
        B24cy0v: 0,
        Bil7v7r: 0,
        Br3gin4: 0,
        nr063g: 0,
        ghq09: 0,
        Bbgo44z: 0,
        Bseh09z: "fmj8fco",
        az1dzo: 0,
        Ba3ybja: 0,
        B6352mv: 0,
        vppk2z: 0,
        Biaj6j7: "f1iwowo3",
        B2pnrqr: "f1pffoy2",
        B29w5g4: [
            "f1dfga45",
            "f63jj3o"
        ],
        Bhhzhcn: "fs6b7xr",
        Bec0n69: [
            "f63jj3o",
            "f1dfga45"
        ]
    },
    focusIndicatorVertical: {
        Brovlpu: "ftqa4ok",
        B486eqv: "f2hkw1w",
        Bssx7fj: "f1b1k54r",
        uh7if5: [
            "f4ne723",
            "fqqcjud"
        ],
        clntm0: "fh7aioi",
        Dlk2r6: [
            "fqqcjud",
            "f4ne723"
        ],
        Bm3wd5j: "f1k55ka9",
        Bbrhkcr: [
            "fgclinu",
            "f16pcs8n"
        ],
        f1oku: "fycbxed",
        aywvf2: [
            "f16pcs8n",
            "fgclinu"
        ],
        B2j2mmj: "ffht0p2",
        wigs8: "f1p0ul1q",
        pbfy6t: "f1c901ms",
        B0v4ure: "f1alokd7",
        Byrf0fs: 0,
        Bsiemmq: 0,
        Bwckmig: 0,
        skfxo0: 0,
        Iidy0u: 0,
        B98u21t: 0,
        Bvwlmkc: 0,
        jo1ztg: 0,
        Ba1iezr: 0,
        Blmvk6g: 0,
        B24cy0v: 0,
        Bil7v7r: 0,
        Br3gin4: 0,
        nr063g: 0,
        ghq09: 0,
        Bbgo44z: 0,
        Bseh09z: "fmj8fco",
        az1dzo: 0,
        Ba3ybja: 0,
        B6352mv: 0,
        vppk2z: 0,
        Biaj6j7: "f1iwowo3",
        B2pnrqr: "f1pffoy2",
        B29w5g4: [
            "fm5xmfm",
            "femsgmt"
        ],
        Bhhzhcn: "fs6b7xr",
        Bec0n69: [
            "femsgmt",
            "fm5xmfm"
        ]
    }
}, {
    d: [
        ".f10pi13n{position:relative;}",
        ".fwk3njj{display:inline-grid;}",
        ".f1sdsnyy{touch-action:none;}",
        ".f122n59{align-items:center;}",
        ".f1oiokrs{justify-items:center;}",
        ".f1agqo6f{--fui-Slider__thumb--size:16px;}",
        ".f1mmvox9{--fui-Slider__inner-thumb--radius:5px;}",
        ".f1i7ztpd{--fui-Slider__rail--size:2px;}",
        ".f1pha7fy{min-height:24px;}",
        ".f1a78h9h{--fui-Slider__thumb--size:20px;}",
        ".fh1udnr{--fui-Slider__inner-thumb--radius:6px;}",
        ".fuok0yf{--fui-Slider__rail--size:4px;}",
        ".f1nxs5xn{min-height:32px;}",
        ".fyvtabn{min-width:120px;}",
        ".fgfd48t{grid-template-rows:1fr var(--fui-Slider__thumb--size) 1fr;}",
        ".f4t5rw1{grid-template-columns:1fr calc(100% - var(--fui-Slider__thumb--size)) 1fr;}",
        ".f1pzv1zu{min-height:120px;}",
        ".fktlcaf{grid-template-rows:1fr calc(100% - var(--fui-Slider__thumb--size)) 1fr;}",
        ".fiadc6h{grid-template-columns:1fr var(--fui-Slider__thumb--size) 1fr;}",
        ".f4l8x3l{--fui-Slider__rail--color:var(--colorNeutralStrokeAccessible);}",
        ".f671q34{--fui-Slider__progress--color:var(--colorCompoundBrandBackground);}",
        ".fvfzmw5{--fui-Slider__thumb--color:var(--colorCompoundBrandBackground);}",
        ".foojseg{--fui-Slider__thumb--color:var(--colorNeutralForegroundDisabled);}",
        ".f1lgdqhv{--fui-Slider__rail--color:var(--colorNeutralBackgroundDisabled);}",
        ".f1veetlj{--fui-Slider__progress--color:var(--colorNeutralForegroundDisabled);}",
        ".f1b1k54r[data-fui-focus-within]:focus-within{border-top-color:transparent;}",
        ".f4ne723[data-fui-focus-within]:focus-within{border-right-color:transparent;}",
        ".fqqcjud[data-fui-focus-within]:focus-within{border-left-color:transparent;}",
        ".fh7aioi[data-fui-focus-within]:focus-within{border-bottom-color:transparent;}",
        ".ffht0p2[data-fui-focus-within]:focus-within::after{content:\"\";}",
        ".f1p0ul1q[data-fui-focus-within]:focus-within::after{position:absolute;}",
        ".f1c901ms[data-fui-focus-within]:focus-within::after{pointer-events:none;}",
        ".f1alokd7[data-fui-focus-within]:focus-within::after{z-index:1;}",
        [
            ".fmj8fco[data-fui-focus-within]:focus-within::after{border:2px solid var(--colorStrokeFocus2);}",
            {
                p: -2
            }
        ],
        [
            ".f1iwowo3[data-fui-focus-within]:focus-within::after{border-radius:var(--borderRadiusMedium);}",
            {
                p: -1
            }
        ],
        ".f1pffoy2[data-fui-focus-within]:focus-within::after{top:calc(0px - 2px - -2px);}",
        ".f1dfga45[data-fui-focus-within]:focus-within::after{right:calc(0px - 2px - -4px);}",
        ".f63jj3o[data-fui-focus-within]:focus-within::after{left:calc(0px - 2px - -4px);}",
        ".fs6b7xr[data-fui-focus-within]:focus-within::after{bottom:calc(0px - 2px - -2px);}",
        [
            ".fmj8fco[data-fui-focus-within]:focus-within::after{border:2px solid var(--colorStrokeFocus2);}",
            {
                p: -2
            }
        ],
        [
            ".f1iwowo3[data-fui-focus-within]:focus-within::after{border-radius:var(--borderRadiusMedium);}",
            {
                p: -1
            }
        ],
        ".fm5xmfm[data-fui-focus-within]:focus-within::after{right:calc(0px - 2px - 4px);}",
        ".femsgmt[data-fui-focus-within]:focus-within::after{left:calc(0px - 2px - 4px);}"
    ],
    h: [
        ".faw1t00:hover{--fui-Slider__thumb--color:var(--colorCompoundBrandBackgroundHover);}",
        ".fxdgx5:hover{--fui-Slider__progress--color:var(--colorCompoundBrandBackgroundHover);}"
    ],
    a: [
        ".fii04fa:active{--fui-Slider__thumb--color:var(--colorCompoundBrandBackgroundPressed);}",
        ".f36hzz8:active{--fui-Slider__progress--color:var(--colorCompoundBrandBackgroundPressed);}"
    ],
    m: [
        [
            "@media (forced-colors: active){.f1volkfw{--fui-Slider__rail--color:CanvasText;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.f1xddb6{--fui-Slider__thumb--color:Highlight;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.fcdikl{--fui-Slider__progress--color:Highlight;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.fhpzgm6:hover{--fui-Slider__thumb--color:Highlight;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.f1q6pm3h:hover{--fui-Slider__progress--color:Highlight;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.fu12m3e{--fui-Slider__rail--color:GrayText;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.fi9guym{--fui-Slider__thumb--color:GrayText;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.fcdjl4u{--fui-Slider__progress--color:GrayText;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.f1k55ka9[data-fui-focus-within]:focus-within::after{border-top-color:Highlight;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.f16pcs8n[data-fui-focus-within]:focus-within::after{border-left-color:Highlight;}.fgclinu[data-fui-focus-within]:focus-within::after{border-right-color:Highlight;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.fycbxed[data-fui-focus-within]:focus-within::after{border-bottom-color:Highlight;}}",
            {
                m: "(forced-colors: active)"
            }
        ]
    ],
    f: [
        ".ftqa4ok:focus{outline-style:none;}"
    ],
    i: [
        ".f2hkw1w:focus-visible{outline-style:none;}"
    ]
});
/**
 * Styles for the rail slot
 */ const useRailStyles = /*#__PURE__*/ (0, _react.__styles)({
    rail: {
        Beyfa6y: 0,
        Bbmb7ep: 0,
        Btl43ni: 0,
        B7oj6ja: 0,
        Dimara: "f1kijzfu",
        Bkecrkj: "f1aehjj5",
        Ijaq50: "faunodf",
        nk6f5a: "f88nxoq",
        Br312pm: "fd46tj4",
        Bw0ie65: "f1e2fz10",
        qhf8xq: "f10pi13n",
        Bvjb7m6: "fdgv6k0",
        Bcmaq0h: "fizngqt",
        Bpd4iqm: "fpvhumw",
        oeaueh: "f1yog68k",
        Bw0xxkn: "f13sgyd8",
        Ftih45: "fzhtfnv",
        Brfgrao: "f1j7ml58",
        Bbn5juq: "fx36ao7",
        Brdvuy1: "fux3rle"
    },
    horizontal: {
        a9b677: "fly5x3f",
        Bqenvij: "f1cy86ho",
        Fbdkly: [
            "f1heqfse",
            "fkh49vu"
        ],
        mdwyqc: [
            "fkh49vu",
            "f1heqfse"
        ],
        Baz25je: "f16tdq4e"
    },
    vertical: {
        a9b677: "fqxfnkd",
        Bqenvij: "f1l02sjl",
        Ccq8qp: "f1rik0od",
        Bciustq: "f14xwovp",
        lawp4y: "fdehrcx"
    }
}, {
    d: [
        [
            ".f1kijzfu{border-radius:var(--borderRadiusXLarge);}",
            {
                p: -1
            }
        ],
        ".f1aehjj5{pointer-events:none;}",
        ".faunodf{grid-row-start:2;}",
        ".f88nxoq{grid-row-end:2;}",
        ".fd46tj4{grid-column-start:2;}",
        ".f1e2fz10{grid-column-end:2;}",
        ".f10pi13n{position:relative;}",
        ".fdgv6k0{forced-color-adjust:none;}",
        ".fizngqt{background-image:linear-gradient(\n      var(--fui-Slider--direction),\n      var(--fui-Slider__progress--color) 0%,\n      var(--fui-Slider__progress--color) var(--fui-Slider--progress),\n      var(--fui-Slider__rail--color) var(--fui-Slider--progress)\n    );}",
        ".fpvhumw{outline-width:1px;}",
        ".f1yog68k{outline-style:solid;}",
        ".f13sgyd8{outline-color:var(--colorTransparentStroke);}",
        ".fzhtfnv::before{content:'';}",
        ".f1j7ml58::before{position:absolute;}",
        ".fx36ao7::before{background-image:repeating-linear-gradient(\n        var(--fui-Slider--direction),\n        #0000 0%,\n        #0000 calc(var(--fui-Slider--steps-percent) - 1px),\n        var(--colorNeutralBackground1) calc(var(--fui-Slider--steps-percent) - 1px),\n        var(--colorNeutralBackground1) var(--fui-Slider--steps-percent)\n      );}",
        ".fly5x3f{width:100%;}",
        ".f1cy86ho{height:var(--fui-Slider__rail--size);}",
        ".f1heqfse::before{left:-1px;}",
        ".fkh49vu::before{right:-1px;}",
        ".f16tdq4e::before{height:var(--fui-Slider__rail--size);}",
        ".fqxfnkd{width:var(--fui-Slider__rail--size);}",
        ".f1l02sjl{height:100%;}",
        ".f1rik0od::before{width:var(--fui-Slider__rail--size);}",
        ".f14xwovp::before{top:-1px;}",
        ".fdehrcx::before{bottom:-1px;}"
    ],
    m: [
        [
            "@media (forced-colors: active){.fux3rle::before{background-image:repeating-linear-gradient(\n          var(--fui-Slider--direction),\n          #0000 0%,\n          #0000 calc(var(--fui-Slider--steps-percent) - 1px),\n          HighlightText calc(var(--fui-Slider--steps-percent) - 1px),\n          HighlightText var(--fui-Slider--steps-percent)\n        );}}",
            {
                m: "(forced-colors: active)"
            }
        ]
    ]
});
/**
 * Styles for the thumb slot
 */ const useThumbStyles = /*#__PURE__*/ (0, _react.__styles)({
    thumb: {
        B2lzsem: "ftx3jue",
        Ijaq50: "faunodf",
        nk6f5a: "f88nxoq",
        Br312pm: "fd46tj4",
        Bw0ie65: "f1e2fz10",
        qhf8xq: "f1euv43f",
        a9b677: "f174ca62",
        Bqenvij: "f1yfdkfd",
        Bkecrkj: "f1aehjj5",
        oeaueh: "f1s6fcnf",
        Bvjb7m6: "fdgv6k0",
        Beyfa6y: 0,
        Bbmb7ep: 0,
        Btl43ni: 0,
        B7oj6ja: 0,
        Dimara: "f44lkw9",
        E5pizo: "fof7hq0",
        De3pzq: "foksa45",
        Brfgrao: "f1j7ml58",
        Bciustq: "f14u7mkt",
        Fbdkly: [
            "f5zrw40",
            "f1ks5ppg"
        ],
        lawp4y: "fto0uou",
        mdwyqc: [
            "f1ks5ppg",
            "f5zrw40"
        ],
        r59vdv: 0,
        Budzafs: 0,
        ck0cow: 0,
        n07z76: 0,
        Gng75u: "fielpny",
        Bcvre1j: "fyl8oag",
        Ftih45: "fzhtfnv",
        Bcgcnre: 0,
        Bqjgrrk: 0,
        qa3bma: 0,
        y0oebl: 0,
        Biqmznv: 0,
        Bm6vgfq: 0,
        Bbv0w2i: 0,
        uvfttm: 0,
        eqrjj: 0,
        Bk5zm6e: 0,
        m598lv: 0,
        B4f6apu: 0,
        ydt019: 0,
        Bq4z7u6: 0,
        Bdkvgpv: 0,
        B0qfbqy: 0,
        kj8mxx: "f1fsco4d"
    },
    disabled: {
        Bcgcnre: 0,
        Bqjgrrk: 0,
        qa3bma: 0,
        y0oebl: 0,
        Biqmznv: 0,
        Bm6vgfq: 0,
        Bbv0w2i: 0,
        uvfttm: 0,
        eqrjj: 0,
        Bk5zm6e: 0,
        m598lv: 0,
        B4f6apu: 0,
        ydt019: 0,
        Bq4z7u6: 0,
        Bdkvgpv: 0,
        B0qfbqy: 0,
        kj8mxx: "f1pv9hn4"
    },
    horizontal: {
        Bz10aip: [
            "f13gfj74",
            "f1nfknbn"
        ],
        oyh7mz: [
            "foa2ioz",
            "fjmilum"
        ]
    },
    vertical: {
        Bz10aip: "f5cv5a3",
        B5kzvoi: "f1k2fpdo"
    }
}, {
    d: [
        ".ftx3jue{--fui-Slider__thumb--position:clamp(var(--fui-Slider__inner-thumb--radius), var(--fui-Slider--progress), calc(100% - var(--fui-Slider__inner-thumb--radius)));}",
        ".faunodf{grid-row-start:2;}",
        ".f88nxoq{grid-row-end:2;}",
        ".fd46tj4{grid-column-start:2;}",
        ".f1e2fz10{grid-column-end:2;}",
        ".f1euv43f{position:absolute;}",
        ".f174ca62{width:var(--fui-Slider__thumb--size);}",
        ".f1yfdkfd{height:var(--fui-Slider__thumb--size);}",
        ".f1aehjj5{pointer-events:none;}",
        ".f1s6fcnf{outline-style:none;}",
        ".fdgv6k0{forced-color-adjust:none;}",
        [
            ".f44lkw9{border-radius:var(--borderRadiusCircular);}",
            {
                p: -1
            }
        ],
        ".fof7hq0{box-shadow:0 0 0 calc(var(--fui-Slider__thumb--size) * .2) var(--colorNeutralBackground1) inset;}",
        ".foksa45{background-color:var(--fui-Slider__thumb--color);}",
        ".f1j7ml58::before{position:absolute;}",
        ".f14u7mkt::before{top:0px;}",
        ".f5zrw40::before{left:0px;}",
        ".f1ks5ppg::before{right:0px;}",
        ".fto0uou::before{bottom:0px;}",
        [
            ".fielpny::before{border-radius:var(--borderRadiusCircular);}",
            {
                p: -1
            }
        ],
        ".fyl8oag::before{box-sizing:border-box;}",
        ".fzhtfnv::before{content:'';}",
        [
            ".f1fsco4d::before{border:calc(var(--fui-Slider__thumb--size) * .05) solid var(--colorNeutralStroke1);}",
            {
                p: -2
            }
        ],
        [
            ".f1pv9hn4::before{border:calc(var(--fui-Slider__thumb--size) * .05) solid var(--colorNeutralForegroundDisabled);}",
            {
                p: -2
            }
        ],
        ".f13gfj74{transform:translateX(-50%);}",
        ".f1nfknbn{transform:translateX(50%);}",
        ".foa2ioz{left:var(--fui-Slider__thumb--position);}",
        ".fjmilum{right:var(--fui-Slider__thumb--position);}",
        ".f5cv5a3{transform:translateY(50%);}",
        ".f1k2fpdo{bottom:var(--fui-Slider__thumb--position);}"
    ]
});
/**
 * Styles for the Input slot
 */ const useInputStyles = /*#__PURE__*/ (0, _react.__styles)({
    input: {
        Bceei9c: "f1k6fduh",
        abs64n: "fk73vx1",
        Ijaq50: "f16hsg94",
        nk6f5a: "f1nzqi2z",
        Br312pm: "fwpfdsa",
        Bw0ie65: "fuur7zz",
        Byoj8tv: 0,
        uwmqm3: 0,
        z189sj: 0,
        z8tnut: 0,
        B0ocmuz: "f1mk8lai",
        jrapky: 0,
        Frg6f3: 0,
        t21cq0: 0,
        B6of3ja: 0,
        B74szlk: "f1s184ao"
    },
    disabled: {
        Bceei9c: "f158kwzp"
    },
    horizontal: {
        Bqenvij: "f1yfdkfd",
        a9b677: "fly5x3f"
    },
    vertical: {
        Bqenvij: "f1l02sjl",
        a9b677: "f174ca62",
        fsx8h0: "f1mm7lwf",
        B0wtrmc: [
            "fdkxjay",
            "f6bzpni"
        ],
        B5laz1p: "f1ry0dy"
    }
}, {
    d: [
        ".f1k6fduh{cursor:pointer;}",
        ".fk73vx1{opacity:0;}",
        ".f16hsg94{grid-row-start:1;}",
        ".f1nzqi2z{grid-row-end:-1;}",
        ".fwpfdsa{grid-column-start:1;}",
        ".fuur7zz{grid-column-end:-1;}",
        [
            ".f1mk8lai{padding:0;}",
            {
                p: -1
            }
        ],
        [
            ".f1s184ao{margin:0;}",
            {
                p: -1
            }
        ],
        ".f158kwzp{cursor:default;}",
        ".f1yfdkfd{height:var(--fui-Slider__thumb--size);}",
        ".fly5x3f{width:100%;}",
        ".f1l02sjl{height:100%;}",
        ".f174ca62{width:var(--fui-Slider__thumb--size);}"
    ],
    t: [
        "@supports (writing-mode: sideways-lr){.f1mm7lwf{writing-mode:vertical-lr;}}",
        "@supports (writing-mode: sideways-lr){.f6bzpni{direction:ltr;}.fdkxjay{direction:rtl;}}",
        "@supports not (writing-mode: sideways-lr){.f1ry0dy{-webkit-appearance:slider-vertical;}}"
    ]
});
const useSliderStyles_unstable = (state)=>{
    'use no memo';
    const rootStyles = useRootStyles();
    const railStyles = useRailStyles();
    const thumbStyles = useThumbStyles();
    const inputStyles = useInputStyles();
    const isVertical = state.vertical;
    state.root.className = (0, _react.mergeClasses)(sliderClassNames.root, rootStyles.root, isVertical ? rootStyles.focusIndicatorVertical : rootStyles.focusIndicatorHorizontal, rootStyles[state.size], isVertical ? rootStyles.vertical : rootStyles.horizontal, state.disabled ? rootStyles.disabled : rootStyles.enabled, state.root.className);
    state.rail.className = (0, _react.mergeClasses)(sliderClassNames.rail, railStyles.rail, isVertical ? railStyles.vertical : railStyles.horizontal, state.rail.className);
    state.thumb.className = (0, _react.mergeClasses)(sliderClassNames.thumb, thumbStyles.thumb, isVertical ? thumbStyles.vertical : thumbStyles.horizontal, state.disabled && thumbStyles.disabled, state.thumb.className);
    state.input.className = (0, _react.mergeClasses)(sliderClassNames.input, inputStyles.input, isVertical ? inputStyles.vertical : inputStyles.horizontal, state.disabled && inputStyles.disabled, state.input.className);
    return state;
};
