'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useSliderState_unstable", {
    enumerable: true,
    get: function() {
        return useSliderState_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
const _useSliderStylesstyles = require("./useSliderStyles.styles");
const { sliderStepsPercentVar, sliderProgressVar, sliderDirectionVar } = _useSliderStylesstyles.sliderCSSVars;
const getPercent = (value, min, max)=>{
    return max === min ? 0 : (value - min) / (max - min) * 100;
};
const useSliderState_unstable = (state, props)=>{
    'use no memo';
    const { min = 0, max = 100, step } = props;
    const { dir } = (0, _reactsharedcontexts.useFluent_unstable)();
    const [currentValue, setCurrentValue] = (0, _reactutilities.useControllableState)({
        state: props.value,
        defaultState: props.defaultValue,
        initialState: 0
    });
    const clampedValue = (0, _reactutilities.clamp)(currentValue, min, max);
    const valuePercent = getPercent(clampedValue, min, max);
    const inputOnChange = state.input.onChange;
    const propsOnChange = props.onChange;
    const onChange = (0, _reactutilities.useEventCallback)((ev)=>{
        const newValue = Number(ev.target.value);
        setCurrentValue((0, _reactutilities.clamp)(newValue, min, max));
        if (inputOnChange && inputOnChange !== propsOnChange) {
            inputOnChange(ev);
        } else if (propsOnChange) {
            propsOnChange(ev, {
                value: newValue
            });
        }
    });
    const stepPercent = step && step > 0 ? `${step * 100 / (max - min)}%` : undefined;
    const rootVariables = {
        [sliderDirectionVar]: state.vertical ? '0deg' : dir === 'ltr' ? '90deg' : '270deg',
        [sliderProgressVar]: `${valuePercent}%`,
        // Set the sliderStepsPercentVar only if defined - fixes SSR errors in React 18
        ...stepPercent !== undefined && {
            [sliderStepsPercentVar]: stepPercent
        }
    };
    // Root props
    state.root.style = {
        ...rootVariables,
        ...state.root.style
    };
    // Input Props
    state.input.value = clampedValue;
    state.input.onChange = onChange;
    return state;
};
