'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useSlider_unstable", {
    enumerable: true,
    get: function() {
        return useSlider_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactfield = require("@fluentui/react-field");
const _reactutilities = require("@fluentui/react-utilities");
const _useSliderState = require("./useSliderState");
const _reacttabster = require("@fluentui/react-tabster");
const useSlider_unstable = (props, ref)=>{
    // Merge props from surrounding <Field>, if any
    props = (0, _reactfield.useFieldControlProps_unstable)(props, {
        supportsLabelFor: true
    });
    const nativeProps = (0, _reactutilities.getPartitionedNativeProps)({
        props,
        primarySlotTagName: 'input',
        excludedPropNames: [
            'onChange',
            'size'
        ]
    });
    const { disabled, vertical, size = 'medium', root, input, rail, thumb } = props;
    const state = {
        disabled,
        size,
        vertical,
        components: {
            input: 'input',
            rail: 'div',
            root: 'div',
            thumb: 'div'
        },
        root: _reactutilities.slot.always(root, {
            defaultProps: nativeProps.root,
            elementType: 'div'
        }),
        input: _reactutilities.slot.always(input, {
            defaultProps: {
                id: (0, _reactutilities.useId)('slider-', props.id),
                ref,
                ...nativeProps.primary,
                type: 'range',
                orient: vertical ? 'vertical' : undefined
            },
            elementType: 'input'
        }),
        rail: _reactutilities.slot.always(rail, {
            elementType: 'div'
        }),
        thumb: _reactutilities.slot.always(thumb, {
            elementType: 'div'
        })
    };
    state.root.ref = (0, _reactutilities.useMergedRefs)(state.root.ref, (0, _reacttabster.useFocusWithin)());
    (0, _useSliderState.useSliderState_unstable)(state, props);
    return state;
};
