'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    skeletonItemClassNames: function() {
        return skeletonItemClassNames;
    },
    useSkeletonItemStyles_unstable: function() {
        return useSkeletonItemStyles_unstable;
    }
});
const _react = require("@griffel/react");
const skeletonItemClassNames = {
    root: 'fui-SkeletonItem'
};
const skeletonWaveAnimation = {
    to: {
        transform: 'translate(100%)'
    }
};
const skeletonPulseAnimation = {
    '0%': {
        opacity: '1'
    },
    '50%': {
        opacity: '0.4'
    },
    '100%': {
        opacity: '1'
    }
};
/**
 * Styles for the root slot
 */ const useStyles = /*#__PURE__*/ (0, _react.__styles)({
    root: {
        qhf8xq: "f10pi13n",
        B68tc82: 0,
        Bmxbyg5: 0,
        Bpg54ce: "f1a3p1vp",
        Bsft5z2: "f13zj6fq",
        ap17g6: "f2gz7yw",
        E3zdtr: "f1mdlcz9",
        By385i5: 0,
        Eqx8gd: 0,
        B1piin3: 0,
        bn5sak: 0,
        B58onuk: "f1nt53hs",
        s9ouvv: "f18xs7ez",
        xr36ep: "ffm3629",
        Bitv4sc: "f1f9zsvm",
        Jx5sug: "f1ub80pn",
        Hzyzrh: "f1e7twep"
    },
    wave: {
        De3pzq: "f1gjxg63",
        Br128sd: [
            "f3fo419",
            "f6m9r4"
        ],
        h62rwi: [
            "ftnv2js",
            "f12jzhyt"
        ],
        b1kco5: [
            "fig1c6l",
            "f1rv5y9h"
        ],
        oi31me: "f103n15n"
    },
    pulse: {
        Br128sd: "f171zwvm",
        xr36ep: "fs3pcyf",
        Bjyk6c5: "f1yu5riq"
    },
    translucent: {
        De3pzq: "f162mh4z",
        h62rwi: [
            "flvf4r0",
            "f1uek97b"
        ]
    },
    translucentPulse: {
        De3pzq: "flu3bqm",
        Bjyk6c5: "fxucc0w"
    },
    blockStyling: {
        mc9l5x: "ftgm304"
    }
}, {
    d: [
        ".f10pi13n{position:relative;}",
        [
            ".f1a3p1vp{overflow:hidden;}",
            {
                p: -1
            }
        ],
        ".f13zj6fq::after{content:\"\";}",
        ".f2gz7yw::after{display:block;}",
        ".f1mdlcz9::after{position:absolute;}",
        [
            ".f1nt53hs::after{inset:0;}",
            {
                p: -1
            }
        ],
        ".f18xs7ez::after{animation-iteration-count:infinite;}",
        ".ffm3629::after{animation-duration:3s;}",
        ".f1f9zsvm::after{animation-timing-function:ease-in-out;}",
        ".f1gjxg63{background-color:var(--colorNeutralStencil1);}",
        ".f3fo419::after{animation-name:f1efwx7q;}",
        ".f6m9r4::after{animation-name:f1kkgpz1;}",
        ".ftnv2js::after{background-image:linear-gradient(\n        to right,\n        var(--colorNeutralStencil1) 0%,\n        var(--colorNeutralStencil2) 50%,\n        var(--colorNeutralStencil1) 100%);}",
        ".f12jzhyt::after{background-image:linear-gradient(\n        to left,\n        var(--colorNeutralStencil1) 0%,\n        var(--colorNeutralStencil2) 50%,\n        var(--colorNeutralStencil1) 100%);}",
        ".fig1c6l::after{transform:translate(-100%);}",
        ".f1rv5y9h::after{transform:translate(100%);}",
        ".f171zwvm::after{animation-name:f12o7gg6;}",
        ".fs3pcyf::after{animation-duration:1s;}",
        ".f1yu5riq::after{background-color:var(--colorNeutralStencil1);}",
        ".f162mh4z{background-color:var(--colorNeutralStencil1Alpha);}",
        ".flvf4r0::after{background-image:linear-gradient(\n      to right,\n      transparent 0%,\n      var(--colorNeutralStencil1Alpha) 50%,\n      transparent 100%);}",
        ".f1uek97b::after{background-image:linear-gradient(\n      to left,\n      transparent 0%,\n      var(--colorNeutralStencil1Alpha) 50%,\n      transparent 100%);}",
        ".flu3bqm{background-color:none;}",
        ".fxucc0w::after{background-color:var(--colorNeutralStencil1Alpha);}",
        ".ftgm304{display:block;}"
    ],
    m: [
        [
            "@media screen and (prefers-reduced-motion: reduce){.f1ub80pn::after{animation-duration:0.01ms;}}",
            {
                m: "screen and (prefers-reduced-motion: reduce)"
            }
        ],
        [
            "@media screen and (prefers-reduced-motion: reduce){.f1e7twep::after{animation-iteration-count:1;}}",
            {
                m: "screen and (prefers-reduced-motion: reduce)"
            }
        ],
        [
            "@media screen and (forced-colors: active){.f103n15n::after{background-color:WindowText;}}",
            {
                m: "screen and (forced-colors: active)"
            }
        ]
    ],
    k: [
        "@keyframes f1efwx7q{to{transform:translate(100%);}}",
        "@keyframes f1kkgpz1{to{transform:translate(-100%);}}",
        "@keyframes f12o7gg6{0%{opacity:1;}50%{opacity:0.4;}100%{opacity:1;}}"
    ]
});
const useRectangleStyles = /*#__PURE__*/ (0, _react.__styles)({
    "8": {
        Bqenvij: "f1x82gua"
    },
    "12": {
        Bqenvij: "fvblgha"
    },
    "16": {
        Bqenvij: "fd461yt"
    },
    "20": {
        Bqenvij: "fjamq6b"
    },
    "24": {
        Bqenvij: "frvgh55"
    },
    "28": {
        Bqenvij: "fxldao9"
    },
    "32": {
        Bqenvij: "f1d2rq10"
    },
    "36": {
        Bqenvij: "f8ljn23"
    },
    "40": {
        Bqenvij: "fbhnoac"
    },
    "48": {
        Bqenvij: "ff2sm71"
    },
    "56": {
        Bqenvij: "fzki0ko"
    },
    "64": {
        Bqenvij: "f16k9i2m"
    },
    "72": {
        Bqenvij: "f1shusfg"
    },
    "96": {
        Bqenvij: "fypu0ge"
    },
    "120": {
        Bqenvij: "fjr5b71"
    },
    "128": {
        Bqenvij: "fele2au"
    },
    root: {
        a9b677: "fly5x3f",
        Beyfa6y: 0,
        Bbmb7ep: 0,
        Btl43ni: 0,
        B7oj6ja: 0,
        Dimara: "ff3glw6"
    }
}, {
    d: [
        ".f1x82gua{height:8px;}",
        ".fvblgha{height:12px;}",
        ".fd461yt{height:16px;}",
        ".fjamq6b{height:20px;}",
        ".frvgh55{height:24px;}",
        ".fxldao9{height:28px;}",
        ".f1d2rq10{height:32px;}",
        ".f8ljn23{height:36px;}",
        ".fbhnoac{height:40px;}",
        ".ff2sm71{height:48px;}",
        ".fzki0ko{height:56px;}",
        ".f16k9i2m{height:64px;}",
        ".f1shusfg{height:72px;}",
        ".fypu0ge{height:96px;}",
        ".fjr5b71{height:120px;}",
        ".fele2au{height:128px;}",
        ".fly5x3f{width:100%;}",
        [
            ".ff3glw6{border-radius:4px;}",
            {
                p: -1
            }
        ]
    ]
});
const useSizeStyles = /*#__PURE__*/ (0, _react.__styles)({
    "8": {
        a9b677: "f1o3cbw4",
        Bqenvij: "f1x82gua"
    },
    "12": {
        a9b677: "frx94fk",
        Bqenvij: "fvblgha"
    },
    "16": {
        a9b677: "fjw5fx7",
        Bqenvij: "fd461yt"
    },
    "20": {
        a9b677: "f64fuq3",
        Bqenvij: "fjamq6b"
    },
    "24": {
        a9b677: "fq4mcun",
        Bqenvij: "frvgh55"
    },
    "28": {
        a9b677: "f1w9dchk",
        Bqenvij: "fxldao9"
    },
    "32": {
        a9b677: "f1szoe96",
        Bqenvij: "f1d2rq10"
    },
    "36": {
        a9b677: "fpdz1er",
        Bqenvij: "f8ljn23"
    },
    "40": {
        a9b677: "feqmc2u",
        Bqenvij: "fbhnoac"
    },
    "48": {
        a9b677: "f124akge",
        Bqenvij: "ff2sm71"
    },
    "56": {
        a9b677: "f1u66zr1",
        Bqenvij: "fzki0ko"
    },
    "64": {
        a9b677: "fa9ln6p",
        Bqenvij: "f16k9i2m"
    },
    "72": {
        a9b677: "fhcae8x",
        Bqenvij: "f1shusfg"
    },
    "96": {
        a9b677: "f1kyr2gn",
        Bqenvij: "fypu0ge"
    },
    "120": {
        a9b677: "fwfqyga",
        Bqenvij: "fjr5b71"
    },
    "128": {
        a9b677: "f1iksgmy",
        Bqenvij: "fele2au"
    }
}, {
    d: [
        ".f1o3cbw4{width:8px;}",
        ".f1x82gua{height:8px;}",
        ".frx94fk{width:12px;}",
        ".fvblgha{height:12px;}",
        ".fjw5fx7{width:16px;}",
        ".fd461yt{height:16px;}",
        ".f64fuq3{width:20px;}",
        ".fjamq6b{height:20px;}",
        ".fq4mcun{width:24px;}",
        ".frvgh55{height:24px;}",
        ".f1w9dchk{width:28px;}",
        ".fxldao9{height:28px;}",
        ".f1szoe96{width:32px;}",
        ".f1d2rq10{height:32px;}",
        ".fpdz1er{width:36px;}",
        ".f8ljn23{height:36px;}",
        ".feqmc2u{width:40px;}",
        ".fbhnoac{height:40px;}",
        ".f124akge{width:48px;}",
        ".ff2sm71{height:48px;}",
        ".f1u66zr1{width:56px;}",
        ".fzki0ko{height:56px;}",
        ".fa9ln6p{width:64px;}",
        ".f16k9i2m{height:64px;}",
        ".fhcae8x{width:72px;}",
        ".f1shusfg{height:72px;}",
        ".f1kyr2gn{width:96px;}",
        ".fypu0ge{height:96px;}",
        ".fwfqyga{width:120px;}",
        ".fjr5b71{height:120px;}",
        ".f1iksgmy{width:128px;}",
        ".fele2au{height:128px;}"
    ]
});
const useCircleSizeStyles = /*#__PURE__*/ (0, _react.__styles)({
    root: {
        Beyfa6y: 0,
        Bbmb7ep: 0,
        Btl43ni: 0,
        B7oj6ja: 0,
        Dimara: "f5q2cvs"
    }
}, {
    d: [
        [
            ".f5q2cvs{border-radius:50%;}",
            {
                p: -1
            }
        ]
    ]
});
const useSkeletonItemStyles_unstable = (state)=>{
    'use no memo';
    const { animation, appearance, size, shape } = state;
    const rootStyles = useStyles();
    const rectStyles = useRectangleStyles();
    const sizeStyles = useSizeStyles();
    const circleStyles = useCircleSizeStyles();
    state.root.className = (0, _react.mergeClasses)(skeletonItemClassNames.root, rootStyles.root, state.root.as === 'span' && rootStyles.blockStyling, animation === 'wave' && rootStyles.wave, animation === 'pulse' && rootStyles.pulse, appearance === 'translucent' && rootStyles.translucent, animation === 'pulse' && appearance === 'translucent' && rootStyles.translucentPulse, shape === 'rectangle' && rectStyles.root, shape === 'rectangle' && rectStyles[size], shape === 'square' && sizeStyles[size], shape === 'circle' && circleStyles.root, shape === 'circle' && sizeStyles[size], state.root.className);
    return state;
};
