import type { ComponentProps } from '@fluentui/react-utilities';
import type { ComponentState } from '@fluentui/react-utilities';
import type { ForwardRefComponent } from '@fluentui/react-utilities';
import type { JSXElement } from '@fluentui/react-utilities';
import * as React_2 from 'react';
import type { Slot } from '@fluentui/react-utilities';
import type { SlotClassNames } from '@fluentui/react-utilities';

/**
 * Render the final JSX of Skeleton
 */
export declare const renderSkeleton_unstable: (state: SkeletonState, contextValues: SkeletonContextValues) => JSXElement;

/**
 * Render the final JSX of SkeletonItem
 */
export declare const renderSkeletonItem_unstable: (state: SkeletonItemState) => JSXElement;

/**
 * Skeleton component - TODO: add more docs
 */
export declare const Skeleton: ForwardRefComponent<SkeletonProps>;

export declare const skeletonClassNames: SlotClassNames<SkeletonSlots>;

export declare const SkeletonContextProvider: React_2.Provider<SkeletonContextValue | undefined>;

export declare interface SkeletonContextValue {
    animation?: 'wave' | 'pulse';
    appearance?: 'opaque' | 'translucent';
}

declare type SkeletonContextValues = {
    skeletonGroup: SkeletonContextValue;
};

export declare const SkeletonItem: ForwardRefComponent<SkeletonItemProps>;

export declare const skeletonItemClassNames: SlotClassNames<SkeletonItemSlots>;

/**
 * SkeletonItem Props
 */
export declare type SkeletonItemProps = ComponentProps<SkeletonItemSlots> & {
    /**
     * Sets the animation of the SkeletonItem
     * @default wave
     */
    animation?: 'wave' | 'pulse';
    /**
     * Sets the appearance of the SkeletonItem
     * @default opaque
     */
    appearance?: 'opaque' | 'translucent';
    /**
     * Sets the size of the SkeletonItem in pixels.
     * Size is restricted to a limited set of values recommended for most uses(see SkeletonItemSize).
     * To set a non-supported size, set `width` and `height` to override the rendered size.
     * @default 16
     */
    size?: SkeletonItemSize;
    /**
     * Sets the shape of the SkeletonItem.
     * @default rectangle
     */
    shape?: 'circle' | 'square' | 'rectangle';
};

/**
 * Sizes for the SkeletonItem
 */
declare type SkeletonItemSize = 8 | 12 | 16 | 20 | 24 | 28 | 32 | 36 | 40 | 48 | 56 | 64 | 72 | 96 | 120 | 128;

export declare type SkeletonItemSlots = {
    root: Slot<'div', 'span'>;
};

/**
 * State used in rendering SkeletonItem
 */
export declare type SkeletonItemState = ComponentState<SkeletonItemSlots> & Required<Pick<SkeletonItemProps, 'animation' | 'appearance' | 'size' | 'shape'>>;

/**
 * Skeleton Props
 */
export declare type SkeletonProps = Omit<ComponentProps<Partial<SkeletonSlots>>, 'width'> & {
    /**
     * The animation type for the Skeleton
     * @defaultValue wave
     */
    animation?: 'wave' | 'pulse';
    /**
     * Sets the appearance of the Skeleton.
     * @defaultValue opaque
     */
    appearance?: 'opaque' | 'translucent';
    /**
     * Sets the width value of the skeleton wrapper.
     * @defaultValue 100%
     * @deprecated Use `className` prop to set width
     */
    width?: number | string;
};

export declare type SkeletonSlots = {
    /**
     * The root slot of the `Skeleton` is the container that will contain the slots that make up a `Skeleton`
     * and any data that the `Skeleton` will load. The default html element is a `div`.
     */
    root: NonNullable<Slot<'div', 'span'>>;
};

/**
 * State used in rendering Skeleton
 */
export declare type SkeletonState = ComponentState<SkeletonSlots> & Required<Pick<SkeletonProps, 'animation' | 'appearance'>>;

/**
 * Create the state required to render Skeleton.
 *
 * The returned state can be modified with hooks such as useSkeletonStyles_unstable,
 * before being passed to renderSkeleton_unstable.
 *
 * @param props - props from this instance of Skeleton
 * @param ref - reference to root HTMLElement of Skeleton
 */
export declare const useSkeleton_unstable: (props: SkeletonProps, ref: React_2.Ref<HTMLElement>) => SkeletonState;

export declare const useSkeletonContext: () => SkeletonContextValue;

/**
 * Create the state required to render SkeletonItem.
 *
 * The returned state can be modified with hooks such as useSkeletonItemStyles_unstable,
 * before being passed to renderSkeletonItem_unstable.
 *
 * @param props - props from this instance of SkeletonItem
 * @param ref - reference to root HTMLElement of SkeletonItem
 */
export declare const useSkeletonItem_unstable: (props: SkeletonItemProps, ref: React_2.Ref<HTMLElement>) => SkeletonItemState;

/**
 * Apply styling to the SkeletonItem slots based on the state
 */
export declare const useSkeletonItemStyles_unstable: (state: SkeletonItemState) => SkeletonItemState;

/**
 * Apply styling to the Skeleton slots based on the state
 */
export declare const useSkeletonStyles_unstable: (state: SkeletonState) => SkeletonState;

export { }
