'use client';

import { __styles, mergeClasses, shorthands } from '@griffel/react';
import { tokens, typographyStyles } from '@fluentui/react-theme';
export const selectClassNames = {
  root: 'fui-Select',
  select: 'fui-Select__select',
  icon: 'fui-Select__icon'
};
const iconSizes = {
  small: '16px',
  medium: '20px',
  large: '24px'
};
//TODO: Should fieldHeights be a set of global design tokens or constants?
const fieldHeights = {
  small: '24px',
  medium: '32px',
  large: '40px'
};
/* Since the <select> element must span the full width and cannot have children,
 * the right padding needs to be calculated from the sum of the following:
 * 1. Field padding-right
 * 2. Icon width
 * 3. Content-icon spacing
 * 4. Content inner padding
 */
const paddingRight = {
  small: `calc(${tokens.spacingHorizontalSNudge}
    + ${iconSizes.small}
    + ${tokens.spacingHorizontalXXS}
    + ${tokens.spacingHorizontalXXS})`,
  medium: `calc(${tokens.spacingHorizontalMNudge}
    + ${iconSizes.medium}
    + ${tokens.spacingHorizontalXXS}
    + ${tokens.spacingHorizontalXXS})`,
  large: `calc(${tokens.spacingHorizontalM}
    + ${iconSizes.large}
    + ${tokens.spacingHorizontalSNudge}
    + ${tokens.spacingHorizontalSNudge})`
};
/* Left padding is calculated from the outer padding + inner content padding values
 * since <select> can't have additional child content or custom inner layout */
const paddingLeft = {
  small: `calc(${tokens.spacingHorizontalSNudge} + ${tokens.spacingHorizontalXXS})`,
  medium: `calc(${tokens.spacingHorizontalMNudge} + ${tokens.spacingHorizontalXXS})`,
  large: `calc(${tokens.spacingHorizontalM} + ${tokens.spacingHorizontalSNudge})`
};
/* end of shared values */
const useRootStyles = /*#__PURE__*/__styles({
  base: {
    Bt984gj: "f122n59",
    B7ck84d: "f1ewtqcl",
    mc9l5x: "f22iagw",
    Eh141a: "flvyvdh",
    Bahqtrf: "fk6fouc",
    qhf8xq: "f10pi13n",
    h62rwi: "f7ll8cq",
    d9w3h3: 0,
    B3778ie: 0,
    B4j8arr: 0,
    Bl18szs: 0,
    Blrzh8d: "fe5s0lv",
    li1rpt: "f1gw3sf2",
    Bsft5z2: "f13zj6fq",
    Dlnsje: "fhwjr99",
    E3zdtr: "f1mdlcz9",
    By385i5: "fo72kxq",
    Eqx8gd: ["f1n6gb5g", "f15yvnhg"],
    B1piin3: ["f15yvnhg", "f1n6gb5g"],
    b1kco5: "f1yk9hq",
    Ba2ppi3: "fhwpy7i",
    F2fol1: "f14ee0xe",
    lck23g: "f1xhbsuh",
    df92cz: "fv8e3ye",
    I188md: "ftb5wc6",
    umuwi5: "fjw5xc1",
    Blcqepd: "f1xdyd5c",
    nplu4u: "fatpbeo",
    Bioka5o: "fb7uyps",
    H713fs: "f1cmft4k",
    B9ooomg: "f1x58t8o"
  }
}, {
  d: [".f122n59{align-items:center;}", ".f1ewtqcl{box-sizing:border-box;}", ".f22iagw{display:flex;}", ".flvyvdh{flex-wrap:nowrap;}", ".fk6fouc{font-family:var(--fontFamilyBase);}", ".f10pi13n{position:relative;}", ".f7ll8cq::after{background-image:linear-gradient(\n        0deg,\n        var(--colorCompoundBrandStroke) 0%,\n        var(--colorCompoundBrandStroke) 50%,\n        transparent 50%,\n        transparent 100%\n      );}", [".fe5s0lv::after{border-radius:0 0 var(--borderRadiusMedium) var(--borderRadiusMedium);}", {
    p: -1
  }], ".f1gw3sf2::after{box-sizing:border-box;}", ".f13zj6fq::after{content:\"\";}", ".fhwjr99::after{height:var(--borderRadiusMedium);}", ".f1mdlcz9::after{position:absolute;}", ".fo72kxq::after{bottom:0;}", ".f1n6gb5g::after{left:0;}", ".f15yvnhg::after{right:0;}", ".f1yk9hq::after{transform:scaleX(0);}", ".fhwpy7i::after{transition-property:transform;}", ".f14ee0xe::after{transition-duration:var(--durationUltraFast);}", ".f1xhbsuh::after{transition-delay:var(--curveAccelerateMid);}"],
  m: [["@media screen and (prefers-reduced-motion: reduce){.fv8e3ye::after{transition-duration:0.01ms;}}", {
    m: "screen and (prefers-reduced-motion: reduce)"
  }], ["@media screen and (prefers-reduced-motion: reduce){.ftb5wc6::after{transition-delay:0.01ms;}}", {
    m: "screen and (prefers-reduced-motion: reduce)"
  }], ["@media screen and (prefers-reduced-motion: reduce){.f1cmft4k:focus-within::after{transition-duration:0.01ms;}}", {
    m: "screen and (prefers-reduced-motion: reduce)"
  }], ["@media screen and (prefers-reduced-motion: reduce){.f1x58t8o:focus-within::after{transition-delay:0.01ms;}}", {
    m: "screen and (prefers-reduced-motion: reduce)"
  }]],
  w: [".fjw5xc1:focus-within::after{transform:scaleX(1);}", ".f1xdyd5c:focus-within::after{transition-property:transform;}", ".fatpbeo:focus-within::after{transition-duration:var(--durationNormal);}", ".fb7uyps:focus-within::after{transition-delay:var(--curveDecelerateMid);}"]
});
const useSelectStyles = /*#__PURE__*/__styles({
  base: {
    Bowrso0: "fqrijq1",
    Bgfg5da: 0,
    B9xav0g: 0,
    oivjwe: 0,
    Bn0qgzm: 0,
    B4g9neb: 0,
    zhjwy3: 0,
    wvpqe5: 0,
    ibv6hh: 0,
    u1mtju: 0,
    h3c5rm: 0,
    vrafjx: 0,
    Bekrc4i: 0,
    i8vvqc: 0,
    g2u3we: 0,
    icvyot: 0,
    B4j52fo: 0,
    irswps: "faev5xe",
    Beyfa6y: 0,
    Bbmb7ep: 0,
    Btl43ni: 0,
    B7oj6ja: 0,
    Dimara: "ft85np5",
    E5pizo: "f1couhl3",
    B7ck84d: "f1ewtqcl",
    sj55zd: "f19n0e5",
    Bceei9c: "f1k6fduh",
    Bh6795r: "fqerorx",
    B2u0y6b: "f6dzj5z",
    Byoj8tv: "f1qch9an",
    z8tnut: "f1g0x7ka",
    B3aqqti: "fatbyko",
    Brovlpu: "f1grzc83",
    Bxa1mx5: "f19shzzi"
  },
  disabled: {
    De3pzq: "f1c21dwh",
    g2u3we: "f1jj8ep1",
    h3c5rm: ["f15xbau", "fy0fskl"],
    B9xav0g: "f4ikngz",
    zhjwy3: ["fy0fskl", "f15xbau"],
    sj55zd: "f1s2aq7o",
    Bceei9c: "fdrzuqr",
    Bjwas2f: "fg455y9",
    Bn1d65q: ["f1rvyvqg", "f14g86mu"],
    Bxeuatn: "f1cwzwz",
    n51gp8: ["f14g86mu", "f1rvyvqg"]
  },
  disabledUnderline: {
    g2u3we: "fgig46g",
    h3c5rm: ["f1mxt3zg", "fziff3p"],
    B9xav0g: "f4ikngz",
    zhjwy3: ["fziff3p", "f1mxt3zg"]
  },
  small: {
    Bqenvij: "frvgh55",
    uwmqm3: ["f1xile11", "fqznh8f"],
    z189sj: ["fiqd4sw", "f11fkzut"],
    Bahqtrf: "fk6fouc",
    Be2twd7: "fy9rknc",
    Bhrd7zp: "figsok6",
    Bg96gwp: "fwrc4pm"
  },
  medium: {
    Bqenvij: "f1d2rq10",
    uwmqm3: ["f1e60jzv", "f135dnwl"],
    z189sj: ["f154vowv", "flqamny"],
    Bahqtrf: "fk6fouc",
    Be2twd7: "fkhj508",
    Bhrd7zp: "figsok6",
    Bg96gwp: "f1i3iumi"
  },
  large: {
    Bqenvij: "fbhnoac",
    uwmqm3: ["fnphzt9", "flt1dlf"],
    z189sj: ["f1xi5ia2", "f1xi1l47"],
    Bahqtrf: "fk6fouc",
    Be2twd7: "fod5ikn",
    Bhrd7zp: "figsok6",
    Bg96gwp: "faaz57k"
  },
  outline: {
    De3pzq: "fxugw4r",
    Bgfg5da: 0,
    B9xav0g: "f1c1zstj",
    oivjwe: 0,
    Bn0qgzm: 0,
    B4g9neb: 0,
    zhjwy3: 0,
    wvpqe5: 0,
    ibv6hh: 0,
    u1mtju: 0,
    h3c5rm: 0,
    vrafjx: 0,
    Bekrc4i: 0,
    i8vvqc: 0,
    g2u3we: 0,
    icvyot: 0,
    B4j52fo: 0,
    irswps: "fm9niy"
  },
  outlineInteractive: {
    Bgoe8wy: "fvcxoqz",
    Bwzppfd: ["f1ub3y4t", "f1m52nbi"],
    oetu4i: "flmw63s",
    gg5e9n: ["f1m52nbi", "f1ub3y4t"],
    B6oc9vd: "fvs00aa",
    ak43y8: ["f1assf6x", "f4ruux4"],
    wmxk5l: "fqhmt4z",
    B50zh58: ["f4ruux4", "f1assf6x"]
  },
  underline: {
    De3pzq: "f1c21dwh",
    B9xav0g: 0,
    oivjwe: 0,
    Bn0qgzm: 0,
    Bgfg5da: "fd91s9p",
    Beyfa6y: 0,
    Bbmb7ep: 0,
    Btl43ni: 0,
    B7oj6ja: 0,
    Dimara: "fokr779",
    C8i20h: "fb77jct"
  },
  "filled-lighter": {
    De3pzq: "fxugw4r"
  },
  "filled-darker": {
    De3pzq: "f16xq7d1"
  },
  invalid: {
    tvckwq: "fs4k3qj",
    gk2u95: ["fcee079", "fmyw78r"],
    hhx65j: "f1fgmyf4",
    Bxowmz0: ["fmyw78r", "fcee079"]
  },
  invalidUnderline: {
    hhx65j: "f1fgmyf4"
  }
}, {
  d: [".fqrijq1{-webkit-appearance:none;-moz-appearance:none;appearance:none;}", [".faev5xe{border:1px solid transparent;}", {
    p: -2
  }], [".ft85np5{border-radius:var(--borderRadiusMedium);}", {
    p: -1
  }], ".f1couhl3{box-shadow:none;}", ".f1ewtqcl{box-sizing:border-box;}", ".f19n0e5{color:var(--colorNeutralForeground1);}", ".f1k6fduh{cursor:pointer;}", ".fqerorx{flex-grow:1;}", ".f6dzj5z{max-width:100%;}", ".f1qch9an{padding-bottom:0;}", ".f1g0x7ka{padding-top:0;}", ".f1c21dwh{background-color:var(--colorTransparentBackground);}", ".f1jj8ep1{border-top-color:var(--colorNeutralStrokeDisabled);}", ".f15xbau{border-right-color:var(--colorNeutralStrokeDisabled);}", ".fy0fskl{border-left-color:var(--colorNeutralStrokeDisabled);}", ".f4ikngz{border-bottom-color:var(--colorNeutralStrokeDisabled);}", ".f1s2aq7o{color:var(--colorNeutralForegroundDisabled);}", ".fdrzuqr{cursor:not-allowed;}", ".fgig46g{border-top-color:var(--colorTransparentStrokeDisabled);}", ".f1mxt3zg{border-right-color:var(--colorTransparentStrokeDisabled);}", ".fziff3p{border-left-color:var(--colorTransparentStrokeDisabled);}", ".frvgh55{height:24px;}", ".f1xile11{padding-left:calc(var(--spacingHorizontalSNudge) + var(--spacingHorizontalXXS));}", ".fqznh8f{padding-right:calc(var(--spacingHorizontalSNudge) + var(--spacingHorizontalXXS));}", ".fiqd4sw{padding-right:calc(var(--spacingHorizontalSNudge)\n    + 16px\n    + var(--spacingHorizontalXXS)\n    + var(--spacingHorizontalXXS));}", ".f11fkzut{padding-left:calc(var(--spacingHorizontalSNudge)\n    + 16px\n    + var(--spacingHorizontalXXS)\n    + var(--spacingHorizontalXXS));}", ".fk6fouc{font-family:var(--fontFamilyBase);}", ".fy9rknc{font-size:var(--fontSizeBase200);}", ".figsok6{font-weight:var(--fontWeightRegular);}", ".fwrc4pm{line-height:var(--lineHeightBase200);}", ".f1d2rq10{height:32px;}", ".f1e60jzv{padding-left:calc(var(--spacingHorizontalMNudge) + var(--spacingHorizontalXXS));}", ".f135dnwl{padding-right:calc(var(--spacingHorizontalMNudge) + var(--spacingHorizontalXXS));}", ".f154vowv{padding-right:calc(var(--spacingHorizontalMNudge)\n    + 20px\n    + var(--spacingHorizontalXXS)\n    + var(--spacingHorizontalXXS));}", ".flqamny{padding-left:calc(var(--spacingHorizontalMNudge)\n    + 20px\n    + var(--spacingHorizontalXXS)\n    + var(--spacingHorizontalXXS));}", ".fkhj508{font-size:var(--fontSizeBase300);}", ".f1i3iumi{line-height:var(--lineHeightBase300);}", ".fbhnoac{height:40px;}", ".fnphzt9{padding-left:calc(var(--spacingHorizontalM) + var(--spacingHorizontalSNudge));}", ".flt1dlf{padding-right:calc(var(--spacingHorizontalM) + var(--spacingHorizontalSNudge));}", ".f1xi5ia2{padding-right:calc(var(--spacingHorizontalM)\n    + 24px\n    + var(--spacingHorizontalSNudge)\n    + var(--spacingHorizontalSNudge));}", ".f1xi1l47{padding-left:calc(var(--spacingHorizontalM)\n    + 24px\n    + var(--spacingHorizontalSNudge)\n    + var(--spacingHorizontalSNudge));}", ".fod5ikn{font-size:var(--fontSizeBase400);}", ".faaz57k{line-height:var(--lineHeightBase400);}", ".fxugw4r{background-color:var(--colorNeutralBackground1);}", [".fm9niy{border:1px solid var(--colorNeutralStroke1);}", {
    p: -2
  }], ".f1c1zstj{border-bottom-color:var(--colorNeutralStrokeAccessible);}", [".fd91s9p{border-bottom:1px solid var(--colorNeutralStrokeAccessible);}", {
    p: -1
  }], [".fokr779{border-radius:0;}", {
    p: -1
  }], ".fb77jct option{background-color:var(--colorNeutralBackground1);}", ".f16xq7d1{background-color:var(--colorNeutralBackground3);}", ".fs4k3qj:not(:focus-within),.fs4k3qj:hover:not(:focus-within){border-top-color:var(--colorPaletteRedBorder2);}", ".fcee079:not(:focus-within),.fcee079:hover:not(:focus-within){border-right-color:var(--colorPaletteRedBorder2);}", ".fmyw78r:not(:focus-within),.fmyw78r:hover:not(:focus-within){border-left-color:var(--colorPaletteRedBorder2);}", ".f1fgmyf4:not(:focus-within),.f1fgmyf4:hover:not(:focus-within){border-bottom-color:var(--colorPaletteRedBorder2);}"],
  f: [".fatbyko:focus{outline-width:2px;}", ".f1grzc83:focus{outline-style:solid;}", ".f19shzzi:focus{outline-color:transparent;}"],
  m: [["@media (forced-colors: active){.fg455y9{border-top-color:GrayText;}}", {
    m: "(forced-colors: active)"
  }], ["@media (forced-colors: active){.f14g86mu{border-left-color:GrayText;}.f1rvyvqg{border-right-color:GrayText;}}", {
    m: "(forced-colors: active)"
  }], ["@media (forced-colors: active){.f1cwzwz{border-bottom-color:GrayText;}}", {
    m: "(forced-colors: active)"
  }]],
  h: [".fvcxoqz:hover{border-top-color:var(--colorNeutralStroke1Hover);}", ".f1ub3y4t:hover{border-right-color:var(--colorNeutralStroke1Hover);}", ".f1m52nbi:hover{border-left-color:var(--colorNeutralStroke1Hover);}", ".flmw63s:hover{border-bottom-color:var(--colorNeutralStrokeAccessible);}"],
  a: [".fvs00aa:active{border-top-color:var(--colorNeutralStroke1Pressed);}", ".f1assf6x:active{border-right-color:var(--colorNeutralStroke1Pressed);}", ".f4ruux4:active{border-left-color:var(--colorNeutralStroke1Pressed);}", ".fqhmt4z:active{border-bottom-color:var(--colorNeutralStrokeAccessible);}"]
});
const useIconStyles = /*#__PURE__*/__styles({
  icon: {
    B7ck84d: "f1ewtqcl",
    sj55zd: "fxkbij4",
    mc9l5x: "ftgm304",
    qhf8xq: "f1euv43f",
    Bkecrkj: "f1aehjj5",
    Bo70h7d: "fvc9v3g"
  },
  disabled: {
    sj55zd: "f1s2aq7o",
    Bbusuzp: "f1dcs8yz"
  },
  small: {
    Be2twd7: "f4ybsrx",
    Bqenvij: "fd461yt",
    j35jbq: ["f13lnp83", "f1i5nn0v"],
    a9b677: "fjw5fx7"
  },
  medium: {
    Be2twd7: "fe5j1ua",
    Bqenvij: "fjamq6b",
    j35jbq: ["fnyteob", "f1enpzzf"],
    a9b677: "f64fuq3"
  },
  large: {
    Be2twd7: "f1rt2boy",
    Bqenvij: "frvgh55",
    j35jbq: ["f8b87gs", "fedtrts"],
    a9b677: "fq4mcun"
  }
}, {
  d: [".f1ewtqcl{box-sizing:border-box;}", ".fxkbij4{color:var(--colorNeutralStrokeAccessible);}", ".ftgm304{display:block;}", ".f1euv43f{position:absolute;}", ".f1aehjj5{pointer-events:none;}", ".fvc9v3g svg{display:block;}", ".f1s2aq7o{color:var(--colorNeutralForegroundDisabled);}", ".f4ybsrx{font-size:16px;}", ".fd461yt{height:16px;}", ".f13lnp83{right:var(--spacingHorizontalSNudge);}", ".f1i5nn0v{left:var(--spacingHorizontalSNudge);}", ".fjw5fx7{width:16px;}", ".fe5j1ua{font-size:20px;}", ".fjamq6b{height:20px;}", ".fnyteob{right:var(--spacingHorizontalMNudge);}", ".f1enpzzf{left:var(--spacingHorizontalMNudge);}", ".f64fuq3{width:20px;}", ".f1rt2boy{font-size:24px;}", ".frvgh55{height:24px;}", ".f8b87gs{right:var(--spacingHorizontalM);}", ".fedtrts{left:var(--spacingHorizontalM);}", ".fq4mcun{width:24px;}"],
  m: [["@media (forced-colors: active){.f1dcs8yz{color:GrayText;}}", {
    m: "(forced-colors: active)"
  }]]
});
/**
 * Apply styling to the Select slots based on the state
 */
export const useSelectStyles_unstable = state => {
  'use no memo';

  const {
    size,
    appearance
  } = state;
  const disabled = state.select.disabled;
  const invalid = `${state.select['aria-invalid']}` === 'true';
  const iconStyles = useIconStyles();
  const rootStyles = useRootStyles();
  const selectStyles = useSelectStyles();
  state.root.className = mergeClasses(selectClassNames.root, rootStyles.base, state.root.className);
  state.select.className = mergeClasses(selectClassNames.select, selectStyles.base, selectStyles[size], selectStyles[appearance], !disabled && appearance === 'outline' && selectStyles.outlineInteractive, !disabled && invalid && appearance !== 'underline' && selectStyles.invalid, !disabled && invalid && appearance === 'underline' && selectStyles.invalidUnderline, disabled && selectStyles.disabled, disabled && appearance === 'underline' && selectStyles.disabledUnderline, state.select.className);
  if (state.icon) {
    state.icon.className = mergeClasses(selectClassNames.icon, iconStyles.icon, disabled && iconStyles.disabled, iconStyles[size], state.icon.className);
  }
  return state;
};