'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    selectClassNames: function() {
        return selectClassNames;
    },
    useSelectStyles_unstable: function() {
        return useSelectStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const selectClassNames = {
    root: 'fui-Select',
    select: 'fui-Select__select',
    icon: 'fui-Select__icon'
};
const iconSizes = {
    small: '16px',
    medium: '20px',
    large: '24px'
};
//TODO: Should fieldHeights be a set of global design tokens or constants?
const fieldHeights = {
    small: '24px',
    medium: '32px',
    large: '40px'
};
/* Since the <select> element must span the full width and cannot have children,
 * the right padding needs to be calculated from the sum of the following:
 * 1. Field padding-right
 * 2. Icon width
 * 3. Content-icon spacing
 * 4. Content inner padding
 */ const paddingRight = {
    small: `calc(${_reacttheme.tokens.spacingHorizontalSNudge}
    + ${iconSizes.small}
    + ${_reacttheme.tokens.spacingHorizontalXXS}
    + ${_reacttheme.tokens.spacingHorizontalXXS})`,
    medium: `calc(${_reacttheme.tokens.spacingHorizontalMNudge}
    + ${iconSizes.medium}
    + ${_reacttheme.tokens.spacingHorizontalXXS}
    + ${_reacttheme.tokens.spacingHorizontalXXS})`,
    large: `calc(${_reacttheme.tokens.spacingHorizontalM}
    + ${iconSizes.large}
    + ${_reacttheme.tokens.spacingHorizontalSNudge}
    + ${_reacttheme.tokens.spacingHorizontalSNudge})`
};
/* Left padding is calculated from the outer padding + inner content padding values
 * since <select> can't have additional child content or custom inner layout */ const paddingLeft = {
    small: `calc(${_reacttheme.tokens.spacingHorizontalSNudge} + ${_reacttheme.tokens.spacingHorizontalXXS})`,
    medium: `calc(${_reacttheme.tokens.spacingHorizontalMNudge} + ${_reacttheme.tokens.spacingHorizontalXXS})`,
    large: `calc(${_reacttheme.tokens.spacingHorizontalM} + ${_reacttheme.tokens.spacingHorizontalSNudge})`
};
/* end of shared values */ const useRootStyles = (0, _react.makeStyles)({
    base: {
        alignItems: 'center',
        boxSizing: 'border-box',
        display: 'flex',
        flexWrap: 'nowrap',
        fontFamily: _reacttheme.tokens.fontFamilyBase,
        position: 'relative',
        '&::after': {
            backgroundImage: `linear-gradient(
        0deg,
        ${_reacttheme.tokens.colorCompoundBrandStroke} 0%,
        ${_reacttheme.tokens.colorCompoundBrandStroke} 50%,
        transparent 50%,
        transparent 100%
      )`,
            borderRadius: `0 0 ${_reacttheme.tokens.borderRadiusMedium} ${_reacttheme.tokens.borderRadiusMedium}`,
            boxSizing: 'border-box',
            content: '""',
            height: _reacttheme.tokens.borderRadiusMedium,
            position: 'absolute',
            bottom: '0',
            left: '0',
            right: '0',
            transform: 'scaleX(0)',
            transitionProperty: 'transform',
            transitionDuration: _reacttheme.tokens.durationUltraFast,
            transitionDelay: _reacttheme.tokens.curveAccelerateMid,
            '@media screen and (prefers-reduced-motion: reduce)': {
                transitionDuration: '0.01ms',
                transitionDelay: '0.01ms'
            }
        },
        '&:focus-within::after': {
            transform: 'scaleX(1)',
            transitionProperty: 'transform',
            transitionDuration: _reacttheme.tokens.durationNormal,
            transitionDelay: _reacttheme.tokens.curveDecelerateMid,
            '@media screen and (prefers-reduced-motion: reduce)': {
                transitionDuration: '0.01ms',
                transitionDelay: '0.01ms'
            }
        }
    }
});
const useSelectStyles = (0, _react.makeStyles)({
    base: {
        appearance: 'none',
        border: '1px solid transparent',
        borderRadius: _reacttheme.tokens.borderRadiusMedium,
        boxShadow: 'none',
        boxSizing: 'border-box',
        color: _reacttheme.tokens.colorNeutralForeground1,
        cursor: 'pointer',
        flexGrow: 1,
        maxWidth: '100%',
        paddingBottom: 0,
        paddingTop: 0,
        ':focus': {
            outlineWidth: '2px',
            outlineStyle: 'solid',
            outlineColor: 'transparent'
        }
    },
    disabled: {
        backgroundColor: _reacttheme.tokens.colorTransparentBackground,
        ..._react.shorthands.borderColor(_reacttheme.tokens.colorNeutralStrokeDisabled),
        color: _reacttheme.tokens.colorNeutralForegroundDisabled,
        cursor: 'not-allowed',
        '@media (forced-colors: active)': {
            ..._react.shorthands.borderColor('GrayText')
        }
    },
    disabledUnderline: {
        ..._react.shorthands.borderColor(_reacttheme.tokens.colorTransparentStrokeDisabled, _reacttheme.tokens.colorTransparentStrokeDisabled, _reacttheme.tokens.colorNeutralStrokeDisabled)
    },
    small: {
        height: fieldHeights.small,
        paddingLeft: paddingLeft.small,
        paddingRight: paddingRight.small,
        ..._reacttheme.typographyStyles.caption1
    },
    medium: {
        height: fieldHeights.medium,
        paddingLeft: paddingLeft.medium,
        paddingRight: paddingRight.medium,
        ..._reacttheme.typographyStyles.body1
    },
    large: {
        height: fieldHeights.large,
        paddingLeft: paddingLeft.large,
        paddingRight: paddingRight.large,
        ..._reacttheme.typographyStyles.body2
    },
    outline: {
        backgroundColor: _reacttheme.tokens.colorNeutralBackground1,
        border: `1px solid ${_reacttheme.tokens.colorNeutralStroke1}`,
        borderBottomColor: _reacttheme.tokens.colorNeutralStrokeAccessible
    },
    outlineInteractive: {
        '&:hover': {
            ..._react.shorthands.borderColor(_reacttheme.tokens.colorNeutralStroke1Hover),
            borderBottomColor: _reacttheme.tokens.colorNeutralStrokeAccessible
        },
        '&:active': {
            ..._react.shorthands.borderColor(_reacttheme.tokens.colorNeutralStroke1Pressed),
            borderBottomColor: _reacttheme.tokens.colorNeutralStrokeAccessible
        }
    },
    underline: {
        backgroundColor: _reacttheme.tokens.colorTransparentBackground,
        borderBottom: `1px solid ${_reacttheme.tokens.colorNeutralStrokeAccessible}`,
        borderRadius: '0',
        '& option': {
            // The transparent select bg means the option background must be set so the text is visible in dark themes
            backgroundColor: _reacttheme.tokens.colorNeutralBackground1
        }
    },
    'filled-lighter': {
        backgroundColor: _reacttheme.tokens.colorNeutralBackground1
    },
    'filled-darker': {
        backgroundColor: _reacttheme.tokens.colorNeutralBackground3
    },
    invalid: {
        ':not(:focus-within),:hover:not(:focus-within)': {
            ..._react.shorthands.borderColor(_reacttheme.tokens.colorPaletteRedBorder2)
        }
    },
    invalidUnderline: {
        ':not(:focus-within),:hover:not(:focus-within)': {
            borderBottomColor: _reacttheme.tokens.colorPaletteRedBorder2
        }
    }
});
const useIconStyles = (0, _react.makeStyles)({
    icon: {
        boxSizing: 'border-box',
        color: _reacttheme.tokens.colorNeutralStrokeAccessible,
        display: 'block',
        position: 'absolute',
        pointerEvents: 'none',
        // the SVG must have display: block for accurate positioning
        // otherwise an extra inline space is inserted after the svg element
        '& svg': {
            display: 'block'
        }
    },
    disabled: {
        color: _reacttheme.tokens.colorNeutralForegroundDisabled,
        '@media (forced-colors: active)': {
            color: 'GrayText'
        }
    },
    small: {
        fontSize: iconSizes.small,
        height: iconSizes.small,
        right: _reacttheme.tokens.spacingHorizontalSNudge,
        width: iconSizes.small
    },
    medium: {
        fontSize: iconSizes.medium,
        height: iconSizes.medium,
        right: _reacttheme.tokens.spacingHorizontalMNudge,
        width: iconSizes.medium
    },
    large: {
        fontSize: iconSizes.large,
        height: iconSizes.large,
        right: _reacttheme.tokens.spacingHorizontalM,
        width: iconSizes.large
    }
});
const useSelectStyles_unstable = (state)=>{
    'use no memo';
    const { size, appearance } = state;
    const disabled = state.select.disabled;
    const invalid = `${state.select['aria-invalid']}` === 'true';
    const iconStyles = useIconStyles();
    const rootStyles = useRootStyles();
    const selectStyles = useSelectStyles();
    state.root.className = (0, _react.mergeClasses)(selectClassNames.root, rootStyles.base, state.root.className);
    state.select.className = (0, _react.mergeClasses)(selectClassNames.select, selectStyles.base, selectStyles[size], selectStyles[appearance], !disabled && appearance === 'outline' && selectStyles.outlineInteractive, !disabled && invalid && appearance !== 'underline' && selectStyles.invalid, !disabled && invalid && appearance === 'underline' && selectStyles.invalidUnderline, disabled && selectStyles.disabled, disabled && appearance === 'underline' && selectStyles.disabledUnderline, state.select.className);
    if (state.icon) {
        state.icon.className = (0, _react.mergeClasses)(selectClassNames.icon, iconStyles.icon, disabled && iconStyles.disabled, iconStyles[size], state.icon.className);
    }
    return state;
};
