'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useSelect_unstable", {
    enumerable: true,
    get: function() {
        return useSelect_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactfield = require("@fluentui/react-field");
const _reactutilities = require("@fluentui/react-utilities");
const _reacticons = require("@fluentui/react-icons");
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
const useSelect_unstable = (props, ref)=>{
    // Merge props from surrounding <Field>, if any
    props = (0, _reactfield.useFieldControlProps_unstable)(props, {
        supportsLabelFor: true,
        supportsRequired: true,
        supportsSize: true
    });
    const overrides = (0, _reactsharedcontexts.useOverrides_unstable)();
    var _overrides_inputDefaultAppearance;
    const { defaultValue, value, select, icon, root, appearance = (_overrides_inputDefaultAppearance = overrides.inputDefaultAppearance) !== null && _overrides_inputDefaultAppearance !== void 0 ? _overrides_inputDefaultAppearance : 'outline', onChange, size = 'medium' } = props;
    const nativeProps = (0, _reactutilities.getPartitionedNativeProps)({
        props,
        primarySlotTagName: 'select',
        excludedPropNames: [
            'appearance',
            'defaultValue',
            'onChange',
            'size',
            'value'
        ]
    });
    const state = {
        size,
        appearance,
        components: {
            root: 'span',
            select: 'select',
            icon: 'span'
        },
        select: _reactutilities.slot.always(select, {
            defaultProps: {
                defaultValue,
                value,
                ref,
                ...nativeProps.primary
            },
            elementType: 'select'
        }),
        icon: _reactutilities.slot.optional(icon, {
            renderByDefault: true,
            defaultProps: {
                children: /*#__PURE__*/ _react.createElement(_reacticons.ChevronDownRegular, null)
            },
            elementType: 'span'
        }),
        root: _reactutilities.slot.always(root, {
            defaultProps: nativeProps.root,
            elementType: 'span'
        })
    };
    state.select.onChange = (0, _reactutilities.useEventCallback)((event)=>{
        onChange === null || onChange === void 0 ? void 0 : onChange(event, {
            value: event.target.value
        });
    });
    return state;
};
