import type { ComponentProps } from '@fluentui/react-utilities';
import type { ComponentState } from '@fluentui/react-utilities';
import type { ForwardRefComponent } from '@fluentui/react-utilities';
import type { JSXElement } from '@fluentui/react-utilities';
import * as React_2 from 'react';
import type { Slot } from '@fluentui/react-utilities';
import { SlotClassNames } from '@fluentui/react-utilities';

/**
 * Render the final JSX of Select
 */
export declare const renderSelect_unstable: (state: SelectState) => JSXElement;

/**
 * Select component
 */
export declare const Select: ForwardRefComponent<SelectProps>;

export declare const selectClassNames: SlotClassNames<SelectSlots>;

/**
 * Data passed to the `onChange` callback when a new option is selected.
 */
export declare type SelectOnChangeData = {
    /**
     * Updated `<select>` value, taken from either the selected option's value prop or inner text.
     */
    value: string;
};

export declare type SelectProps = Omit<ComponentProps<Partial<SelectSlots>, 'select'>, 'size' | 'onChange'> & {
    /**
     * Controls the colors and borders of the Select.
     *
     * @default 'outline'
     */
    appearance?: 'outline' | 'underline' | 'filled-darker' | 'filled-lighter';
    /**
     * Called when the user changes the select element's value by selecting an option.
     */
    onChange?: (ev: React_2.ChangeEvent<HTMLSelectElement>, data: SelectOnChangeData) => void;
    /**
     * Matches the Input sizes
     *
     * @default 'medium'
     */
    size?: 'small' | 'medium' | 'large';
};

export declare type SelectSlots = {
    root: NonNullable<Slot<'span'>>;
    /** Primary slot: the actual `<select>` element */
    select: NonNullable<Slot<'select'>>;
    /** the icon, typically a down arrow */
    icon: Slot<'span'>;
};

export declare type SelectState = ComponentState<SelectSlots> & Required<Pick<SelectProps, 'appearance' | 'size'>>;

/**
 * Create the state required to render Select.
 *
 * The returned state can be modified with hooks such as useSelectStyles,
 * before being passed to renderSelect.
 *
 * @param props - props from this instance of Select
 * @param ref - reference to the `<select>` element in Select
 */
export declare const useSelect_unstable: (props: SelectProps, ref: React_2.Ref<HTMLSelectElement>) => SelectState;

/**
 * Apply styling to the Select slots based on the state
 */
export declare const useSelectStyles_unstable: (state: SelectState) => SelectState;

export { }
